/*
 * Decompiled with CFR 0.152.
 */
package com.centit.metaform.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.metaform.po.MetaFormModel;
import com.centit.metaform.po.MetaFormModelDraft;
import com.centit.metaform.service.MetaFormModelDraftManager;
import com.centit.metaform.service.MetaFormModelManager;
import com.centit.metaform.vo.MetaFormModelDraftParam;
import com.centit.product.oa.team.utils.ResourceBaseController;
import com.centit.product.oa.team.utils.ResourceLock;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/draft/metaformmodel"})
@Api(value="\u672a\u53d1\u5e03\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u7ba1\u7406", tags={"\u672a\u53d1\u5e03\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u7ba1\u7406"})
public class MetaFormModelDraftController
extends ResourceBaseController {
    @Autowired
    private MetaFormModelDraftManager metaFormModelDraftManager;
    @Autowired
    private MetaFormModelManager metaFormModelManager;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u672a\u53d1\u5e03\u6240\u6709\u901a\u7528\u6a21\u5757(\u53ef\u67e5\u8be2\u5de5\u4f5c\u6d41\u76f8\u5173\u6a21\u5757)")
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult draftFormModelList(String[] field, String optType, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetaFormModelDraftController.collectRequestParameters((HttpServletRequest)request);
        if (optType != null) {
            if ("flow".equalsIgnoreCase(optType)) {
                searchColumn.put("flowOptType", "1");
            } else if ("node".equalsIgnoreCase(optType)) {
                searchColumn.put("flowOptType", "2");
            } else {
                searchColumn.put("allFlowOpt", "all");
            }
        }
        JSONArray listObjects = this.metaFormModelDraftManager.listFormModeAsJson(field, searchColumn, pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (String[])field, (Class[])new Class[]{MetaFormModel.class});
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{MetaFormModel.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u672a\u53d1\u5e03\u7684\u901a\u7528\u6a21\u5757,\u5176\u4e2dkeyProps\u4e3a\u5176\u4e3b\u8868\u5bf9\u5e94\u7684\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0\u6570\u7ec4", response=MetaFormModel.class)
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public MetaFormModelDraft getDraftMetaFormModel(@PathVariable String modelId) {
        return this.metaFormModelDraftManager.getMetaFormModelDraftById(modelId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u672a\u53d1\u5e03\u7684\u901a\u7528\u6a21\u5757,\u5176\u4e2dkeyProps\u4e3a\u5176\u4e3b\u8868\u5bf9\u5e94\u7684\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0\u6570\u7ec4", response=MetaFormModel.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", type="path", value="\u5e94\u7528id\uff0capplicationId"), @ApiImplicitParam(name="keyWords", type="query", value="\u68c0\u7d22\u5173\u952e\u5b57", required=true), @ApiImplicitParam(name="formType", type="query", value="\u8868\u5355\u7c7b\u522b\uff0c\u9ed8\u8ba4\u4e3apc\uff0c\u79fb\u52a8\u4e3amobile"), @ApiImplicitParam(name="pageDesc", type="query", value="\u5206\u9875\u4fe1\u606f", dataTypeClass=PageDesc.class)})
    @RequestMapping(value={"/search/{osId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONArray searchMetaFormScript(@PathVariable String osId, String keyWords, String formType, PageDesc pageDesc) {
        return this.metaFormModelDraftManager.searchFormModeAsJson(keyWords, osId, formType, pageDesc);
    }

    @ApiOperation(value="\u65b0\u589e\u901a\u7528\u6a21\u5757")
    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public String createMetaFormModel(@RequestBody MetaFormModelDraft metaFormModel, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        metaFormModel.setRecorder(loginUser);
        this.metaFormModelDraftManager.saveMetaFormModelDraft(metaFormModel);
        return metaFormModel.getModelId();
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u901a\u7528\u6a21\u5757", notes="\u5982\u679cMetaFormModel\u4e5f\u9700\u8981\u5220\u9664\uff0c\u4f20\u5165\u53c2\u6570deleteMetaFormModel=true")
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public void deleteMetaFormModel(@PathVariable String modelId, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        MetaFormModelDraft metaFormModelDraft = this.metaFormModelDraftManager.getMetaFormModelDraftById(modelId);
        if (null == metaFormModelDraft) {
            throw new ObjectException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModelDraft.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        if (MapUtils.getBooleanValue((Map)MetaFormModelDraftController.collectRequestParameters((HttpServletRequest)request), (Object)"deleteMetaFormModel")) {
            this.metaFormModelDraftManager.deleteMetaFormModelDraftByIdWithMetaFormModel(modelId);
        } else {
            this.metaFormModelDraftManager.deleteMetaFormModelDraftById(modelId);
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u672a\u53d1\u5e03\u7684\u901a\u7528\u6a21\u5757")
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public Date updateMetaFormModel(@PathVariable String modelId, @RequestBody MetaFormModelDraft metaFormModel, HttpServletRequest request) {
        ResourceLock.lockResource((String)modelId, (String)WebOptUtils.getCurrentUserCode((HttpServletRequest)request), (HttpServletRequest)request);
        metaFormModel.setModelId(modelId);
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        metaFormModel.setRecorder(loginUser);
        this.metaFormModelDraftManager.updateMetaFormModelDraft(metaFormModel);
        return metaFormModel.getLastModifyDate();
    }

    @ApiOperation(value="\u53d1\u5e03\u8868\u5355")
    @RequestMapping(value={"/publish/{modelId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData publishMetaFormModel(@PathVariable String modelId, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u53ef\u80fd\u662f\u7528\u6237\u6ca1\u767b\u5f55\uff0c\u6216\u8005session\u5df2\u5931\u6548\uff01");
        }
        MetaFormModelDraft metaFormModelDraft = this.metaFormModelDraftManager.getMetaFormModelDraftById(modelId);
        if (metaFormModelDraft == null) {
            return ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u8868\u5355\uff01");
        }
        this.loginUserPermissionCheck(metaFormModelDraft.getOsId(), request);
        if (metaFormModelDraft.getLastModifyDate() != null && metaFormModelDraft.getPublishDate() != null && !metaFormModelDraft.getLastModifyDate().after(metaFormModelDraft.getPublishDate())) {
            return ResponseData.makeErrorMessage((String)"\u8868\u5355\u5df2\u53d1\u5e03\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u5e03\uff01");
        }
        metaFormModelDraft.setPublishDate(new Date());
        metaFormModelDraft.setLastModifyDate(metaFormModelDraft.getLastModifyDate());
        metaFormModelDraft.setRecorder(userCode);
        this.metaFormModelDraftManager.publishMetaFormModel(metaFormModelDraft);
        this.metaFormModelDraftManager.updateMetaFormModelDraft(metaFormModelDraft);
        return ResponseData.makeSuccessResponse((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u5355\u6240\u5c5e\u4e1a\u52a1\u6a21\u5757")
    @PutMapping(value={"/batchUpdateOptId"})
    @ResponseBody
    @Transactional(rollbackFor={Exception.class})
    public ResponseData batchUpdateOptId(@RequestBody MetaFormModelDraftParam metaFormModelDraftParam) {
        int[] metaFormModelDraftArr = this.metaFormModelDraftManager.batchUpdateOptId(metaFormModelDraftParam.getOptId(), Arrays.asList(metaFormModelDraftParam.getModelIds()));
        int[] metaFormModelArr = this.metaFormModelManager.batchUpdateOptId(metaFormModelDraftParam.getOptId(), Arrays.asList(metaFormModelDraftParam.getModelIds()));
        JSONObject result = new JSONObject();
        result.put((Object)"metaFormModelDraftArr", (Object)metaFormModelDraftArr);
        result.put((Object)"metaFormModelArr", (Object)metaFormModelArr);
        return ResponseData.makeSuccessResponse((String)result.toJSONString(new JSONWriter.Feature[0]));
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u5355\u6570\u636e\u53ef\u7528\u72b6\u6001(T:\u7981\u7528\uff0cF:\u542f\u7528)")
    @PutMapping(value={"/{modelId}/{validType}"})
    @ResponseBody
    @Transactional(rollbackFor={Exception.class})
    public ResponseData updateValidStatus(@PathVariable String modelId, @PathVariable String validType, HttpServletRequest request) {
        MetaFormModelDraft metaFormModelDraft = this.metaFormModelDraftManager.getMetaFormModelDraftById(modelId);
        if (metaFormModelDraft == null) {
            return ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u8868\u5355\uff01");
        }
        this.loginUserPermissionCheck(metaFormModelDraft.getOsId(), request);
        if (!StringBaseOpt.isNvl((String)validType) && "F".equals(validType)) {
            this.metaFormModelDraftManager.updateValidStatus(modelId, validType);
            this.metaFormModelManager.updateValidStatus(modelId, validType);
        } else if (!StringBaseOpt.isNvl((String)validType) && "T".equals(validType)) {
            this.metaFormModelDraftManager.updateValidStatus(modelId, validType);
            this.metaFormModelManager.updateValidStatus(modelId, validType);
        } else {
            return ResponseData.makeErrorMessage((int)412, (String)("\u975e\u6cd5\u4f20\u53c2\uff0c\u53c2\u6570\u5fc5\u987b\u4e3aT\u6216F,\u4f20\u5165\u7684\u53c2\u6570\u4e3a\uff1a" + validType));
        }
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u548c\u6e05\u7a7a\u56de\u6536\u7ad9")
    @PostMapping(value={"batchDeleteByModelIds"})
    @ApiImplicitParam(name="jsonObject", value="\u6279\u91cf\u5220\u9664-\u53c2\u6570\uff1a{modelIds:[\"modelId\"],osId:\"osId\"};\u6e05\u7a7a\u56de\u6536\u7ad9-\u53c2\u6570\uff1a{osId:\"osId\"}")
    @WrapUpResponseBody
    public void batchDeleteByModelIds(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        JSONArray modelIds = jsonObject.getJSONArray("modelIds");
        String osId = jsonObject.getString("osId");
        this.loginUserPermissionCheck(osId, request);
        if (modelIds != null && modelIds.size() > 0) {
            String[] ids = (String[])modelIds.toArray((Object[])new String[modelIds.size()]);
            this.metaFormModelDraftManager.batchDeleteByIds(ids);
            this.metaFormModelManager.batchDeleteByIds(ids);
        } else if (!StringBaseOpt.isNvl((String)osId)) {
            this.metaFormModelDraftManager.clearTrashStand(osId);
            this.metaFormModelManager.clearTrashStand(osId);
        }
    }

    private void loginUserPermissionCheck(String osId, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)osId)) {
            throw new ObjectException(500, "osId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(osId, loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
    }

    @ApiOperation(value="\u8868\u5355\u590d\u5236\u63a5\u53e3")
    @PostMapping(value={"/metaFormCopy"})
    @ApiImplicitParam(name="jsonObject", value="API\u590d\u5236\u63a5\u53e3-\u53c2\u6570\uff1a{\"modelId\":\"\",\"modelName\":\"\",\"osId\":\"\",\"optId\":\"\"}")
    @WrapUpResponseBody
    public ResponseData metaFormCopy(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String modelId = jsonObject.getString("modelId");
        String osId = jsonObject.getString("osId");
        String modelName = jsonObject.getString("modelName");
        String optId = jsonObject.getString("optId");
        if (StringUtils.isBlank((CharSequence)modelId) || StringUtils.isBlank((CharSequence)modelName) || StringUtils.isBlank((CharSequence)optId)) {
            return ResponseData.makeErrorMessage((String)"\u7f3a\u5c11\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
        }
        MetaFormModelDraft metaFormModelDraft = this.metaFormModelDraftManager.getMetaFormModelDraftById(modelId);
        if (metaFormModelDraft == null) {
            return ResponseData.makeErrorMessage((String)"\u590d\u5236\u7684\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        this.loginUserPermissionCheck(osId, request);
        metaFormModelDraft.setOsId(osId);
        metaFormModelDraft.setModelId(null);
        metaFormModelDraft.setModelName(modelName);
        metaFormModelDraft.setOptId(optId);
        this.metaFormModelDraftManager.saveMetaFormModelDraft(metaFormModelDraft);
        return ResponseData.successResponse;
    }
}

