/*
 * Decompiled with CFR 0.152.
 */
package com.centit.metaform.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.metaform.dao.MetaFormModelDao;
import com.centit.metaform.po.MetaFormModel;
import com.centit.metaform.service.MetaFormModelManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="metaFormModelManagerImpl")
public class MetaFormModelManagerImpl
implements MetaFormModelManager {
    @Autowired
    private MetaFormModelDao metaFormModelDao;

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNewMetaFormModel(MetaFormModel metaFormModel) {
        this.metaFormModelDao.saveNewObject(metaFormModel);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void updateMetaFormModel(MetaFormModel metaFormModel) {
        this.metaFormModelDao.updateObject(metaFormModel);
        this.metaFormModelDao.saveObjectReferences(metaFormModel);
    }

    @Transactional
    public JSONArray listFormModeAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.metaFormModelDao.listFormModeAsJson(fields, filterMap, pageDesc);
    }

    public int[] batchUpdateOptId(String optId, List<String> modleIds) {
        return this.metaFormModelDao.batchUpdateOptId(optId, modleIds);
    }

    public List listModelByOptId(String optId) {
        optId = this.getOptIdWithCommon(optId);
        List metaFormModelList = this.metaFormModelDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optids", optId}));
        return metaFormModelList.stream().map(metaFormModel -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("modelId", metaFormModel.getModelId());
            map.put("modelName", metaFormModel.getModelName());
            return map;
        }).collect(Collectors.toList());
    }

    public MetaFormModel getObjectById(String modelId) {
        return this.metaFormModelDao.getObjectById((Object)modelId);
    }

    public void deleteObjectById(String modelId) {
        this.metaFormModelDao.deleteObjectById((Object)modelId);
    }

    public int countMetaFormModels(Map<String, Object> params) {
        return this.metaFormModelDao.countObjectByProperties(params);
    }

    public void updateValidStatus(String modelId, String validType) {
        this.metaFormModelDao.updateValidStatus(modelId, validType);
    }

    public void batchDeleteByIds(String[] modleIds) {
        this.metaFormModelDao.batchDeleteByIds(modleIds);
    }

    public int clearTrashStand(String osId) {
        return this.metaFormModelDao.clearTrashStand(osId);
    }

    private String getOptIdWithCommon(String optId) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        OptInfo commonOptInfo = CodeRepositoryUtil.getCommonOptId((String)topUnit, (String)optId);
        if (commonOptInfo != null) {
            String commonOptId = commonOptInfo.getOptId();
            return StringBaseOpt.concat((Object[])new Object[]{optId, ",", commonOptId});
        }
        return optId;
    }
}

