/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.commons;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.msgpusher.commons.MsgPushConfig;
import com.centit.msgpusher.commons.OSMsgPushInfo;
import com.centit.msgpusher.commons.OptMsgPushInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MsgPushConfigImpl
implements MsgPushConfig {
    private List<OSMsgPushInfo> osInfos;
    @Resource
    private MsgPushConfig msgPushConfig;

    public List<OSMsgPushInfo> getOsInfos() {
        return this.osInfos;
    }

    public void setOsInfos(List<OSMsgPushInfo> osInfos) {
        this.osInfos = osInfos;
    }

    @PostConstruct
    public void init() {
        this.osInfos = new ArrayList<OSMsgPushInfo>();
        this.reloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadConfig() {
        BufferedReader reader = null;
        String lastStr = "";
        try {
            String path = this.getClass().getClassLoader().getResource("").toURI().getPath();
            System.out.println("path=" + path);
            FileInputStream fileInputStream = new FileInputStream(path + "msg_pusher_metadata.json");
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
            reader = new BufferedReader(inputStreamReader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                lastStr = lastStr + tempString;
            }
            reader.close();
            JSONObject jo = JSONObject.parseObject((String)lastStr);
            System.out.println("jo=" + jo);
            String con = jo.get("osInfos").toString();
            JSONArray jsonArray = JSONArray.parseArray((String)con, (JSONReader.Feature[])new JSONReader.Feature[0]);
            System.out.println("con=" + con);
            for (int i = 0; i < jsonArray.size(); ++i) {
                OSMsgPushInfo osMsgPushInfo = new OSMsgPushInfo();
                JSONObject json = JSONObject.parseObject((String)jsonArray.get(i).toString());
                osMsgPushInfo.setOsId(json.get("osId").toString());
                osMsgPushInfo.setAndroidPkg(json.get("androidPkg").toString());
                String opt = json.get("optInfos").toString();
                JSONArray jsonOptArray = JSONArray.parseArray((String)opt, (JSONReader.Feature[])new JSONReader.Feature[0]);
                ArrayList<OptMsgPushInfo> optInfos = new ArrayList<OptMsgPushInfo>();
                for (int j = 0; j < jsonOptArray.size(); ++j) {
                    OptMsgPushInfo optMsgPushInfo = new OptMsgPushInfo();
                    JSONObject jsonOpt = JSONObject.parseObject((String)jsonOptArray.get(j).toString());
                    optMsgPushInfo.setOptId(jsonOpt.get("optId").toString());
                    optMsgPushInfo.setAndroidView(jsonOpt.get("androidView").toString());
                    optInfos.add(optMsgPushInfo);
                }
                osMsgPushInfo.setOptInfos(optInfos);
                this.osInfos.add(osMsgPushInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public OSMsgPushInfo getOSConfig(String osId) {
        for (OSMsgPushInfo osinfo : this.osInfos) {
            if (!StringUtils.equals((CharSequence)osinfo.getOsId(), (CharSequence)osId)) continue;
            return osinfo;
        }
        return null;
    }

    @Override
    public List<OSMsgPushInfo> getOsConfig() {
        ArrayList<OSMsgPushInfo> list = new ArrayList<OSMsgPushInfo>();
        for (OSMsgPushInfo osinfo : this.osInfos) {
            list.add(osinfo);
        }
        return list;
    }
}

