/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.msgpusher.po.MessageDelivery;
import com.centit.msgpusher.po.UserMsgPoint;
import com.centit.msgpusher.service.MessageDeliveryManager;
import com.centit.msgpusher.service.UserMsgPointManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/msgdlvry"})
public class MessageDeliveryController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(MessageDeliveryController.class);
    @Resource
    private MessageDeliveryManager messageDeliveryManager;
    @Resource
    private UserMsgPointManager userMsgPointManager;

    private MessageDelivery fetchMessageDelivery(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        if (StringUtils.indexOf((CharSequence)contentType, (CharSequence)"form") > 0) {
            Map params = request.getParameterMap();
            HashMap objMap = new HashMap();
            for (Map.Entry ent : params.entrySet()) {
                if (ent.getValue() == null || ((String[])ent.getValue()).length <= 0) continue;
                objMap.put(ent.getKey(), ((String[])ent.getValue())[0]);
            }
            MessageDelivery msg = (MessageDelivery)JSON.parseObject((String)JSON.toJSONString(objMap), MessageDelivery.class);
            return msg;
        }
        if (StringUtils.indexOf((CharSequence)contentType, (CharSequence)"json") > 0) {
            MessageDelivery msg = (MessageDelivery)JSON.parseObject((InputStream)request.getInputStream(), MessageDelivery.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            return msg;
        }
        return null;
    }

    private UserMsgPoint fetchUserMsgPoint(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        if (StringUtils.indexOf((CharSequence)contentType, (CharSequence)"form") > 0) {
            Map params = request.getParameterMap();
            HashMap objMap = new HashMap();
            for (Map.Entry ent : params.entrySet()) {
                if (ent.getValue() == null || ((String[])ent.getValue()).length <= 0) continue;
                objMap.put(ent.getKey(), ((String[])ent.getValue())[0]);
            }
            UserMsgPoint userMsgPoint = (UserMsgPoint)JSON.parseObject((String)JSON.toJSONString(objMap), UserMsgPoint.class);
            return userMsgPoint;
        }
        if (StringUtils.indexOf((CharSequence)contentType, (CharSequence)"json") > 0) {
            UserMsgPoint userMsgPoint = (UserMsgPoint)JSON.parseObject((InputStream)request.getInputStream(), UserMsgPoint.class, (JSONReader.Feature[])new JSONReader.Feature[0]);
            return userMsgPoint;
        }
        return null;
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData registerUserMsgPoint(HttpServletRequest request) throws IOException {
        UserMsgPoint userMsgPoint = this.fetchUserMsgPoint(request);
        if (userMsgPoint == null) {
            return ResponseData.makeErrorMessage((int)400, (String)"\u8868\u5355\u53c2\u6570\u9519\u8bef");
        }
        this.userMsgPointManager.registerUserPoint(userMsgPoint);
        return this.messageDeliveryManager.pushAgain(userMsgPoint.getUserCode(), "pusher");
    }

    @RequestMapping(value={"/push"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData pushMessage(HttpServletRequest request) throws IOException {
        MessageDelivery msg = this.fetchMessageDelivery(request);
        if (msg == null) {
            return ResponseData.makeErrorMessage((int)400, (String)"\u8868\u5355\u53c2\u6570\u9519\u8bef");
        }
        try {
            return this.messageDeliveryManager.pushMessage(msg);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResponseData.makeErrorMessage((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/pushall"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData pushMessageToAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageDelivery msg = this.fetchMessageDelivery(request);
        if (msg == null) {
            return ResponseData.makeErrorMessage((int)400, (String)"\u8868\u5355\u53c2\u6570\u9519\u8bef");
        }
        try {
            return this.messageDeliveryManager.pushMsgToAll(msg);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ResponseData.makeErrorMessage((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public void deleteRecords(HttpServletResponse response) {
        this.messageDeliveryManager.deleteRecords();
        JsonResultUtils.writeSingleDataJson((Object)"\u5220\u9664\u4e86\u8bb0\u5f55\u3002", (HttpServletResponse)response);
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public void viewRecords(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map queryParamsMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.messageDeliveryManager.listMessageDeliverysAsJson(null, queryParamsMap, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/listAllPlanPush"}, method={RequestMethod.GET})
    public void listAllPlanPush(HttpServletRequest request, HttpServletResponse response, PageDesc pageDesc) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String osId = request.getParameter("osId");
        String optId = request.getParameter("optId");
        String pushState = request.getParameter("pushState");
        Date begin = DatetimeOpt.convertStringToDate((String)request.getParameter("begin"), (String)"yyyy-MM-dd HH:mm:ss");
        Date end = DatetimeOpt.convertStringToDate((String)request.getParameter("end"), (String)"yyyy-MM-dd HH:mm:ss");
        map.put("osId", osId);
        map.put("optId", optId);
        map.put("pushState", StringUtils.isBlank((CharSequence)pushState) ? "0" : pushState);
        map.put("begin", begin);
        map.put("end", end);
        JSONArray listObjects = this.messageDeliveryManager.listAllPlanPush(map, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/cancelPlanPush"}, method={RequestMethod.POST})
    public void cancelPlanPush(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="msgId") String msgId) throws IOException {
        this.messageDeliveryManager.changePushState(msgId);
    }
}

