/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.controller;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.msgpusher.po.MessageDelivery;
import com.centit.msgpusher.service.MessageDeliveryManager;
import com.centit.msgpusher.service.MsgPusherCenter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testMsgPush"})
@Api(tags={"\u6d4b\u8bd5\u63a7\u5236\u5668"})
public class TestMsgPushController
extends BaseController {
    private static final Log log = LogFactory.getLog(TestMsgPushController.class);
    @Resource
    private MessageDeliveryManager messageDeliveryManager;
    @Resource
    MsgPusherCenter msgPusherCenter;

    @ApiOperation(value="\u70b9\u5bf9\u70b9\u6d88\u606f\u63a8\u9001\u6d4b\u8bd5")
    @RequestMapping(value={"/pushmsg/{userCode}"}, method={RequestMethod.GET})
    public ResponseData testPushMessage(@PathVariable String userCode, HttpServletResponse response) throws IOException {
        try {
            MessageDelivery msg = new MessageDelivery();
            msg.setPushType("A");
            msg.setOptId("test");
            msg.setNoticeTypes("email,socket");
            msg.setMsgSender("system");
            msg.setMsgType("message");
            msg.setMsgReceiver(userCode);
            msg.setMsgSubject("\u6d4b\u8bd5\u6d88\u606f");
            msg.setMsgContent("\u60a8\u6536\u5230\u4e00\u6761\u6d4b\u8bd5\u6d88\u606f\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\uff1a");
            return this.messageDeliveryManager.pushMessage(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.makeErrorMessage((int)500, (String)"\u670d\u52a1\u5668\u5904\u7406\u5f02\u5e38\uff01");
        }
    }

    @ApiOperation(value="\u7fa4\u53d1\u6d88\u606f\u63a8\u9001\u6d4b\u8bd5")
    @RequestMapping(value={"/pushallmsg"}, method={RequestMethod.GET})
    public ResponseData testPushMessage(HttpServletResponse response) throws IOException {
        try {
            MessageDelivery msg = new MessageDelivery();
            msg.setPushType("B");
            msg.setOptId("testall");
            msg.setNoticeTypes("email,socket");
            msg.setMsgSender("zhouchao");
            msg.setMsgType("message");
            msg.setMsgSubject("\u7fa4\u53d1\u6d4b\u8bd5\u6d88\u606f");
            msg.setMsgContent("\u60a8\u6536\u5230\u4e00\u6761\u6d4b\u8bd5\u6d88\u606f\uff0c\u8bf7\u70b9\u51fb\u67e5\u770b\uff1a");
            return this.messageDeliveryManager.pushMsgToAll(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseData.makeErrorMessage((int)500, (String)"\u670d\u52a1\u5668\u5904\u7406\u5f02\u5e38\uff01");
        }
    }

    @RequestMapping(value={"/push/{msgType}/{userCode}"}, method={RequestMethod.GET})
    public void testPushStatus(@PathVariable String msgType, @PathVariable String userCode, @RequestParam(value="content") String content, HttpServletResponse response) {
        MessageDelivery msg = new MessageDelivery();
        try {
            msg.setPushType("A");
            msg.setMsgSender("system");
            msg.setMsgType(msgType);
            msg.setMsgReceiver(userCode);
            msg.setMsgSubject("\u6d4b\u8bd5\u5176\u4ed6\u7c7b\u522b\u6d88\u606f");
            msg.setMsgContent(content);
            this.messageDeliveryManager.pushMessage(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JsonResultUtils.writeSingleDataJson((Object)msg, (HttpServletResponse)response);
    }
}

