/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.controller;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.msgpusher.po.UserMsgPoint;
import com.centit.msgpusher.service.UserMsgPointManager;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/userpoint"})
public class UserMsgPointController
extends BaseController {
    private static final Log log = LogFactory.getLog(UserMsgPointController.class);
    @Resource
    private UserMsgPointManager userMsgPointMag;

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.userMsgPointMag.listUserMsgPointsAsJson(field, searchColumn, pageDesc);
        if (null == pageDesc) {
            JsonResultUtils.writeSingleDataJson((Object)listObjects, (HttpServletResponse)response);
            return;
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}/{osId}"}, method={RequestMethod.GET})
    public void getUserMsgPoint(@PathVariable String userCode, @PathVariable String osId, HttpServletResponse response) {
        UserMsgPoint userMsgPoint = (UserMsgPoint)this.userMsgPointMag.getObjectById((Serializable)((Object)userCode));
        JsonResultUtils.writeSingleDataJson((Object)userMsgPoint, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createUserMsgPoint(@RequestBody @Valid UserMsgPoint userMsgPoint, HttpServletResponse response) {
        this.userMsgPointMag.saveNewObject(userMsgPoint);
        JsonResultUtils.writeSingleDataJson((Object)userMsgPoint.getUserCode(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}/{osId}"}, method={RequestMethod.DELETE})
    public void deleteUserMsgPoint(@PathVariable String userCode, @PathVariable String osId, HttpServletResponse response) {
        this.userMsgPointMag.deleteObjectById((Serializable)((Object)userCode));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{userCode}/{osId}"}, method={RequestMethod.PUT})
    public void updateUserMsgPoint(@PathVariable String userCode, @PathVariable String osId, @RequestBody @Valid UserMsgPoint userMsgPoint, HttpServletResponse response) {
        UserMsgPoint dbUserMsgPoint = (UserMsgPoint)this.userMsgPointMag.getObjectById((Serializable)((Object)userCode));
        if (null == userMsgPoint) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbUserMsgPoint.copy(userMsgPoint);
        this.userMsgPointMag.mergeObject(dbUserMsgPoint);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

