/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.msgpusher.po.MessageDelivery;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Repository;

@Repository
public class MessageDeliveryDao
extends BaseDaoImpl<MessageDelivery, String> {
    public static final Log log = LogFactory.getLog(MessageDeliveryDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("notifyId", "EQUAL");
        filterField.put("notifySender", "EQUAL");
        filterField.put("notifyReceiver", "EQUAL");
        filterField.put("msgSubject", "EQUAL");
        filterField.put("msgContent", "EQUAL");
        filterField.put("relUrl", "EQUAL");
        filterField.put("noticeTypes", "EQUAL");
        filterField.put("notifyState", "EQUAL");
        filterField.put("errorMsg", "EQUAL");
        filterField.put("planNotifyTime", "EQUAL");
        filterField.put("notifyTime", "EQUAL");
        filterField.put("osId", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("optMethod", "EQUAL");
        filterField.put("optTag", "EQUAL");
        return filterField;
    }

    public List<MessageDelivery> listMsgNoPush(PageDesc pageDesc) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        return this.listObjectsByFilter("where PUSH_STATE='0' and PLAN_PUSH_TIME < ? and (VALID_PERIOD is null or VALID_PERIOD > ?) ", new Object[]{currentDate, currentDate});
    }

    public JSONArray listPlanPushMsg(BaseDaoImpl baseDao, Map<String, Object> queryParamsMap, PageDesc pageDesc) {
        String queryStatement = "select h.msgSender, h.msgReceiver, h.pushType, h.pushState,h.planPushTime,h.pushTime,h.msgId from MessageDelivery h WHERE 1=1  [ :osId | and h.osId = :osId ] [ :optId | and h.optId = :optId ] [ :pushState | and h.pushState = :pushState ] [ :begin | and h.createTime > :begin ] [ :end | and h.createTime < :end ]";
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)queryStatement, queryParamsMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)qap.getQuery(), (Map)qap.getParams(), (PageDesc)pageDesc);
    }

    public List<MessageDelivery> listPushAgain(String userCode, String osId) {
        Date currentDate = DatetimeOpt.currentUtilDate();
        return this.listObjectsByFilter("WHERE OS_ID =? AND MSG_RECEIVER=? AND PUSH_STATE='2' AND  PLAN_PUSH_TIME < ? and (VALID_PERIOD is null or VALID_PERIOD > ?)", new Object[]{osId, userCode, currentDate, currentDate});
    }
}

