/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import com.centit.msgpusher.dao.MessageDeliveryDao;
import com.centit.msgpusher.dao.UserMsgPointDao;
import com.centit.msgpusher.po.MessageDelivery;
import com.centit.msgpusher.po.UserMsgPoint;
import com.centit.msgpusher.service.MessageDeliveryManager;
import com.centit.msgpusher.service.MsgPusherCenter;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="messageDeliveryManager")
public class MessageDeliveryManagerImpl
extends BaseEntityManagerImpl<MessageDelivery, String, MessageDeliveryDao>
implements MessageDeliveryManager {
    public static final Logger logger = LoggerFactory.getLogger(MessageDeliveryManagerImpl.class);
    @Value(value="${plugins.msg.validtyPeriod:1}")
    private int validtyPeriod;
    @Resource(name="msgPusherCenter")
    private MsgPusherCenter msgPusherCenter;
    @Resource(name="userMsgPointDao")
    private UserMsgPointDao userMsgPointDao;
    private MessageDeliveryDao messageDeliveryDao;

    @Resource(name="messageDeliveryDao")
    @NotNull
    public void setMessageDeliveryDao(MessageDeliveryDao baseDao) {
        this.messageDeliveryDao = baseDao;
        this.setBaseDao(this.messageDeliveryDao);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listMessageDeliverysAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.mapJsonArray((JSONArray)this.messageDeliveryDao.listObjectsPartFieldByPropertiesAsJson(filterMap, CollectionsOpt.arrayToList((Object[])fields), pageDesc), (Class[])new Class[]{MessageDelivery.class});
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseData pushMessage(MessageDelivery msg) {
        if (msg.getMsgExpireSeconds() == null || msg.getMsgExpireSeconds() == 0) {
            msg.setMsgExpireSeconds(18000);
        }
        if (StringUtils.isBlank((CharSequence)msg.getMsgReceiver())) {
            return new ResponseMapData(711, "\u8bf7\u586b\u5199\u63a5\u6536\u4eba");
        }
        UserMsgPoint userMsgPoint = (UserMsgPoint)this.userMsgPointDao.getObjectById(msg.getMsgReceiver());
        if (userMsgPoint == null) {
            return this.makeErrorPushResult("\u63a5\u6536\u4eba\u4e0d\u5b58\u5728", msg);
        }
        JSONObject json = new JSONObject();
        Date planPushTime = msg.getPlanPushTime();
        msg.setPushType("0");
        if (planPushTime != null && planPushTime.after(DatetimeOpt.currentUtilDate())) {
            msg.setPushState("0");
            this.messageDeliveryDao.saveNewObject(msg);
            return ResponseData.successResponse;
        }
        try {
            ResponseData pushResult = this.msgPusherCenter.pushMessage(msg, userMsgPoint);
            if (3 == pushResult.getCode()) {
                msg.setPushState("3");
            } else {
                msg.setPushState(pushResult.getCode() == 0 ? "1" : "2");
            }
            msg.setPushTime(DatetimeOpt.currentUtilDate());
            msg.setPushResult(json.toString());
            if (msg.getValidPeriod() == null) {
                msg.setValidPeriod(this.changeDate(DatetimeOpt.currentUtilDate(), 1));
            }
            if (StringUtils.isBlank((CharSequence)msg.getMsgId())) {
                this.messageDeliveryDao.saveNewObject(msg);
            } else {
                this.messageDeliveryDao.updateObject(msg);
            }
            return pushResult;
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u670d\u52a1\u5f02\u5e38");
            return this.makeErrorPushResult("\u63a8\u9001\u670d\u52a1\u5f02\u5e38", msg);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseData pushMsgToAll(MessageDelivery msg) {
        String notifyType = msg.getNoticeTypes();
        if (StringUtils.isBlank((CharSequence)notifyType) || "U".equals(notifyType)) {
            return this.makeErrorPushResult("\u672a\u6307\u5b9a\u63a8\u9001\u65b9\u5f0f", msg);
        }
        if (msg.getMsgExpireSeconds() == null || msg.getMsgExpireSeconds() == 0) {
            msg.setMsgExpireSeconds(18000);
        }
        JSONObject json = new JSONObject();
        Date planPushTime = msg.getPlanPushTime();
        msg.setPushType("1");
        if (planPushTime != null && planPushTime.after(DatetimeOpt.currentUtilDate())) {
            msg.setPushState("0");
            this.messageDeliveryDao.saveNewObject(msg);
            return ResponseData.successResponse;
        }
        try {
            ResponseData pushResult = this.msgPusherCenter.pushMsgToAll(msg);
            if (3 == pushResult.getCode()) {
                msg.setPushState("3");
            } else {
                msg.setPushState(pushResult.getCode() == 0 ? "1" : "2");
            }
            msg.setPushTime(DatetimeOpt.currentUtilDate());
            msg.setPushResult(json.toString());
            if (msg.getValidPeriod() == null) {
                msg.setValidPeriod(this.changeDate(DatetimeOpt.currentUtilDate(), 1));
            }
            if (StringUtils.isBlank((CharSequence)msg.getMsgId())) {
                this.messageDeliveryDao.saveNewObject(msg);
            } else {
                this.messageDeliveryDao.updateObject(msg);
            }
            return pushResult;
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u670d\u52a1\u5f02\u5e38");
            return this.makeErrorPushResult("\u63a8\u9001\u670d\u52a1\u5f02\u5e38", msg);
        }
    }

    private Date changeDate(Date time, int n) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        ((Calendar)calendar).add(5, n);
        return calendar.getTime();
    }

    private ResponseData makeErrorPushResult(String errorReason, MessageDelivery msg) {
        JSONObject json = new JSONObject();
        json.put((Object)"error", (Object)errorReason);
        msg.setPushResult(json.toString());
        msg.setPushState("2");
        this.messageDeliveryDao.saveNewObject(msg);
        return ResponseData.makeErrorMessage((int)2, (String)errorReason);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteRecords() {
        Date validDate = new Date(System.currentTimeMillis() - (long)this.validtyPeriod * 86400000L);
        String hql = "delete from IPushMessage m where m.pushTime<=?";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.messageDeliveryDao, (String)hql, (Object[])new Object[]{validDate});
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<MessageDelivery> viewRecords(String osId, String optId, Date pushTimeStart, Date pushTimeEnd) {
        String hql = "where osId=? and optId=? and pushTime>? and pushTime<=?";
        List msgList = this.messageDeliveryDao.listObjectsByFilter(hql, new Object[]{osId, optId, pushTimeStart, pushTimeEnd});
        return msgList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listAllPlanPush(Map<String, Object> queryParamsMap, PageDesc pageDesc) {
        JSONArray dataList = this.messageDeliveryDao.listPlanPushMsg(this.baseDao, queryParamsMap, pageDesc);
        return dataList;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public String changePushState(String msgId) {
        MessageDelivery msg = (MessageDelivery)this.messageDeliveryDao.getObjectById(msgId);
        msg.setPushState("4");
        this.messageDeliveryDao.mergeObject(msg);
        return msgId;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseData pushAgain(String userCode, String osId) {
        List<MessageDelivery> msgList = this.messageDeliveryDao.listPushAgain(userCode, osId);
        for (MessageDelivery msg : msgList) {
            try {
                this.pushMessage(msg);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ResponseData.successResponse;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void timerPusher() {
        List<MessageDelivery> list;
        do {
            if ((list = this.messageDeliveryDao.listMsgNoPush(new PageDesc(1, 100))) == null || list.size() <= 0) continue;
            for (MessageDelivery messageDelivery : list) {
                try {
                    if (messageDelivery.getPushType().equals("0")) {
                        this.pushMessage(messageDelivery);
                        continue;
                    }
                    if (!messageDelivery.getPushType().equals("1")) continue;
                    this.pushMsgToAll(messageDelivery);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } while (list.size() == 100);
    }
}

