/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.msgpusher.po.MessageDelivery;
import com.centit.msgpusher.po.UserMsgPoint;
import com.centit.msgpusher.service.MsgPusherCenter;
import com.centit.support.common.DoubleAspect;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class MsgPusherCenterImpl
implements MsgPusherCenter {
    private String defaultPushType;
    private Map<String, MessageSender> pusherMap = new HashMap<String, MessageSender>();

    @Override
    public void registerMessageSender(String sendType, MessageSender sender) {
        this.pusherMap.put(sendType, sender);
    }

    public void setDefaultPushType(String defaultPushType) {
        this.defaultPushType = defaultPushType;
    }

    public String getDefaultPushType() {
        return this.defaultPushType;
    }

    @Override
    public ResponseData pushMessage(MessageDelivery msg, UserMsgPoint userMsgPoint) throws Exception {
        if (this.pusherMap.size() == 0) {
            return ResponseData.makeErrorMessage((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5fc5\u987b\u8c03\u7528registerMessageSender()\u6307\u5b9a\u6d88\u606f\u53d1\u9001\u7c7b\u578b\uff01\u4f8b\u5982\uff1a\u5fae\u4fe1\uff0c\u77ed\u4fe1");
        }
        HashMap<String, ResponseData> resultMap = new HashMap<String, ResponseData>();
        String noticeTypes = msg.getNoticeTypes();
        if (!StringUtils.isBlank((CharSequence)noticeTypes)) {
            String[] noticeTypeArray = noticeTypes.split(",");
            for (int i = 0; i < noticeTypeArray.length; ++i) {
                if (this.pusherMap.get(noticeTypeArray[i]) == null) continue;
                ResponseData pushResultTemp = this.pusherMap.get(noticeTypeArray[i]).sendMessage(msg.getMsgSender(), msg.getMsgReceiver(), msg.toNoticeMessage());
                resultMap.put(noticeTypeArray[i], pushResultTemp);
            }
            if (resultMap.size() == 0) {
                return null;
            }
        }
        if (resultMap.size() == 1) {
            return (ResponseData)resultMap.values().iterator().next();
        }
        JSONObject jsonObject = new JSONObject();
        AtomicBoolean flag = new AtomicBoolean(true);
        resultMap.forEach((key, value) -> {
            if (value.getCode() != 0) {
                jsonObject.put(key, (Object)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + value.getMessage()));
                flag.set(false);
            } else {
                jsonObject.put(key, (Object)("\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01\u8fd4\u56de\u4fe1\u606f\uff1a" + value.getMessage()));
            }
        });
        return flag.get() ? ResponseData.makeResponseData((Map)jsonObject) : ResponseData.makeErrorMessageWithData((Object)jsonObject, (int)3, (String)"\u90e8\u5206\u5931\u8d25,\u8bf7\u89c1\u8fd4\u56de\u8be6\u60c5!");
    }

    @Override
    public ResponseData pushMsgToAll(MessageDelivery msg) throws Exception {
        if (this.pusherMap.size() == 0) {
            return ResponseData.makeErrorMessage((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5fc5\u987b\u8c03\u7528registerMessageSender()\u6307\u5b9a\u6d88\u606f\u53d1\u9001\u7c7b\u578b\uff01\u4e3e\u4f8b\uff1a A\uff1aapp\u63a8\u9001\uff0c S\uff1a\u77ed\u4fe1  C\uff1a\u5fae\u4fe1  E\uff1a\u90ae\u4ef6");
        }
        String noticeTypes = msg.getNoticeTypes();
        HashMap<String, ResponseData> map = new HashMap<String, ResponseData>();
        String[] noticeTypeArray = noticeTypes.split(",");
        for (int i = 0; i < noticeTypeArray.length; ++i) {
            if (this.pusherMap.get(noticeTypeArray[i]) == null) continue;
            ResponseData pushResultTemp = this.pusherMap.get(noticeTypeArray[i]).broadcastMessage(msg.getMsgSender(), msg.toNoticeMessage(), DoubleAspect.YES);
            map.put(noticeTypeArray[i], pushResultTemp);
        }
        if (map.size() == 0) {
            return null;
        }
        int eerors = 0;
        StringBuilder errormsg = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            ResponseData resp = (ResponseData)entry.getValue();
            if (resp.getCode() != 0) {
                ++eerors;
                errormsg.append("\u53d1\u9001\u65b9\u5f0f\uff1a").append((String)entry.getKey()).append(":\u5e7f\u64ad\u6d88\u606f\u51fa\u9519\uff0c\u9519\u8bef\u63d0\u793a\uff1a").append(resp.getMessage()).append("\u3002\r\n");
                continue;
            }
            errormsg.append("\u53d1\u9001\u65b9\u5f0f\uff1a").append((String)entry.getKey()).append(":\u5e7f\u64ad\u6d88\u606f\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a").append(resp.getMessage()).append("\u3002\r\n");
        }
        return ResponseData.makeErrorMessage((int)(eerors == 0 ? 0 : (eerors == map.size() ? 2 : 3)), (String)errormsg.toString());
    }
}

