/*
 * Decompiled with CFR 0.152.
 */
package com.centit.msgpusher.msgpusher.websocket;

import com.centit.msgpusher.msgpusher.websocket.SocketMsgPusher;
import javax.annotation.Resource;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.server.standard.SpringConfigurator;

@ServerEndpoint(value="/pusher/{osId}/{userCode}", configurator=SpringConfigurator.class)
@Service
public class SocketPusherListener {
    @Resource
    @Autowired
    protected SocketMsgPusher socketMsgPusher;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="osId") String osId, @PathParam(value="userCode") String userCode) {
        this.socketMsgPusher.signInUser(osId, userCode, session);
    }

    @OnClose
    public void onClose(Session session) {
        this.socketMsgPusher.signOutUser(session);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.socketMsgPusher.recvMessage(session, message);
    }

    @OnError
    public void onError(Throwable error) {
        error.printStackTrace();
    }
}

