/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.optlog;

import com.alibaba.fastjson.JSON;
import com.centit.framework.appclient.AppSession;
import com.centit.framework.appclient.HttpReceiveJSON;
import com.centit.framework.appclient.RestfulHttpRequest;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.network.UrlOptUtils;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OptLogClient
implements OperationLogWriter {
    private static final Logger logger = LoggerFactory.getLogger(OptLogClient.class);
    @Value(value="${optlog.server.url:}")
    private String optlogUrl;
    @Value(value="${optlog.server.loginUrl:}")
    private String optlogLoginUrl;
    @Value(value="${optlog.server.username:}")
    private String optlogUser;
    @Value(value="${optlog.server.password:}")
    private String optlogPassword;
    protected AppSession appSession;

    @PostConstruct
    public void init() {
        this.appSession = new AppSession();
        this.appSession.setAppServerUrl(this.optlogUrl);
        if (StringUtils.isNotBlank((CharSequence)this.optlogLoginUrl)) {
            this.appSession.setAppLoginUrl(this.optlogLoginUrl);
        }
        this.appSession.setNeedAuthenticated(StringUtils.isNotBlank((CharSequence)this.optlogUser) && StringUtils.isNotBlank((CharSequence)this.optlogPassword));
        this.appSession.setUserCode(this.optlogUser);
        this.appSession.setPassword(this.optlogPassword);
    }

    public void save(OperationLog optLog) {
        String flowJson = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/optlog", (Object)optLog);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)flowJson);
        if (receiveJSON == null || receiveJSON.getCode() != 0) {
            logger.error("\u65e5\u5fd7\u5199\u5165\u9519\u8bef\uff0coptlog: " + optLog.toString());
        }
    }

    public void save(List<OperationLog> optLogs) {
        String flowJson = RestfulHttpRequest.jsonPost((AppSession)this.appSession, (String)"/optlog/saveMany", optLogs);
        HttpReceiveJSON receiveJSON = HttpReceiveJSON.valueOfJson((String)flowJson);
        if (receiveJSON == null || receiveJSON.getCode() != 0) {
            logger.error("\u65e5\u5fd7\u5199\u5165\u9519\u8bef\uff0coptlogs: " + JSON.toJSONString(optLogs));
        }
    }

    public List<? extends OperationLog> listOptLog(String optId, Map<String, Object> filterMap, int startPos, int maxRows) {
        filterMap.put("startPos", startPos);
        filterMap.put("maxRows", maxRows);
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)("/optlog/query/" + optId), filterMap));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return receiveJSON.getDataAsArray(OperationLog.class);
    }

    public int countOptLog(String optId, Map<String, Object> filterMap) {
        HttpReceiveJSON receiveJSON = RestfulHttpRequest.getResponseData((AppSession)this.appSession, (String)UrlOptUtils.appendParamsToUrl((String)("/optlog/count/" + optId), filterMap));
        RestfulHttpRequest.checkHttpReceiveJSON((HttpReceiveJSON)receiveJSON);
        return (Integer)receiveJSON.getDataAsObject(Integer.class);
    }
}

