/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.controller;

import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.po.UserTask;
import com.centit.task.service.UserTaskManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u7528\u6237\u4efb\u52a1", tags={"\u7528\u6237\u4efb\u52a1\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/opt/task"})
public class UserTaskController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(UserTaskController.class);
    @Autowired
    private UserTaskManager userTaskManager;

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u7528\u6237\u4efb\u52a1", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u7528\u6237\u4efb\u52a1")
    @WrapUpResponseBody
    @PostMapping
    public String saveUserTask(@RequestBody UserTask userTask) {
        String taskId = this.userTaskManager.saveUserTask(userTask);
        return taskId;
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u7528\u6237\u4efb\u52a1", notes="\u6279\u91cf\u4fdd\u5b58\u7528\u6237\u4efb\u52a1")
    @WrapUpResponseBody
    @PostMapping(value={"/saveUserTaskList"})
    public List<String> saveUserTaskList(@RequestBody List<UserTask> userTaskList) {
        return this.userTaskManager.saveUserTaskList(userTaskList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4efb\u52a1", notes="\u83b7\u53d6\u7528\u6237\u4efb\u52a1")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public UserTask getUserTaskById(@PathVariable String taskId) {
        return this.userTaskManager.getUserTaskById(taskId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7528\u6237\u4efb\u52a1", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @WrapUpResponseBody
    @RequestMapping(value={"/allUserTasks"}, method={RequestMethod.GET})
    public List<UserTask> listUserTask(HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.userTaskManager.listUserTask(filterMap, null);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7528\u6237\u4efb\u52a1", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @WrapUpResponseBody
    @GetMapping(value={"/listUserTask"})
    public PageQueryResult listUserTask(PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        List userTasks = this.userTaskManager.listUserTask(filterMap, pageDesc);
        return PageQueryResult.createResult((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u4efb\u52a1", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @WrapUpResponseBody
    @RequestMapping(value={"/listUserTask/{userCode}/{offset}/{maxsize}"}, method={RequestMethod.GET})
    public List<UserTask> listUserTask(@PathVariable String userCode, @PathVariable int offset, @PathVariable int maxsize) {
        return this.userTaskManager.listUserTask(userCode, offset, maxsize);
    }

    @ApiOperation(value="\u7528\u6237\u4efb\u52a1\u67e5\u8be2", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="offset", value="\u8bb0\u5f55\u884c\u7684\u504f\u79fb\u91cf", required=true, paramType="path", dataType="int"), @ApiImplicitParam(name="maxsize", value="\u8bb0\u5f55\u884c\u7684\u6700\u5927\u6570\u76ee", required=true, paramType="path", dataType="int"), @ApiImplicitParam(name="userCode", value="\u64cd\u4f5c\u7528\u6237"), @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfid:\u7b49\u540c\u4e8eAPPLICATION_ID,\u5bf9\u5e94\u5e94\u7528\u7cfb\u7edf\uff0c\u6bd4\u5982\u5de5\u4f5c\u6d41\u5f15\u64ceworkflow\u3001\u8003\u52e4\u7cfb\u7edfid"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u6a21\u5757:\u5bf9\u5e94\u5de5\u4f5c\u6d41\u4e2d\u7684\u6d41\u7a0b\u4ee3\u7801\uff0c\u8003\u52e4\u7cfb\u7edf\u4e2d\u7684\u529f\u80fd")})
    @WrapUpResponseBody
    @RequestMapping(value={"/listUserTask/{offset}/{maxsize}"}, method={RequestMethod.GET})
    public List<UserTask> listUserTask(@PathVariable int offset, @PathVariable int maxsize, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.userTaskManager.listUserTask(filterMap, offset, maxsize);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @WrapUpResponseBody
    @GetMapping(value={"/listUserCompleteTask"})
    public PageQueryResult listUserCompleteTask(PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        List userTasks = this.userTaskManager.listUserCompleteTask(filterMap, pageDesc);
        return PageQueryResult.createResult((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u5217\u8868", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @WrapUpResponseBody
    @RequestMapping(value={"/listUserCompleteTask/{userCode}/{offset}/{maxsize}"}, method={RequestMethod.GET})
    public List<UserTask> listUserCompleteTask(@PathVariable String userCode, @PathVariable int offset, @PathVariable int maxsize) {
        return this.userTaskManager.listUserCompleteTask(userCode, offset, maxsize);
    }

    @ApiOperation(value="\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u67e5\u8be2", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="offset", value="\u8bb0\u5f55\u884c\u7684\u504f\u79fb\u91cf", required=true, paramType="path", dataType="int"), @ApiImplicitParam(name="maxsize", value="\u8bb0\u5f55\u884c\u7684\u6700\u5927\u6570\u76ee", required=true, paramType="path", dataType="int"), @ApiImplicitParam(name="userCode", value="\u64cd\u4f5c\u7528\u6237"), @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfid:\u7b49\u540c\u4e8eAPPLICATION_ID,\u5bf9\u5e94\u5e94\u7528\u7cfb\u7edf\uff0c\u6bd4\u5982\u5de5\u4f5c\u6d41\u5f15\u64ceworkflow\u3001\u8003\u52e4\u7cfb\u7edfid"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u6a21\u5757:\u5bf9\u5e94\u5de5\u4f5c\u6d41\u4e2d\u7684\u6d41\u7a0b\u4ee3\u7801\uff0c\u8003\u52e4\u7cfb\u7edf\u4e2d\u7684\u529f\u80fd")})
    @WrapUpResponseBody
    @RequestMapping(value={"/listUserCompleteTask/{offset}/{maxsize}"}, method={RequestMethod.GET})
    public List<UserTask> listUserCompleteTask(@PathVariable int offset, @PathVariable int maxsize, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.userTaskManager.listUserCompleteTask(filterMap, offset, maxsize);
    }

    @ApiOperation(value="\u4e1a\u52a1\u4efb\u52a1\u5217\u8868", notes="\u4efb\u52a1\u6309\u65f6\u95f4\u5012\u5e8f\u6392\u5217")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u65b9\u6cd5\u3001\u8282\u70b9"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4e3b\u952e")})
    @WrapUpResponseBody
    @RequestMapping(value={"/listOptTask"}, method={RequestMethod.GET})
    public List<UserTask> listOptTask(String osId, String optId, String optMethod, String optTag, HttpServletRequest request) {
        return this.userTaskManager.listOptTask(osId, optId, optMethod, optTag);
    }

    @ApiOperation(value="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u4efb\u52a1\u6761\u76ee\u8ba1\u6570", notes="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u4efb\u52a1\u6761\u76ee\u8ba1\u6570")
    @WrapUpResponseBody
    @RequestMapping(value={"/countUserTask/{userCode}"}, method={RequestMethod.GET})
    public Long countUserTask(@PathVariable String userCode) {
        return this.userTaskManager.countUserTask(userCode);
    }

    @ApiOperation(value="\u7528\u6237\u4efb\u52a1\u6761\u76ee\u8ba1\u6570", notes="\u7528\u6237\u4efb\u52a1\u6761\u76ee\u8ba1\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u64cd\u4f5c\u7528\u6237"), @ApiImplicitParam(name="osId", value="\u5e94\u7528\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u65b9\u6cd5\u3001\u8282\u70b9"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4e3b\u952e"), @ApiImplicitParam(name="taskState", value="\u6d3b\u52a8\u72b6\u6001\uff08\u9ed8\u8ba4\u4e3aA\uff0c\u4e0d\u53ef\u4fee\u6539\uff09 A:\u5df2\u5206\u914d C:\u5df2\u5b8c\u6210 F:\u5df2\u59d4\u6258\u7ed9\u522b\u4eba")})
    @WrapUpResponseBody
    @RequestMapping(value={"/countUserTask"}, method={RequestMethod.GET})
    public Long countUserTask(HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.userTaskManager.countUserTask(filterMap);
    }

    @ApiOperation(value="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u6761\u76ee\u8ba1\u6570", notes="\u6839\u636euserCode\u83b7\u53d6\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u6761\u76ee\u8ba1\u6570")
    @WrapUpResponseBody
    @RequestMapping(value={"/countUserCompleteTask/{userCode}"}, method={RequestMethod.GET})
    public Long countUserCompleteTask(@PathVariable String userCode) {
        return this.userTaskManager.countUserCompleteTask(userCode);
    }

    @ApiOperation(value="\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u6761\u76ee\u8ba1\u6570", notes="\u7528\u6237\u5df2\u5b8c\u6210\u4efb\u52a1\u6761\u76ee\u8ba1\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u64cd\u4f5c\u7528\u6237"), @ApiImplicitParam(name="osId", value="\u5e94\u7528\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u65b9\u6cd5\u3001\u8282\u70b9"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4e3b\u952e"), @ApiImplicitParam(name="taskState", value="\u6d3b\u52a8\u72b6\u6001\uff08\u9ed8\u8ba4\u4e3aC\uff0c\u4e0d\u53ef\u4fee\u6539\uff09 A:\u5df2\u5206\u914d C:\u5df2\u5b8c\u6210 F:\u5df2\u59d4\u6258\u7ed9\u522b\u4eba")})
    @WrapUpResponseBody
    @RequestMapping(value={"/countUserCompleteTask"}, method={RequestMethod.GET})
    public Long countUserCompleteTask(HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        return this.userTaskManager.countUserCompleteTask(filterMap);
    }

    @ApiOperation(value="\u9274\u6743:\u7528\u6237\u662f\u5426\u6709\u6743\u9650\u64cd\u4f5c\u4efb\u52a1", notes="\u7528\u6237\u662f\u5426\u6709\u6743\u9650\u64cd\u4f5c\u4efb\u52a1")
    @WrapUpResponseBody
    @RequestMapping(value={"/checkTaskAuth/{taskId}/{userCode}"}, method={RequestMethod.GET})
    public boolean checkTaskAuth(@PathVariable String taskId, @PathVariable String userCode) {
        return this.userTaskManager.checkTaskAuth(taskId, userCode);
    }

    @ApiOperation(value="\u5b8c\u6210\u4efb\u52a1", notes="\u5b8c\u6210\u4efb\u52a1")
    @WrapUpResponseBody
    @RequestMapping(value={"/completeTask/{userCode}/{taskId}"}, method={RequestMethod.PUT})
    public void completeTask(@PathVariable String userCode, @PathVariable String taskId) {
        this.userTaskManager.completeTask(userCode, taskId);
    }

    @ApiOperation(value="\u5173\u95ed\u7528\u6237\u4efb\u52a1", notes="\u5173\u95ed\u7528\u6237\u4efb\u52a1")
    @WrapUpResponseBody
    @RequestMapping(value={"/closeTask/{userCode}/{taskId}"}, method={RequestMethod.PUT})
    public void closeTask(@PathVariable String userCode, @PathVariable String taskId) {
        this.userTaskManager.closeTask(userCode, taskId);
    }

    @ApiOperation(value="\u5173\u95ed\u4e1a\u52a1\u4efb\u52a1", notes="\u5173\u95ed\u4e1a\u52a1\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="osId", value="\u5e94\u7528\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4ee3\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u65b9\u6cd5\u3001\u8282\u70b9"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u4e3b\u952e")})
    @WrapUpResponseBody
    @RequestMapping(value={"/closeOptTask"}, method={RequestMethod.PUT})
    public void closeOptTask(String osId, String optId, String optMethod, String optTag, HttpServletRequest request) {
        this.userTaskManager.closeOptTask(osId, optId, optMethod, optTag);
    }

    @ApiOperation(value="\u8f6c\u79fb\u4efb\u52a1", notes="\u8f6c\u79fb\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801"), @ApiImplicitParam(name="newOperator", value="\u65b0\u7684\u64cd\u4f5c\u4eba\u5458"), @ApiImplicitParam(name="transDesc", value="\u8f6c\u79fb\u8bf4\u660e")})
    @WrapUpResponseBody
    @RequestMapping(value={"/transferTask"}, method={RequestMethod.POST})
    public void transferTask(String taskId, String userCode, String newOperator, String transDesc, HttpServletRequest request) {
        this.userTaskManager.transferTask(taskId, userCode, newOperator, transDesc);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4efb\u52a1", notes="\u5220\u9664\u7528\u6237\u4efb\u52a1")
    @WrapUpResponseBody
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.DELETE})
    public void deleteUserTaskById(@PathVariable String taskId) {
        this.userTaskManager.deleteUserTaskById(taskId);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u4efb\u52a1\u59d4\u6258", notes="\u5220\u9664\u7528\u6237\u4efb\u52a1\u59d4\u6258")
    @WrapUpResponseBody
    @RequestMapping(value={"/deleteUserDepute/{relegateId}"}, method={RequestMethod.DELETE})
    public void deleteUserDepute(@PathVariable String relegateId) {
        this.userTaskManager.deleteUserDepute(relegateId);
    }
}

