/*
 * Decompiled with CFR 0.152.
 */
package com.centit.task.service.impl;

import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.task.dao.RoleDeputeDao;
import com.centit.task.dao.TaskTransferDao;
import com.centit.task.dao.UserTaskDao;
import com.centit.task.po.RoleDepute;
import com.centit.task.po.TaskTransfer;
import com.centit.task.po.UserTask;
import com.centit.task.service.UserTaskManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserTaskManagerImpl
implements UserTaskManager {
    private static final Logger log = LoggerFactory.getLogger(UserTaskManagerImpl.class);
    private static final long serialVersionUID = 1L;
    @Autowired
    private UserTaskDao userTaskDao;
    @Autowired
    private RoleDeputeDao roleDeputeDao;
    @Autowired
    private TaskTransferDao transferDao;

    public String saveUserTask(UserTask userTask) {
        userTask.setAssignTime(new Date());
        this.userTaskDao.mergeObject((Serializable)userTask);
        return userTask.getTaskId();
    }

    public List<String> saveUserTaskList(List<UserTask> userTaskList) {
        if (userTaskList == null || userTaskList.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (UserTask userTask : userTaskList) {
            list.add(this.saveUserTask(userTask));
        }
        return list;
    }

    public List<UserTask> listUserTask(String userCode, int offset, int maxsize) {
        return this.userTaskDao.listUserTask(userCode, offset, maxsize);
    }

    public List<UserTask> listUserTask(Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("taskState", "A");
        filterMap.put("ORDER_BY", "assignTime desc");
        return this.userTaskDao.listObjectsByProperties(filterMap, pageDesc);
    }

    public List<UserTask> listUserTask(Map<String, Object> filterMap, int offset, int maxsize) {
        filterMap.put("taskState", "A");
        filterMap.put("ORDER_BY", "assignTime desc");
        return this.userTaskDao.listObjectsByProperties(filterMap, offset, maxsize);
    }

    public List<UserTask> listUserCompleteTask(String userCode, int offset, int maxsize) {
        return this.userTaskDao.listUserCompleteTask(userCode, offset, maxsize);
    }

    public List<UserTask> listUserCompleteTask(Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("taskState", "C");
        filterMap.put("ORDER_BY", "assignTime desc");
        return this.userTaskDao.listObjectsByProperties(filterMap, pageDesc);
    }

    public List<UserTask> listUserCompleteTask(Map<String, Object> filterMap, int offset, int maxsize) {
        filterMap.put("taskState", "C");
        filterMap.put("ORDER_BY", "assignTime desc");
        return this.userTaskDao.listObjectsByProperties(filterMap, offset, maxsize);
    }

    public List<UserTask> listOptTask(String osId, String optId, String optMethod, String optTag) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("osId", osId);
        filterMap.put("optId", optId);
        filterMap.put("optMethod", optMethod);
        filterMap.put("optTag", optTag);
        filterMap.put("taskState", "A");
        filterMap.put("ORDER_BY", "assignTime desc");
        return this.userTaskDao.listObjectsByProperties(filterMap);
    }

    public Long countUserTask(String userCode) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("userCode", userCode);
        filterMap.put("taskState", "A");
        return this.userTaskDao.countUserTask(filterMap);
    }

    public Long countUserTask(Map<String, Object> filterMap) {
        filterMap.put("taskState", "A");
        return this.userTaskDao.countUserTask(filterMap);
    }

    public Long countUserCompleteTask(String userCode) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("userCode", userCode);
        filterMap.put("taskState", "C");
        return this.userTaskDao.countUserTask(filterMap);
    }

    public Long countUserCompleteTask(Map<String, Object> filterMap) {
        filterMap.put("taskState", "C");
        return this.userTaskDao.countUserTask(filterMap);
    }

    public boolean checkTaskAuth(String taskId, String userCode) {
        UserTask task = (UserTask)this.userTaskDao.getObjectById(taskId);
        if (task == null) {
            throw new ObjectException("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\uff01");
        }
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("taskId", taskId);
        filterMap.put("userCode", userCode);
        Long countUserTask = this.userTaskDao.countUserTask(filterMap);
        return countUserTask != 0L;
    }

    @Transactional
    public void completeTask(String userCode, String taskId) {
        UserTask userTask = (UserTask)this.userTaskDao.getObjectById(taskId);
        this.checkUserTask(userCode, userTask);
        userTask.setTaskState("C");
        userTask.setUpdateTime(new Date());
        this.userTaskDao.updateObject((Serializable)userTask);
    }

    private void checkUserTask(String userCode, UserTask userTask) {
        if (userTask == null) {
            throw new ObjectException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4efb\u52a1\uff01");
        }
        if (userCode == null || !userCode.equals(userTask.getUserCode())) {
            throw new ObjectException("\u7528\u6237\u6ca1\u6709\u64cd\u4f5c\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        if (!"A".equals(userTask.getTaskState())) {
            throw new ObjectException("\u4efb\u52a1\u7684\u72b6\u6001\u4e3a" + userTask.getTaskState());
        }
    }

    @Transactional
    public void closeTask(String userCode, String taskId) {
        UserTask userTask = (UserTask)this.userTaskDao.getObjectById(taskId);
        this.checkUserTask(userCode, userTask);
        userTask.setTaskState("F");
        userTask.setUpdateTime(new Date());
        this.userTaskDao.updateObject((Serializable)userTask);
    }

    public void closeOptTask(String osId, String optId, String optMethod, String optTag) {
        boolean anyEmpty = StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{osId, optId, optMethod, optTag});
        if (anyEmpty) {
            throw new ObjectException("osId, optId, optMethod, optTag\u4e2d \u6709\u53c2\u6570\u4e3a\u7a7a");
        }
        List<UserTask> userTasks = this.listOptTask(osId, optId, optMethod, optTag);
        Date currentTime = new Date();
        userTasks.forEach(t -> {
            t.setUpdateTime(currentTime);
            t.setTaskState("F");
            this.userTaskDao.updateObject((Serializable)t);
        });
    }

    @Transactional
    public void transferTask(String taskId, String userCode, String newOperator, String transDesc) {
        boolean anyEmpty = StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{taskId, userCode, newOperator});
        if (anyEmpty) {
            throw new ObjectException("taskId, userCode, newOperator\u4e2d \u6709\u53c2\u6570\u4e3a\u7a7a");
        }
        UserTask userTask = (UserTask)this.userTaskDao.getObjectById(taskId);
        Date currentTime = new Date();
        this.checkUserTask(userCode, userTask);
        userTask.setUpdateTime(currentTime);
        userTask.setTaskState("T");
        this.userTaskDao.updateObject((Serializable)userTask);
        userTask.setTaskId(null);
        userTask.setAssignTime(currentTime);
        userTask.setUpdateTime(null);
        userTask.setTaskState("A");
        userTask.setUserCode(newOperator);
        userTask.setAuthDesc("\u8f6c\u79fb\u7528\u6237\uff08" + userCode + "\uff09\uff1a" + transDesc);
        this.userTaskDao.saveNewObject((Serializable)userTask);
        TaskTransfer taskTransfer = new TaskTransfer(taskId, userCode, newOperator, transDesc, userCode, currentTime);
        this.transferDao.saveNewObject((Serializable)taskTransfer);
    }

    @Transactional
    public void userRoleDepute(RoleDepute depute) {
    }

    @Transactional
    public void deleteUserTaskById(String taskId) {
        this.userTaskDao.deleteObjectById(taskId);
    }

    @Transactional
    public void deleteUserDepute(String relegateId) {
        this.roleDeputeDao.deleteObjectById(relegateId);
    }

    @Transactional
    public UserTask getUserTaskById(String taskId) {
        return (UserTask)this.userTaskDao.getObjectById(taskId);
    }
}

