/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.product.oa.service.OptFlowNoInfoManager;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/optflow"})
@Api(value="\u83b7\u53d6\u6d41\u6c34\u53f7", tags={"\u83b7\u53d6\u6d41\u6c34\u53f7"})
public class OptflowSerialNumberController
extends BaseController {
    @Autowired
    private OptFlowNoInfoManager optFlowNoInfoManager;

    @ApiOperation(value="\u901a\u8fc7\u6a21\u677f\u83b7\u53d6\u6d41\u6c34\u53f7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="codeCode", value="\u6d41\u6c34\u53f7\u4ee3\u7801", required=true), @ApiImplicitParam(name="baseDateType", value="\u57fa\u4e8e\u65e5\u671f\u7c7b\u578b\uff1aY\u5e74\uff0cM\u6708\uff0cD\u65e5", required=true), @ApiImplicitParam(name="ownCode", value="\u6240\u5c5e\u4ee3\u7801"), @ApiImplicitParam(name="sTemplate", value="\u6d41\u6c34\u53f7\u6a21\u677f"), @ApiImplicitParam(name="jsonObject", value="\u4e1a\u52a1\u5bf9\u8c61,requestbody")})
    @WrapUpResponseBody
    @RequestMapping(value={"/{codeCode}/{baseDateType}"}, method={RequestMethod.POST})
    public Object getOptFlow(@PathVariable String codeCode, @PathVariable String baseDateType, String ownCode, String sTemplate, @RequestBody String jsonObject) {
        Long lsh;
        switch (baseDateType) {
            case "M": {
                lsh = this.optFlowNoInfoManager.newNextLshBaseMonth(ownCode, codeCode, new Date());
                break;
            }
            case "D": {
                lsh = this.optFlowNoInfoManager.newNextLshBaseDay(ownCode, codeCode, new Date());
                break;
            }
            default: {
                lsh = this.optFlowNoInfoManager.newNextLshBaseYear(ownCode, codeCode, new Date());
            }
        }
        if (StringBaseOpt.isNvl((String)sTemplate)) {
            return lsh;
        }
        JSONObject object = JSON.parseObject((String)jsonObject);
        object.put("lsh", (Object)lsh);
        VariableFormula variableFormula = new VariableFormula();
        variableFormula.setTrans((VariableTranslate)new ObjectTranslate((Object)object));
        variableFormula.setFormula(StringEscapeUtils.unescapeHtml4((String)sTemplate));
        return variableFormula.calcFormula();
    }
}

