/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.product.oa.dao.OptFlowNoInfoDao;
import com.centit.product.oa.dao.OptFlowNoPoolDao;
import com.centit.product.oa.po.OptFlowNoInfo;
import com.centit.product.oa.po.OptFlowNoInfoId;
import com.centit.product.oa.po.OptFlowNoPool;
import com.centit.product.oa.po.OptFlowNoPoolId;
import com.centit.product.oa.service.OptFlowNoInfoManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.utils.PageDesc;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OptFlowNoInfoManagerImpl
implements OptFlowNoInfoManager {
    public static final Logger logger = LoggerFactory.getLogger(OptFlowNoInfoManager.class);
    @Resource
    @NotNull
    private OptFlowNoInfoDao optFlowNoInfoDao;
    @Resource
    @NotNull
    private OptFlowNoPoolDao optFlowNoPoolDao;

    @Override
    @Transactional
    public synchronized long newNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        OptFlowNoPoolId poolId;
        OptFlowNoPool poolNo;
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.optFlowNoInfoDao, (String)"update F_OPTFLOWNOINFO set CUR_NO = CUR_NO+1 where OWNER_CODE=? and CODE_DATE=? and CODE_CODE=?", (Object[])new Object[]{ownerCode, codeDate, codeCode});
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        long nextCode = 1L;
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, nextCode, DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveNewOptFlowNoInfo(noInfo);
        } else {
            nextCode = noInfo.getCurNo();
        }
        long savedCurCode = nextCode;
        while ((poolNo = this.optFlowNoPoolDao.getObjectById(poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, nextCode))) != null) {
            ++nextCode;
        }
        if (nextCode > savedCurCode) {
            noInfo.setCurNo(nextCode);
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.updateOptFlowNoInfo(noInfo);
        }
        return nextCode;
    }

    @Override
    @Transactional
    public boolean reserveLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, Long lsh) {
        Date codeDate;
        OptFlowNoInfoId noId;
        OptFlowNoInfo noInfo;
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        Long cur = (noInfo = this.optFlowNoInfoDao.getObjectById(noId = new OptFlowNoInfoId(ownerCode, codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate), codeCode))) == null ? 0L : noInfo.getCurNo();
        if (lsh > cur) {
            OptFlowNoPoolId poolId = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, lsh);
            OptFlowNoPool dbPool = this.optFlowNoPoolDao.getObjectById(poolId);
            if (dbPool != null) {
                return false;
            }
            OptFlowNoPool pool = new OptFlowNoPool(poolId, DatetimeOpt.currentUtilDate());
            this.optFlowNoPoolDao.saveNewOptFlowNoPool(pool);
            return true;
        }
        return false;
    }

    @Override
    public long newNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLshBaseWeek(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.newNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate));
    }

    @Override
    public long newNextLsh(String codeCode) {
        return this.newNextLsh("noOwner", codeCode, DefaultCodeDate);
    }

    @Override
    public long newNextLsh(String ownerCode, String codeCode) {
        return this.newNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    @Transactional
    public synchronized long viewNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        OptFlowNoInfoId noId;
        OptFlowNoInfo noInfo;
        Date codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate);
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        if ((noInfo = this.optFlowNoInfoDao.getObjectById(noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode))) == null) {
            noInfo = new OptFlowNoInfo(noId, 0L, DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveNewOptFlowNoInfo(noInfo);
        }
        return noInfo.getCurNo() + 1L;
    }

    @Override
    @Transactional
    public long viewNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long viewNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long viewNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long viewNextLshBaseWeek(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.viewNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long viewNextLsh(String codeCode) {
        return this.viewNextLsh("noOwner", codeCode, DefaultCodeDate);
    }

    @Override
    @Transactional
    public long viewNextLsh(String ownerCode, String codeCode) {
        return this.viewNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    @Transactional
    public synchronized void recordNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        Date codeDate;
        OptFlowNoPoolId poolId;
        OptFlowNoPool poolNo;
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        if ((poolNo = this.optFlowNoPoolDao.getObjectById(poolId = new OptFlowNoPoolId(ownerCode, codeDate = DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate), codeCode, currCode))) != null) {
            this.optFlowNoPoolDao.deleteObject(poolNo);
            return;
        }
        OptFlowNoInfoId noId = new OptFlowNoInfoId(ownerCode, codeDate, codeCode);
        OptFlowNoInfo noInfo = this.optFlowNoInfoDao.getObjectById(noId);
        if (noInfo == null) {
            noInfo = new OptFlowNoInfo(noId, currCode, DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.saveNewOptFlowNoInfo(noInfo);
        } else if (noInfo.getCurNo() < currCode) {
            if (currCode - noInfo.getCurNo() > 1L) {
                long startIdx;
                for (long i = startIdx = noInfo.getCurNo() + 1L; i < currCode; ++i) {
                    OptFlowNoPoolId cid = new OptFlowNoPoolId(ownerCode, codeDate, codeCode, i);
                    OptFlowNoPool pool = new OptFlowNoPool();
                    pool.setCid(cid);
                    pool.setCreateDate(new java.util.Date());
                    this.optFlowNoPoolDao.saveNewOptFlowNoPool(pool);
                }
            }
            noInfo.setCurNo(currCode);
            noInfo.setLastCodeDate(DatetimeOpt.currentUtilDate());
            this.optFlowNoInfoDao.updateOptFlowNoInfo(noInfo);
        }
    }

    @Override
    @Transactional
    public void recordNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void recordNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void recordNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void recordNextLshBaseWeek(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void recordNextLsh(String codeCode, long currCode) {
        this.recordNextLsh("noOwner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    @Transactional
    public void recordNextLsh(String ownerCode, String codeCode, long currCode) {
        this.recordNextLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    @Transactional
    public synchronized long assignNextLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        long minPoolNo;
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        if ((minPoolNo = this.optFlowNoPoolDao.fetchFirstLsh(ownerCode, codeCode, codeBaseDate)) > 0L) {
            OptFlowNoPoolId obj = new OptFlowNoPoolId();
            obj.setOwnerCode(ownerCode);
            obj.setCodeDate(DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate));
            obj.setCodeCode(codeCode);
            obj.setCurNo(minPoolNo);
            this.optFlowNoPoolDao.deleteObjectById(obj);
            return minPoolNo;
        }
        return this.newNextLsh(ownerCode, codeCode, codeBaseDate);
    }

    @Override
    @Transactional
    public long assignNextLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long assignNextLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long assignNextLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate));
    }

    @Override
    public long assignNextLshBaseWeek(String ownerCode, String codeCode, java.util.Date codeBaseDate) {
        return this.assignNextLsh(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate));
    }

    @Override
    @Transactional
    public long assignNextLsh(String ownerCode, String codeCode) {
        return this.assignNextLsh(ownerCode, codeCode, DefaultCodeDate);
    }

    @Override
    @Transactional
    public long assignNextLsh(String codeCode) {
        return this.assignNextLsh("noOwner", codeCode, DefaultCodeDate);
    }

    @Override
    @Transactional
    public void releaseLsh(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        OptFlowNoPool obj = new OptFlowNoPool();
        obj.setOwnerCode(ownerCode);
        obj.setCodeDate(DatetimeOpt.convertToSqlDate((java.util.Date)codeBaseDate));
        obj.setCodeCode(codeCode);
        obj.setCurNo(currCode);
        obj.setCreateDate(DatetimeOpt.currentUtilDate());
        this.optFlowNoPoolDao.saveNewOptFlowNoPool(obj);
    }

    @Override
    @Transactional
    public void releaseLshBaseDay(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void releaseLshBaseMonth(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void releaseLshBaseYear(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    public void releaseLshBaseWeek(String ownerCode, String codeCode, java.util.Date codeBaseDate, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate), currCode);
    }

    @Override
    @Transactional
    public void releaseLsh(String ownerCode, String codeCode, long currCode) {
        this.releaseLsh(ownerCode, codeCode, DefaultCodeDate, currCode);
    }

    @Override
    @Transactional
    public void releaseLsh(String codeCode, long currCode) {
        this.releaseLsh("noOwner", codeCode, DefaultCodeDate, currCode);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)ownerCode)) {
            ownerCode = "noOwner";
        }
        filterMap.put("ownerCode", ownerCode);
        filterMap.put("codeDate", codeBaseDate);
        filterMap.put("codeCode", codeCode);
        return this.optFlowNoPoolDao.listLshInPool(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshBaseDayInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToDay((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshBaseMonthInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToMonth((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshBaseYearInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToYear((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    public List<OptFlowNoPool> listLshBaseWeekInPool(String ownerCode, String codeCode, java.util.Date codeBaseDate, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DatetimeOpt.truncateToWeek((java.util.Date)codeBaseDate), pageDesc);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshInPool(String ownerCode, String codeCode, PageDesc pageDesc) {
        return this.listLshInPool(ownerCode, codeCode, DefaultCodeDate, pageDesc);
    }

    @Override
    @Transactional
    public List<OptFlowNoPool> listLshInPool(String codeCode, PageDesc pageDesc) {
        return this.listLshInPool("noOwner", codeCode, DefaultCodeDate, pageDesc);
    }
}

