/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.OptStack;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.RegularOpt;
import com.centit.support.compiler.VariableTranslate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formula {
    private Lexer m_lex = new Lexer();
    private Pretreatment m_preTreat = new Pretreatment();
    private boolean m_hasPreTreat = false;

    public void setVariableTranslate(VariableTranslate varTrans) {
        this.m_hasPreTreat = true;
        this.m_preTreat.setVariableTranslate(varTrans);
    }

    public void clearVariableTranslate() {
        this.m_hasPreTreat = false;
    }

    private static final int getFuncNo(String sFuncName) {
        return EmbedFunc.getFuncNo(sFuncName);
    }

    private static final int getOptID(String sOptName) {
        int sl = sOptName.length();
        if (sl == 0) {
            return -1;
        }
        char sp = sOptName.charAt(0);
        char sp2 = '\u0000';
        if (sl > 1) {
            sp2 = sOptName.charAt(1);
        }
        switch (sp) {
            case '=': {
                if (sp2 == '=') {
                    return 34;
                }
                return 34;
            }
            case '+': {
                return 30;
            }
            case '-': {
                return 31;
            }
            case '*': {
                return 32;
            }
            case '/': {
                return 33;
            }
            case '^': {
                return 43;
            }
            case '>': {
                if (sp2 == '=') {
                    return 38;
                }
                if (sp2 == '>') {
                    return 44;
                }
                return 35;
            }
            case '<': {
                if (sp2 == '=') {
                    return 37;
                }
                if (sp2 == '>') {
                    return 39;
                }
                if (sp2 == '<') {
                    return 45;
                }
                return 36;
            }
            case '&': {
                if (sp2 == '&') {
                    return 41;
                }
                return 41;
            }
            case '|': {
                if (sp2 == '|') {
                    return 40;
                }
                return 40;
            }
            case '!': {
                if (sp2 == '=') {
                    return 39;
                }
                return 42;
            }
        }
        if (sOptName.equalsIgnoreCase("LIKE")) {
            return 46;
        }
        if (sOptName.equalsIgnoreCase("AND")) {
            return 41;
        }
        if (sOptName.equalsIgnoreCase("OR")) {
            return 40;
        }
        if (sOptName.equalsIgnoreCase("NOT")) {
            return 42;
        }
        if (sOptName.equalsIgnoreCase("IN")) {
            return 47;
        }
        if (sOptName.equalsIgnoreCase("DIV")) {
            return 33;
        }
        return -1;
    }

    private static final String runFunc(List<String> slOperand, int funcID) {
        return EmbedFunc.runFunc(slOperand, funcID);
    }

    public static final boolean isKeyWord(String sWord) {
        if (sWord == null || sWord.length() == 0) {
            return false;
        }
        char firstChar = sWord.charAt(0);
        if (firstChar == ',' || firstChar == '(' || firstChar == ')') {
            return true;
        }
        if (firstChar == '-' && sWord.length() > 1) {
            return false;
        }
        return Formula.getOptID(sWord) > 0;
    }

    private String getItem() {
        String str = this.m_lex.getAWord();
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == ')' || str.charAt(0) == ',') {
            this.m_lex.setPreword(str);
            return null;
        }
        if (str.charAt(0) == '(') {
            String resstr = this.getFormula();
            str = this.m_lex.getAWord();
            if (str == null || str.length() == 0 || str.charAt(0) != ')') {
                return null;
            }
            return resstr;
        }
        if (str.charAt(0) == '!' || str.equalsIgnoreCase("NOT")) {
            str = this.getItem();
            if (RegularOpt.IsTrue(str)) {
                return "0";
            }
            return "1";
        }
        String optstr = str.toLowerCase();
        int funcNo = Formula.getFuncNo(optstr);
        if (funcNo != -1) {
            str = this.getFunc(funcNo);
        }
        return str;
    }

    private String runOperate(String operand, String operand2, int optID) {
        String str = "";
        String str1 = RegularOpt.TrimString(operand);
        String str2 = RegularOpt.TrimString(operand2);
        switch (optID) {
            case 40: {
                boolean bop = RegularOpt.IsTrue(str1);
                boolean bop2 = RegularOpt.IsTrue(str2);
                if (bop || bop2) {
                    return "1";
                }
                return "0";
            }
            case 41: {
                boolean bop = RegularOpt.IsTrue(str1);
                boolean bop2 = RegularOpt.IsTrue(str2);
                if (bop && bop2) {
                    return "1";
                }
                return "0";
            }
        }
        if (!RegularOpt.IsNumber(str1) || !RegularOpt.IsNumber(str2)) {
            int res = str1.compareTo(str2);
            switch (optID) {
                case 30: 
                case 32: {
                    return String.format("\"%s%s\"", str1, str2);
                }
                case 34: {
                    if (res == 0) {
                        return "1";
                    }
                    return "0";
                }
                case 35: {
                    if (res > 0) {
                        return "1";
                    }
                    return "0";
                }
                case 36: {
                    if (res < 0) {
                        return "1";
                    }
                    return "0";
                }
                case 37: {
                    if (res <= 0) {
                        return "1";
                    }
                    return "0";
                }
                case 38: {
                    if (res >= 0) {
                        return "1";
                    }
                    return "0";
                }
                case 39: {
                    if (res != 0) {
                        return "1";
                    }
                    return "0";
                }
                case 44: {
                    int nP2;
                    if (RegularOpt.IsNumber(str2) && (nP2 = Double.valueOf(str2).intValue()) >= 0 && str1.length() > nP2) {
                        str = str1.substring(0, str1.length() - nP2);
                        return str;
                    }
                    return null;
                }
                case 45: {
                    int nP2;
                    if (RegularOpt.IsNumber(str2) && (nP2 = Double.valueOf(str2).intValue()) >= 0 && str1.length() > nP2) {
                        str = str1.substring(nP2);
                        return str;
                    }
                    return null;
                }
                case 46: {
                    if (RegularOpt.IsMatch(str1, str2)) {
                        return "1";
                    }
                    return "0";
                }
            }
            return null;
        }
        double dbop = Double.valueOf(str1);
        double dbop2 = Double.valueOf(str2);
        switch (optID) {
            case 30: {
                return String.format("%f", dbop + dbop2);
            }
            case 31: {
                return String.format("%f", dbop - dbop2);
            }
            case 32: {
                return String.format("%f", dbop * dbop2);
            }
            case 33: {
                if (dbop2 == 0.0) {
                    return "0";
                }
                return String.format("%f", dbop / dbop2);
            }
            case 34: {
                if (dbop == dbop2) {
                    return "1";
                }
                return "0";
            }
            case 35: {
                if (dbop > dbop2) {
                    return "1";
                }
                return "0";
            }
            case 36: {
                if (dbop < dbop2) {
                    return "1";
                }
                return "0";
            }
            case 37: {
                if (dbop <= dbop2) {
                    return "1";
                }
                return "0";
            }
            case 38: {
                if (dbop >= dbop2) {
                    return "1";
                }
                return "0";
            }
            case 39: {
                if (dbop != dbop2) {
                    return "1";
                }
                return "0";
            }
            case 43: {
                return String.format("%f", Math.pow(dbop, dbop2));
            }
            case 44: {
                int nP = Double.valueOf(dbop).intValue();
                int nP2 = Double.valueOf(dbop2).intValue();
                return String.format("%d", nP >> nP2);
            }
            case 45: {
                int nP = Double.valueOf(dbop).intValue();
                int nP2 = Double.valueOf(dbop2).intValue();
                return String.format("%d", nP << nP2);
            }
            case 46: {
                if (RegularOpt.IsMatch(str1, str2)) {
                    return "1";
                }
                return "0";
            }
        }
        return null;
    }

    private String getFormula() {
        String str;
        ArrayList<String> slOperand = new ArrayList<String>();
        OptStack optStack = new OptStack();
        block0: while (true) {
            str = this.getItem();
            slOperand.add(0, str);
            if (str == null || str.length() == 0 || (str = this.m_lex.getAWord()) == null || str.length() == 0) break;
            int optID = Formula.getOptID(str);
            if (optID == -1) {
                this.m_lex.setPreword(str);
                break;
            }
            if (optID == 47) {
                String sInRes = "0";
                String str1Operand = RegularOpt.TrimString((String)slOperand.remove(0));
                str = this.m_lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals("(")) {
                    return null;
                }
                ArrayList<String> slInnerOperand = new ArrayList<String>();
                do {
                    str = this.getFormula();
                    slInnerOperand.add(str);
                    str = this.m_lex.getAWord();
                    if (str != null && str.length() != 0 && (str.equals(",") || str.equals("("))) continue;
                    return null;
                } while (!str.equals(")"));
                for (int i = 0; i < slInnerOperand.size(); ++i) {
                    str = RegularOpt.TrimString((String)slInnerOperand.get(i));
                    if (!str1Operand.equals(str)) continue;
                    sInRes = "1";
                    break;
                }
                slOperand.add(0, sInRes);
                str = this.m_lex.getAWord();
                optID = Formula.getOptID(str);
                if (optID == -1) {
                    this.m_lex.setPreword(str);
                    break;
                }
            }
            int op = optStack.pushOpt(optID);
            while (true) {
                if (op == 0) continue block0;
                String operand2 = (String)slOperand.remove(0);
                String operand = (String)slOperand.remove(0);
                str = this.runOperate(operand, operand2, op);
                slOperand.add(0, str);
                op = optStack.pushOpt(optID);
            }
            break;
        }
        int op = optStack.popOpt();
        while (op != 0) {
            String operand2 = (String)slOperand.remove(0);
            String operand = (String)slOperand.remove(0);
            str = this.runOperate(operand, operand2, op);
            slOperand.add(0, str);
            op = optStack.popOpt();
        }
        return (String)slOperand.get(0);
    }

    private String getFunc(int nFuncNo) {
        String str = this.m_lex.getAWord();
        if (str == null || str.length() == 0 || !str.equals("(")) {
            return null;
        }
        int prmNo = 0;
        String sRes = "";
        if (EmbedFunc.m_sFunctionList[nFuncNo].nFuncID == 108) {
            String sCondition = this.getFormula();
            if (sCondition == null) {
                return null;
            }
            str = this.m_lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",")) {
                return null;
            }
            if (RegularOpt.IsTrue(sCondition)) {
                sRes = this.getFormula();
                str = this.m_lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                    return null;
                }
                if (str.equals(")")) {
                    return sRes;
                }
                this.m_lex.skipAOperand();
                str = this.m_lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(")")) {
                    return null;
                }
                return sRes;
            }
            this.m_lex.skipAOperand();
            str = this.m_lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                return null;
            }
            if (str.equals(")")) {
                return sRes;
            }
            sRes = this.getFormula();
            str = this.m_lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(")")) {
                return null;
            }
            return sRes;
        }
        ArrayList<String> slOperand = new ArrayList<String>();
        do {
            ++prmNo;
            str = this.getFormula();
            slOperand.add(str);
            str = this.m_lex.getAWord();
            if (str != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
            return null;
        } while (!str.equals(")"));
        if (str == null || str.length() == 0 || !str.equals(")")) {
            return null;
        }
        if (EmbedFunc.m_sFunctionList[nFuncNo].nPrmSum != -1 && prmNo < EmbedFunc.m_sFunctionList[nFuncNo].nPrmSum) {
            return null;
        }
        str = Formula.runFunc(slOperand, EmbedFunc.m_sFunctionList[nFuncNo].nFuncID);
        return str;
    }

    public String calculate(String szExpress) {
        if (this.m_hasPreTreat) {
            szExpress = this.m_preTreat.runPretreatment(szExpress);
        }
        this.m_lex.setFormula(szExpress);
        String sRes = this.getFormula();
        if (sRes == null || sRes.length() == 0) {
            return "";
        }
        return RegularOpt.TrimString(sRes);
    }

    public int checkFormula(String szExpress) {
        szExpress = this.m_preTreat.runPretreatment(szExpress);
        boolean nNextType = true;
        int nBrackets = 0;
        this.m_lex.setFormula(szExpress);
        String sWord = this.m_lex.getAWord();
        while (sWord != "") {
            boolean bKW = Formula.isKeyWord(sWord);
            if (nNextType) {
                if (bKW) {
                    if (sWord == "(") {
                        ++nBrackets;
                    } else if (!sWord.equalsIgnoreCase("NOT") && sWord != "!") {
                        return this.m_lex.getCurrPos() + 1;
                    }
                } else {
                    nNextType = false;
                }
            } else if (bKW) {
                if (sWord == ")") {
                    --nBrackets;
                } else if (sWord == "(") {
                    ++nBrackets;
                    nNextType = true;
                } else {
                    nNextType = true;
                }
            } else {
                return this.m_lex.getCurrPos() + 1;
            }
            if (nBrackets < 0) {
                return this.m_lex.getCurrPos() + 1;
            }
            sWord = this.m_lex.getAWord();
        }
        if (nBrackets == 0) {
            return 0;
        }
        return this.m_lex.getCurrPos() + 1;
    }
}

