/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

public class Lexer {
    private String m_sCurWord;
    private boolean m_bIsBack;
    private String m_Formula;
    private boolean m_bAcceptOpt;
    private int m_iStart;

    public void setPreword(String preWord) {
        this.m_sCurWord = preWord;
        this.m_bIsBack = true;
    }

    public void setFormula(String sFormula) {
        this.m_Formula = sFormula;
        this.m_bIsBack = false;
        this.m_sCurWord = "";
        this.m_iStart = 0;
        this.m_bAcceptOpt = false;
    }

    public int getCurrPos() {
        return this.m_iStart;
    }

    public static boolean isLabel(String sWord) {
        if (sWord.length() < 1) {
            return false;
        }
        char c = sWord.charAt(0);
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private String getARegularWord() {
        int sl = this.m_Formula.length();
        block11: while (true) {
            if (this.m_iStart < sl && (this.m_Formula.charAt(this.m_iStart) == ' ' || this.m_Formula.charAt(this.m_iStart) == '\t' || this.m_Formula.charAt(this.m_iStart) == '\n' || this.m_Formula.charAt(this.m_iStart) == '\r')) {
                ++this.m_iStart;
                continue;
            }
            if (this.m_iStart >= sl) {
                return "";
            }
            if (this.m_iStart >= sl - 1) break;
            if (this.m_Formula.charAt(this.m_iStart) == '-' && this.m_Formula.charAt(this.m_iStart + 1) <= '-') {
                while (true) {
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) == '\n') continue block11;
                    ++this.m_iStart;
                }
            }
            if (this.m_Formula.charAt(this.m_iStart) != '/' || this.m_Formula.charAt(this.m_iStart + 1) > '*') break;
            while (this.m_iStart < sl - 1 && (this.m_Formula.charAt(this.m_iStart) != '*' || this.m_Formula.charAt(this.m_iStart + 1) != '/')) {
                ++this.m_iStart;
            }
            if (this.m_Formula.charAt(this.m_iStart) != '*' && this.m_Formula.charAt(this.m_iStart + 1) != '/') continue;
            this.m_iStart += 2;
        }
        int bp = this.m_iStart;
        if (this.m_Formula.charAt(this.m_iStart) >= '0' && this.m_Formula.charAt(this.m_iStart) <= '9' || !this.m_bAcceptOpt && (this.m_Formula.charAt(this.m_iStart) == '-' || this.m_Formula.charAt(this.m_iStart) == '+')) {
            ++this.m_iStart;
            int nPoints = 0;
            while (this.m_iStart < sl && (this.m_Formula.charAt(this.m_iStart) >= '0' && this.m_Formula.charAt(this.m_iStart) <= '9' || this.m_Formula.charAt(this.m_iStart) == '.') && (this.m_Formula.charAt(this.m_iStart) != '.' || ++nPoints <= 1)) {
                ++this.m_iStart;
            }
            this.m_bAcceptOpt = true;
        } else if (this.m_Formula.charAt(this.m_iStart) >= 'a' && this.m_Formula.charAt(this.m_iStart) <= 'z' || this.m_Formula.charAt(this.m_iStart) >= 'A' && this.m_Formula.charAt(this.m_iStart) <= 'Z' || this.m_Formula.charAt(this.m_iStart) == '_' || this.m_Formula.charAt(this.m_iStart) == '@') {
            ++this.m_iStart;
            while (this.m_iStart < sl && (this.m_Formula.charAt(this.m_iStart) >= '0' && this.m_Formula.charAt(this.m_iStart) <= '9' || this.m_Formula.charAt(this.m_iStart) >= 'a' && this.m_Formula.charAt(this.m_iStart) <= 'z' || this.m_Formula.charAt(this.m_iStart) >= 'A' && this.m_Formula.charAt(this.m_iStart) <= 'Z' || this.m_Formula.charAt(this.m_iStart) == '_' || this.m_Formula.charAt(this.m_iStart) == '@')) {
                ++this.m_iStart;
            }
            this.m_bAcceptOpt = true;
        } else {
            this.m_bAcceptOpt = false;
            switch (this.m_Formula.charAt(this.m_iStart)) {
                case '<': {
                    ++this.m_iStart;
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) != '=' && this.m_Formula.charAt(this.m_iStart) != '>' && this.m_Formula.charAt(this.m_iStart) != '<') break;
                    ++this.m_iStart;
                    break;
                }
                case '>': {
                    ++this.m_iStart;
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) != '=' && this.m_Formula.charAt(this.m_iStart) != '>') break;
                    ++this.m_iStart;
                    break;
                }
                case '!': 
                case '=': {
                    ++this.m_iStart;
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) != '=') break;
                    ++this.m_iStart;
                    break;
                }
                case '|': {
                    ++this.m_iStart;
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) != '|') break;
                    ++this.m_iStart;
                    break;
                }
                case '&': {
                    ++this.m_iStart;
                    if (this.m_iStart >= sl || this.m_Formula.charAt(this.m_iStart) != '&') break;
                    ++this.m_iStart;
                    break;
                }
                case '\"': {
                    ++this.m_iStart;
                    while (this.m_iStart < sl && this.m_Formula.charAt(this.m_iStart) != '\"') {
                        if (this.m_Formula.charAt(this.m_iStart) == '\\') {
                            ++this.m_iStart;
                        }
                        ++this.m_iStart;
                    }
                    if (this.m_iStart < sl) {
                        ++this.m_iStart;
                    }
                    this.m_bAcceptOpt = true;
                    break;
                }
                case '\'': {
                    ++this.m_iStart;
                    while (this.m_iStart < sl && this.m_Formula.charAt(this.m_iStart) != '\'') {
                        if (this.m_Formula.charAt(this.m_iStart) == '\\') {
                            ++this.m_iStart;
                        }
                        ++this.m_iStart;
                    }
                    if (this.m_iStart < sl) {
                        ++this.m_iStart;
                    }
                    this.m_bAcceptOpt = true;
                    break;
                }
                case '.': {
                    ++this.m_iStart;
                    while (this.m_iStart < sl && this.m_Formula.charAt(this.m_iStart) >= '0' && this.m_Formula.charAt(this.m_iStart) <= '9') {
                        ++this.m_iStart;
                    }
                    break;
                }
                case ')': {
                    this.m_bAcceptOpt = true;
                    ++this.m_iStart;
                    break;
                }
                default: {
                    ++this.m_iStart;
                }
            }
        }
        String str = this.m_Formula.substring(bp, this.m_iStart);
        return str;
    }

    public String getAWord() {
        if (this.m_bIsBack) {
            this.m_bIsBack = false;
            return this.m_sCurWord;
        }
        this.m_sCurWord = this.getARegularWord();
        return this.m_sCurWord;
    }

    public String getAWord(boolean bAcceptOpt) {
        this.m_bAcceptOpt = bAcceptOpt;
        return this.getAWord();
    }

    public void seekTORightBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.equals("")) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")")) continue;
            --nBracket;
        } while (nBracket != 0);
    }

    public void skipAOperand() {
        String sWord;
        int nBracket = 0;
        do {
            if ((sWord = this.getAWord()) == null || sWord.equals("")) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")") || --nBracket >= 0) continue;
            this.setPreword(")");
            return;
        } while (!sWord.equals(",") || nBracket != 0);
        this.setPreword(",");
    }

    public String getStringUntil(String szBreak) {
        String sWord;
        int bp = this.m_iStart;
        int ep = this.m_iStart;
        do {
            ep = this.m_iStart;
        } while ((sWord = this.getAWord(false)) != null && !sWord.equals("") && !sWord.equals(szBreak));
        String str = this.m_Formula.substring(bp, ep);
        return str;
    }

    public void seekTo(char cSplit) {
        int sl = this.m_Formula.length();
        while (this.m_iStart < sl && this.m_Formula.charAt(this.m_iStart) != cSplit) {
            ++this.m_iStart;
        }
        if (this.m_iStart < sl) {
            ++this.m_iStart;
        }
    }

    public String getBuffer(int bp, int ep) {
        if (ep - bp < 1) {
            return null;
        }
        return this.m_Formula.substring(bp, ep);
    }
}

