/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.compiler.FunctionInfo;
import com.centit.support.utils.NumberBaseOpt;
import com.centit.support.utils.StringRegularOpt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedFunc {
    public static final int m_uiFunctionSum = 27;
    public static final FunctionInfo[] m_sFunctionList = new FunctionInfo[]{new FunctionInfo("ave", -1, 100, 1), new FunctionInfo("byte", 2, 101, 1), new FunctionInfo("capital", 1, 102, 2), new FunctionInfo("if", 3, 108, 2), new FunctionInfo("case", 2, 116, 2), new FunctionInfo("match", 2, 111, 1), new FunctionInfo("max", -1, 103, 1), new FunctionInfo("min", -1, 104, 1), new FunctionInfo("count", -1, 112, 1), new FunctionInfo("round", 1, 107, 1), new FunctionInfo("strcat", -1, 106, 2), new FunctionInfo("sum", -1, 105, 1), new FunctionInfo("stddev", -1, 133, 1), new FunctionInfo("log", 1, 117, 1), new FunctionInfo("ln", 1, 113, 1), new FunctionInfo("sin", 1, 118, 1), new FunctionInfo("cos", 1, 119, 1), new FunctionInfo("tan", 1, 120, 1), new FunctionInfo("ctan", 1, 121, 1), new FunctionInfo("exp", 1, 114, 1), new FunctionInfo("sqrt", 1, 115, 1), new FunctionInfo("substr", 2, 110, 2), new FunctionInfo("find", 2, 122, 1), new FunctionInfo("frequence", 2, 123, 1), new FunctionInfo("int", 1, 124, 1), new FunctionInfo("integer", 1, 124, 1), new FunctionInfo("frac", 1, 125, 1)};

    public static final int getFuncNo(String sFuncName) {
        for (int i = 0; i < 27; ++i) {
            if (!sFuncName.equalsIgnoreCase(EmbedFunc.m_sFunctionList[i].sName)) continue;
            return i;
        }
        return -1;
    }

    public static final String runFunc(List<String> slOperand, int funcID) {
        int nOpSum = 0;
        if (slOperand != null) {
            nOpSum = slOperand.size();
        }
        String str = "";
        double dbtemp = 0.0;
        switch (funcID) {
            case 100: {
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(slOperand.get(i)).doubleValue();
                }
                str = nOpSum > 0 ? String.format("%f", dbtemp / (double)nOpSum) : "0";
                return str;
            }
            case 101: {
                if (nOpSum < 2 || !StringRegularOpt.IsNumber((String)slOperand.get(1))) {
                    return "";
                }
                String tempstr = slOperand.get(0);
                int nbit = Integer.valueOf(slOperand.get(1));
                if (StringRegularOpt.IsNumber((String)tempstr)) {
                    str = String.valueOf(NumberBaseOpt.GetNumbtye((String)tempstr, (int)nbit));
                } else {
                    int sl = tempstr.length();
                    str = nbit >= 0 && nbit < sl ? String.valueOf(tempstr.charAt(nbit)) : "";
                }
                return str;
            }
            case 111: {
                if (nOpSum < 2) {
                    return "0";
                }
                if (StringRegularOpt.IsMatch((String)slOperand.get(0), (String)slOperand.get(1))) {
                    return "1";
                }
                return "0";
            }
            case 102: {
                if (nOpSum < 1) {
                    return "";
                }
                boolean nT = false;
                if (nOpSum > 1) {
                    nT = StringRegularOpt.IsTrue((String)slOperand.get(1));
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                str = NumberBaseOpt.Capitalization((String)slOperand.get(0), (boolean)nT);
                return str;
            }
            case 103: {
                if (nOpSum < 1) {
                    return "";
                }
                dbtemp = -1.0;
                if (StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    dbtemp = Double.valueOf(slOperand.get(0));
                }
                for (int i = 1; i < nOpSum; ++i) {
                    double tMidF;
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i)) || !(dbtemp < (tMidF = Double.valueOf(slOperand.get(i)).doubleValue()))) continue;
                    dbtemp = tMidF;
                }
                return String.valueOf(dbtemp);
            }
            case 104: {
                dbtemp = -1.0;
                if (nOpSum < 1) {
                    return "";
                }
                if (StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    dbtemp = Double.valueOf(slOperand.get(0));
                }
                for (int i = 1; i < nOpSum; ++i) {
                    double tMidF;
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i)) || !(dbtemp > (tMidF = Double.valueOf(slOperand.get(i)).doubleValue()))) continue;
                    dbtemp = tMidF;
                }
                return String.valueOf(dbtemp);
            }
            case 112: {
                return String.valueOf(nOpSum);
            }
            case 105: {
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(slOperand.get(i)).doubleValue();
                }
                return String.valueOf(dbtemp);
            }
            case 133: {
                if (nOpSum < 2) {
                    return "0";
                }
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(slOperand.get(i)).doubleValue();
                }
                double dbAvg = dbtemp / (double)nOpSum;
                dbtemp = 0.0;
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.IsNumber((String)slOperand.get(i))) continue;
                    double dtp = Double.valueOf(slOperand.get(i)) - dbAvg;
                    dbtemp += dtp * dtp;
                }
                dbtemp = Math.sqrt(dbtemp / (double)(nOpSum - 1));
                str = String.format("%f", dbtemp);
                return str;
            }
            case 106: {
                if (nOpSum < 1) {
                    return "";
                }
                str = "\"";
                for (int i = 0; i < nOpSum; ++i) {
                    str = str + StringRegularOpt.TrimString((String)slOperand.get(i));
                }
                str = str + '\"';
                return str;
            }
            case 110: {
                int nLength;
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nStart = 0;
                if (StringRegularOpt.IsNumber((String)slOperand.get(1))) {
                    nStart = Integer.valueOf(slOperand.get(1));
                }
                if ((nLength = nOpSum > 2 && StringRegularOpt.IsNumber((String)slOperand.get(2)) ? Integer.valueOf(slOperand.get(2)).intValue() : slOperand.get(0).length()) <= 0) {
                    nLength = 1;
                }
                String tempstr = slOperand.get(0).substring(nStart, nStart + nLength);
                str = '\"' + tempstr + '\"';
                return str;
            }
            case 122: {
                if (nOpSum < 2) {
                    return "-1";
                }
                int nStart = 0;
                if (nOpSum > 2 && StringRegularOpt.IsNumber((String)slOperand.get(2))) {
                    nStart = Integer.valueOf(slOperand.get(2));
                }
                String tempstr = StringRegularOpt.TrimString((String)slOperand.get(0));
                str = StringRegularOpt.TrimString((String)slOperand.get(1));
                int nS = tempstr.indexOf(str, nStart);
                return String.format("%d", nS);
            }
            case 123: {
                if (nOpSum < 2) {
                    return "-1";
                }
                String tempstr = StringRegularOpt.TrimString((String)slOperand.get(0));
                str = StringRegularOpt.TrimString((String)slOperand.get(1));
                int nSt = 0;
                int sl = str.length();
                int nC = 0;
                nSt = tempstr.indexOf(str, nSt);
                while (nSt >= 0) {
                    ++nC;
                    nSt += sl;
                    nSt = tempstr.indexOf(str, nSt);
                }
                return String.valueOf(nC);
            }
            case 107: {
                if (nOpSum < 1) {
                    return "";
                }
                if (StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                int nS = 0;
                if (nOpSum > 1 && StringRegularOpt.IsNumber((String)slOperand.get(1))) {
                    nS = Double.valueOf(slOperand.get(1)).intValue();
                }
                if (nS < 0) {
                    nS = 0;
                }
                return String.format("%." + String.valueOf(nS) + "f", slOperand.get(1));
            }
            case 113: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.log(af);
                return String.valueOf(af);
            }
            case 117: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.log10(af);
                return String.valueOf(af);
            }
            case 118: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.sin(af);
                return String.valueOf(af);
            }
            case 119: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.cos(af);
                return String.valueOf(af);
            }
            case 120: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.tan(af);
                return String.valueOf(af);
            }
            case 121: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.atan(af);
                return String.valueOf(af);
            }
            case 124: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                int nN = Double.valueOf(slOperand.get(0)).intValue();
                return String.valueOf(nN);
            }
            case 125: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                int nN = Double.valueOf(slOperand.get(0)).intValue();
                return String.valueOf(af - (double)nN);
            }
            case 114: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.exp(af);
                return String.valueOf(af);
            }
            case 115: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.IsNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(slOperand.get(0));
                af = Math.sqrt(af);
                return String.valueOf(af);
            }
            case 108: {
                if (nOpSum < 2) {
                    return "";
                }
                String str1 = "";
                if (nOpSum > 2) {
                    str1 = slOperand.get(2);
                }
                if (StringRegularOpt.IsTrue((String)slOperand.get(0))) {
                    return slOperand.get(1);
                }
                return str1;
            }
            case 116: {
                if (nOpSum < 2) {
                    return "";
                }
                String tempstr = StringRegularOpt.TrimString((String)slOperand.get(0));
                int MatchType = 0;
                if (tempstr.equalsIgnoreCase("true")) {
                    MatchType = 1;
                } else if (StringRegularOpt.IsNumber((String)tempstr)) {
                    dbtemp = Double.valueOf(tempstr);
                    MatchType = 2;
                }
                int i = 1;
                while (i + 1 < nOpSum) {
                    if (MatchType == 1 ? StringRegularOpt.IsTrue((String)slOperand.get(i)) : (MatchType == 2 ? StringRegularOpt.IsNumber((String)slOperand.get(i)) && Math.abs(dbtemp - Double.valueOf(slOperand.get(i))) < 1.0E-4 : tempstr.equals(StringRegularOpt.TrimString((String)slOperand.get(i))))) {
                        return slOperand.get(i + 1);
                    }
                    i += 2;
                }
                if (nOpSum % 2 == 0) {
                    return slOperand.get(nOpSum - 1);
                }
                return "";
            }
        }
        return "";
    }
}

