package com.centit.support.compiler;

import com.centit.support.utils.StringBaseOpt;


public class Lexer {

	/**
	 * @param args
	 */
	private String curWord;
	private boolean isBack;
	private String formulaSen;
	private boolean canAcceptOpt;
	private int startPos ;
	
	public void setPreword(String preWord)
	{
		curWord = preWord; 
		isBack = true;
	}
	
	public void setFormula(String sFormula)
	{
		formulaSen = sFormula;
		isBack  = false;
		curWord = "";
		startPos = 0;
		canAcceptOpt = false;
	}
	
	public Lexer()
	{
		setFormula(null);
	}
	
	public Lexer(String sFormula)
	{
		setFormula(sFormula);
	}
	
	public int getCurrPos()
	{
		return startPos;
	}
	
	static public boolean isLabel(String sWord)
	{   
		if(sWord.length() < 1)
			return false;
		char c = sWord.charAt(0); 
		return ( c == '_' ||
				( c >= 'a' && c <= 'z') ||
				( c >= 'A' && c <= 'Z')
			 );
	}
	
	public String getARegularWord()
	{
		int sl = formulaSen.length();

		while((startPos < sl ) && (formulaSen.charAt(startPos) == ' ' || formulaSen.charAt(startPos) == 9 || formulaSen.charAt(startPos) == 10|| formulaSen.charAt(startPos) == 13)) startPos++;
		if(startPos >= sl) return "";
			

		int bp = startPos;
		// 数字
		if( (formulaSen.charAt(startPos)>='0' && formulaSen.charAt(startPos)<='9') || 
			//m_Formula.charAt(m_iStart)== '.' ||
			( ! canAcceptOpt && (formulaSen.charAt(startPos)== '-' || formulaSen.charAt(startPos)== '+' ) ) ){
			startPos++;
			int nPoints = 0;
			while ( startPos < sl  && (
					( formulaSen.charAt(startPos)>='0' && formulaSen.charAt(startPos)<='9') ||
                     formulaSen.charAt(startPos)=='.'  ))
			{ 
				if( formulaSen.charAt(startPos)=='.' ){
					nPoints ++;
					if (nPoints>1)
						break;
				}
				startPos ++;
			}
			canAcceptOpt = true;			
		// 标识符	
		} else if (( formulaSen.charAt(startPos)>='a' && formulaSen.charAt(startPos)<='z') ||
			( formulaSen.charAt(startPos)>='A' && formulaSen.charAt(startPos)<='Z') ||
			formulaSen.charAt(startPos)=='_' ||
			formulaSen.charAt(startPos)=='@'  ){
			startPos++;
			while ( startPos < sl  && (
					( formulaSen.charAt(startPos)>='0' && formulaSen.charAt(startPos)<='9') ||
					( formulaSen.charAt(startPos)>='a' && formulaSen.charAt(startPos)<='z') ||
					( formulaSen.charAt(startPos)>='A' && formulaSen.charAt(startPos)<='Z') ||
					  formulaSen.charAt(startPos)=='_' || // m_Formula.charAt(m_iStart)=='.' ||
					  formulaSen.charAt(startPos)=='@' ) ) 
				startPos ++;
			canAcceptOpt = true;
		}else {
			canAcceptOpt = false;
			switch(formulaSen.charAt(startPos)){
			case '+':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '=') || 
									 (formulaSen.charAt(startPos) == '+')  ) ) startPos ++;
				break;
			case '-':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '=') || 
									 (formulaSen.charAt(startPos) == '-')  ) ) startPos ++;
				break;
			case '*':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '*') || 
									 (formulaSen.charAt(startPos) == '=') ||
									 (formulaSen.charAt(startPos) == '/')   ) ) startPos ++;
				break;	
			case '/':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '=') || 
									 (formulaSen.charAt(startPos) == '/') ||
									 (formulaSen.charAt(startPos) == '*')   ) ) startPos ++;
				break;	
				
			case '<':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '=') || 
									 (formulaSen.charAt(startPos) == '>') ||
									 (formulaSen.charAt(startPos) == '<')   ) ) startPos ++;
				break;	
			case '>':
				++startPos;
				if((startPos<sl) && ((formulaSen.charAt(startPos) == '=') || 
									 (formulaSen.charAt(startPos) == '>')  ) ) startPos ++;
				break;
			case '=':
			case '!':
				++startPos;
				if((startPos<sl) && (formulaSen.charAt(startPos) == '=')) startPos ++;
				break;
			case '|':
				++startPos;
				if((startPos<sl) && (formulaSen.charAt(startPos) == '|')) startPos ++;
				break;
			case '&':
				++startPos;
				if((startPos<sl) && (formulaSen.charAt(startPos) == '&')) startPos ++;
				break;
			case '\"': //字符串
//				bp++;
				++startPos;
				while(startPos < sl && formulaSen.charAt(startPos) != '\"') {
					 if (formulaSen.charAt(startPos)=='\\')
							startPos++;
						 startPos++;
					}
				if(startPos < sl) startPos ++;
				canAcceptOpt = true;
				break;
			case '\'': //字符串
//				bp++;
				++startPos;
				while(startPos < sl && formulaSen.charAt(startPos) != '\'') {
					 if (formulaSen.charAt(startPos)=='\\')
						startPos++;
					 startPos++;
				}
				if(startPos < sl) startPos ++;
				canAcceptOpt = true;
				break;
			case '.':
				++startPos;
				while ( startPos < sl  && 
						( formulaSen.charAt(startPos)>='0' && formulaSen.charAt(startPos)<='9') )
				{ 
					startPos ++;
				}				
				break;
			case ')':
				canAcceptOpt = true;
				startPos ++;
				break;
			default: //"+-*/"
				startPos ++;
				break;
			}
		}
		
		String str = formulaSen.substring(bp, startPos );
		return str;	
	}
	
	public String getAWord( )
	{
		if (isBack) {
			isBack = false;
			return curWord;
		}
		
		while(true){
			curWord =  getARegularWord();
			if(curWord==null || "".equals(curWord))
				break;
			else if("//".equals(curWord))
				this.seekToLineEnd();
			else if("/*".equals(curWord))
				this.seekToAnnotateEnd();
			else
				break;			
		}
		return curWord;
	}
	
	public String getAWord(boolean bAcceptOpt )
	{
		canAcceptOpt = bAcceptOpt;
		return getAWord( );
	}
	
	public void seekToLineEnd(){
		int sl = formulaSen.length();
		while( (startPos < sl ) && (formulaSen.charAt(startPos) != 10 ))
			startPos ++;
	}
	
	/**
	 * 将解释位置滑动到注释结束位置 '*'+'/'
	 */
	public void seekToAnnotateEnd(){
		int sl = formulaSen.length();
		while( (startPos < sl-1 ) && (formulaSen.charAt(startPos) != '*' || formulaSen.charAt(startPos+1) != '/' ))
			startPos ++;
		if(formulaSen.charAt(startPos) == '*' || formulaSen.charAt(startPos+1) == '/')
			startPos += 2;
	}
	
	public void seekToRightBracket()
	{
		int nBracket = 1;
		while(true){
			String sWord = getAWord(false);
			if (sWord==null || sWord.equals(""))
				return;
			if (sWord.equals("("))
				nBracket ++;
			else if (sWord.equals(")"))
				nBracket --;
			if (nBracket==0)
				return;
		}
	}	
	
	public void skipAOperand()
	{
		int nBracket = 0;
		String sWord;
		while(true){
			sWord = getAWord();
			if (sWord==null || sWord.equals(""))
				return;
			if (sWord.equals("("))
				nBracket ++;
			else if (sWord.equals(")")){
				nBracket--;
				if(nBracket<0) {
					setPreword(")");
					return;
				}
			}
	
			if(sWord.equals(",")){
				if(nBracket==0) {
					setPreword(",");
					return;
				}
			}
		}
	}
	
	public String getStringUntil(String szBreak)
	{
		int bp = startPos;
		int ep = startPos;
		while(true){
			ep = startPos;
			String sWord = getAWord(false);
			if (sWord == null || sWord.equals("") || sWord.equals(szBreak))
				break;
		}
		String str = formulaSen.substring(bp, ep );
		return str;	
	}
	
	public void seekTo(char cSplit){
		int sl = formulaSen.length();
		while((startPos < sl ) && (formulaSen.charAt(startPos) != cSplit))
			startPos ++;
		if(startPos < sl)
			startPos ++;
	}
	
	public String getBuffer(int bp, int ep){
		if(ep-bp < 1)
			return null;			 
		return formulaSen.substring(bp, ep );
	}
	/**
	 * 
	 * @param aword
	 * @param caseSensitives 
	 * @param skipAnnotate
	 * @return 发现点
	 */
	public int findWord(String aword,final boolean caseSensitives,final boolean skipAnnotate)
	{
		String curWord=skipAnnotate?this.getAWord():this.getARegularWord();
		while(!StringBaseOpt.isNvl(curWord)){
			if(curWord.equals(aword) || (!caseSensitives && curWord.equalsIgnoreCase(aword)) )
				return this.getCurrPos() - curWord.length();
			curWord=skipAnnotate?this.getAWord():this.getARegularWord();
		}	
		return -1;
	}

}
