package com.centit.support.compiler;

import java.util.Map;

public class MapTranslate implements VariableTranslate {

	private Map<String,String> varMap;
	//public
	public MapTranslate(){
		varMap = null;
	}
	public MapTranslate(Map<String,String> varMap) {
		this.varMap = varMap;
	}
	
	@Override
	public String getVarValue(String varName) {
		if(varMap==null)
			return "''";
		
		String res = varMap.get(varName);
		if(res==null)
			res = "''";
		return res;		
	}

	@Override
	public String getLabelValue(String labelName) {
		String res = getVarValue(labelName);
		if("''".equals(res))//res == null || 
			return labelName;
		return res;
	}

	public Map<String,String> getVarMap() {
		return varMap;
	}

	public void setVarMap(Map<String,String> varMap) {
		this.varMap = varMap;
	}

}

