/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.utils.StringBaseOpt;

public class Lexer {
    private String curWord;
    private boolean isBack;
    private String formulaSen;
    private boolean canAcceptOpt;
    private int startPos;

    public void setPreword(String preWord) {
        this.curWord = preWord;
        this.isBack = true;
    }

    public void setFormula(String sFormula) {
        this.formulaSen = sFormula;
        this.isBack = false;
        this.curWord = "";
        this.startPos = 0;
        this.canAcceptOpt = false;
    }

    public Lexer() {
        this.setFormula(null);
    }

    public Lexer(String sFormula) {
        this.setFormula(sFormula);
    }

    public int getCurrPos() {
        return this.startPos;
    }

    public static boolean isLabel(String sWord) {
        if (sWord.length() < 1) {
            return false;
        }
        char c = sWord.charAt(0);
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public String getARegularWord() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) == ' ' || this.formulaSen.charAt(this.startPos) == '\t' || this.formulaSen.charAt(this.startPos) == '\n' || this.formulaSen.charAt(this.startPos) == '\r')) {
            ++this.startPos;
        }
        if (this.startPos >= sl) {
            return "";
        }
        int bp = this.startPos;
        if (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || !this.canAcceptOpt && (this.formulaSen.charAt(this.startPos) == '-' || this.formulaSen.charAt(this.startPos) == '+')) {
            ++this.startPos;
            int nPoints = 0;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) == '.') && (this.formulaSen.charAt(this.startPos) != '.' || ++nPoints <= 1)) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else if (this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '@') {
            ++this.startPos;
            while (this.startPos < sl && (this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9' || this.formulaSen.charAt(this.startPos) >= 'a' && this.formulaSen.charAt(this.startPos) <= 'z' || this.formulaSen.charAt(this.startPos) >= 'A' && this.formulaSen.charAt(this.startPos) <= 'Z' || this.formulaSen.charAt(this.startPos) == '_' || this.formulaSen.charAt(this.startPos) == '@')) {
                ++this.startPos;
            }
            this.canAcceptOpt = true;
        } else {
            this.canAcceptOpt = false;
            switch (this.formulaSen.charAt(this.startPos)) {
                case '+': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '+') break;
                    ++this.startPos;
                    break;
                }
                case '-': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '-') break;
                    ++this.startPos;
                    break;
                }
                case '*': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '*' && this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/') break;
                    ++this.startPos;
                    break;
                }
                case '/': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '/' && this.formulaSen.charAt(this.startPos) != '*') break;
                    ++this.startPos;
                    break;
                }
                case '<': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>' && this.formulaSen.charAt(this.startPos) != '<') break;
                    ++this.startPos;
                    break;
                }
                case '>': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=' && this.formulaSen.charAt(this.startPos) != '>') break;
                    ++this.startPos;
                    break;
                }
                case '!': 
                case '=': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '=') break;
                    ++this.startPos;
                    break;
                }
                case '|': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '|') break;
                    ++this.startPos;
                    break;
                }
                case '&': {
                    ++this.startPos;
                    if (this.startPos >= sl || this.formulaSen.charAt(this.startPos) != '&') break;
                    ++this.startPos;
                    break;
                }
                case '\"': {
                    ++this.startPos;
                    while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\"') {
                        if (this.formulaSen.charAt(this.startPos) == '\\') {
                            ++this.startPos;
                        }
                        ++this.startPos;
                    }
                    if (this.startPos < sl) {
                        ++this.startPos;
                    }
                    this.canAcceptOpt = true;
                    break;
                }
                case '\'': {
                    ++this.startPos;
                    while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\'') {
                        if (this.formulaSen.charAt(this.startPos) == '\\') {
                            ++this.startPos;
                        }
                        ++this.startPos;
                    }
                    if (this.startPos < sl) {
                        ++this.startPos;
                    }
                    this.canAcceptOpt = true;
                    break;
                }
                case '.': {
                    ++this.startPos;
                    while (this.startPos < sl && this.formulaSen.charAt(this.startPos) >= '0' && this.formulaSen.charAt(this.startPos) <= '9') {
                        ++this.startPos;
                    }
                    break;
                }
                case ')': {
                    this.canAcceptOpt = true;
                    ++this.startPos;
                    break;
                }
                default: {
                    ++this.startPos;
                }
            }
        }
        String str = this.formulaSen.substring(bp, this.startPos);
        return str;
    }

    public String getAWord() {
        if (this.isBack) {
            this.isBack = false;
            return this.curWord;
        }
        while (true) {
            this.curWord = this.getARegularWord();
            if (this.curWord == null || "".equals(this.curWord)) break;
            if ("//".equals(this.curWord)) {
                this.seekToLineEnd();
                continue;
            }
            if (!"/*".equals(this.curWord)) break;
            this.seekToAnnotateEnd();
        }
        return this.curWord;
    }

    public String getAWord(boolean bAcceptOpt) {
        this.canAcceptOpt = bAcceptOpt;
        return this.getAWord();
    }

    public void seekToLineEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != '\n') {
            ++this.startPos;
        }
    }

    public void seekToAnnotateEnd() {
        int sl = this.formulaSen.length();
        while (this.startPos < sl - 1 && (this.formulaSen.charAt(this.startPos) != '*' || this.formulaSen.charAt(this.startPos + 1) != '/')) {
            ++this.startPos;
        }
        if (this.formulaSen.charAt(this.startPos) == '*' || this.formulaSen.charAt(this.startPos + 1) == '/') {
            this.startPos += 2;
        }
    }

    public void seekToRightBracket() {
        int nBracket = 1;
        do {
            String sWord;
            if ((sWord = this.getAWord(false)) == null || sWord.equals("")) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")")) continue;
            --nBracket;
        } while (nBracket != 0);
    }

    public void skipAOperand() {
        String sWord;
        int nBracket = 0;
        do {
            if ((sWord = this.getAWord()) == null || sWord.equals("")) {
                return;
            }
            if (sWord.equals("(")) {
                ++nBracket;
                continue;
            }
            if (!sWord.equals(")") || --nBracket >= 0) continue;
            this.setPreword(")");
            return;
        } while (!sWord.equals(",") || nBracket != 0);
        this.setPreword(",");
    }

    public String getStringUntil(String szBreak) {
        String sWord;
        int bp = this.startPos;
        int ep = this.startPos;
        do {
            ep = this.startPos;
        } while ((sWord = this.getAWord(false)) != null && !sWord.equals("") && !sWord.equals(szBreak));
        String str = this.formulaSen.substring(bp, ep);
        return str;
    }

    public void seekTo(char cSplit) {
        int sl = this.formulaSen.length();
        while (this.startPos < sl && this.formulaSen.charAt(this.startPos) != cSplit) {
            ++this.startPos;
        }
        if (this.startPos < sl) {
            ++this.startPos;
        }
    }

    public String getBuffer(int bp, int ep) {
        if (ep - bp < 1) {
            return null;
        }
        return this.formulaSen.substring(bp, ep);
    }

    public int findWord(String aword, boolean caseSensitives, boolean skipAnnotate) {
        String curWord;
        String string = curWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        while (!StringBaseOpt.isNvl((String)curWord)) {
            if (curWord.equals(aword) || !caseSensitives && curWord.equalsIgnoreCase(aword)) {
                return this.getCurrPos() - curWord.length();
            }
            curWord = skipAnnotate ? this.getAWord() : this.getARegularWord();
        }
        return -1;
    }
}

