/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Formula;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.OptStack;
import com.centit.support.compiler.VariableTranslate;
import java.math.BigDecimal;
import java.util.ArrayList;

public class VariableFormula {
    private Lexer lex = new Lexer();
    private VariableTranslate trans;

    public void setTrans(VariableTranslate trans) {
        this.trans = trans;
    }

    public void setFormula(String formula) {
        this.lex.setFormula(formula);
    }

    private Object calcItem() {
        String str = this.lex.getAWord();
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == ')' || str.charAt(0) == ',') {
            this.lex.setPreword(str);
            return null;
        }
        if (str.charAt(0) == '(') {
            Object resStr = this.calcFormula();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || str.charAt(0) != ')') {
                return null;
            }
            return resStr;
        }
        if (str.charAt(0) == '!' || str.equalsIgnoreCase("NOT")) {
            Object obj = this.calcItem();
            return BooleanBaseOpt.castObjectToBoolean((Object)obj, (Boolean)false) == false;
        }
        if (str.charAt(0) == '$') {
            str = this.lex.getAWord();
            if (str.equals("{")) {
                str = this.lex.getStringUntil("}");
                return this.trans.getLabelValue(str);
            }
            return null;
        }
        int funcNo = Formula.getFuncNo(str);
        if (funcNo != -1) {
            return this.calcFunc(funcNo, str);
        }
        if (this.trans != null && Lexer.isLabel(str)) {
            return this.trans.getLabelValue(str);
        }
        String res = StringRegularOpt.trimString((String)str);
        if (StringRegularOpt.isNumber((String)res)) {
            return NumberBaseOpt.castObjectToNumber((Object)res);
        }
        return res;
    }

    private Object calcOperate(Object operand, Object operand2, int optID) {
        switch (optID) {
            case 48: {
                return BooleanBaseOpt.castObjectToBoolean((Object)operand, (Boolean)false) != false || BooleanBaseOpt.castObjectToBoolean((Object)operand2, (Boolean)false) != false;
            }
            case 41: 
            case 49: {
                return BooleanBaseOpt.castObjectToBoolean((Object)operand, (Boolean)false) != false && BooleanBaseOpt.castObjectToBoolean((Object)operand2, (Boolean)false) != false;
            }
            case 40: {
                if ((BooleanBaseOpt.isBoolean((Object)operand) || NumberBaseOpt.isNumber((Object)operand)) && (BooleanBaseOpt.isBoolean((Object)operand2) || NumberBaseOpt.isNumber((Object)operand2))) {
                    return BooleanBaseOpt.castObjectToBoolean((Object)operand) != false || BooleanBaseOpt.castObjectToBoolean((Object)operand2) != false;
                }
                return StringBaseOpt.concat((Object[])new Object[]{operand, operand2});
            }
            case 30: {
                return GeneralAlgorithm.addTwoObject((Object)operand, (Object)operand2);
            }
            case 32: {
                if (NumberBaseOpt.isNumber((Object)operand) && NumberBaseOpt.isNumber((Object)operand2)) {
                    return GeneralAlgorithm.multiplyTwoObject((Object)operand, (Object)operand2);
                }
                return StringBaseOpt.concat((Object[])new Object[]{operand, operand2});
            }
            case 34: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) == 0;
            }
            case 35: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) > 0;
            }
            case 36: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) < 0;
            }
            case 37: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) <= 0;
            }
            case 38: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) >= 0;
            }
            case 39: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) != 0;
            }
            case 44: {
                if (NumberBaseOpt.isNumber((Object)operand2)) {
                    int nP2 = NumberBaseOpt.castObjectToInteger((Object)operand2);
                    if (NumberBaseOpt.isNumber((Object)operand)) {
                        int nP = NumberBaseOpt.castObjectToInteger((Object)operand);
                        return nP << nP2;
                    }
                    String str1 = StringBaseOpt.objectToString((Object)operand);
                    if (nP2 >= 0 && str1.length() > nP2) {
                        return str1.substring(nP2);
                    }
                }
                return null;
            }
            case 45: {
                if (NumberBaseOpt.isNumber((Object)operand2)) {
                    int nP2 = NumberBaseOpt.castObjectToInteger((Object)operand2);
                    if (NumberBaseOpt.isNumber((Object)operand)) {
                        int nP = NumberBaseOpt.castObjectToInteger((Object)operand);
                        return nP >> nP2;
                    }
                    String str1 = StringBaseOpt.objectToString((Object)operand);
                    if (nP2 >= 0 && str1.length() > nP2) {
                        return str1.substring(0, str1.length() - nP2);
                    }
                }
                return null;
            }
            case 46: {
                return StringRegularOpt.isMatch((String)StringBaseOpt.objectToString((Object)operand), (String)StringBaseOpt.objectToString((Object)operand2));
            }
            case 31: {
                return GeneralAlgorithm.subtractTwoObject((Object)operand, (Object)operand2);
            }
            case 33: {
                BigDecimal dbop2 = NumberBaseOpt.castObjectToBigDecimal((Object)operand2);
                if (dbop2 == null || dbop2.compareTo(BigDecimal.ZERO) == 0) {
                    return null;
                }
                return GeneralAlgorithm.divideTwoObject((Object)operand, (Object)operand2);
            }
            case 43: {
                Double dbop = NumberBaseOpt.castObjectToDouble((Object)operand);
                Double dbop2 = NumberBaseOpt.castObjectToDouble((Object)operand2);
                if (dbop == null || dbop2 == null) {
                    return null;
                }
                return Math.pow(dbop, dbop2);
            }
        }
        return null;
    }

    public Object calcFormula() {
        ArrayList<Object> slOperand = new ArrayList<Object>();
        OptStack optStack = new OptStack();
        block0: while (true) {
            Object item = this.calcItem();
            slOperand.add(0, item);
            String str = this.lex.getAWord();
            if (str == null || str.length() == 0) break;
            int optID = Formula.getOptID(str);
            if (optID == -1) {
                this.lex.setPreword(str);
                break;
            }
            if (optID == 47) {
                Boolean bInRes = false;
                Object operand = slOperand.remove(0);
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals("(")) {
                    return null;
                }
                do {
                    if (GeneralAlgorithm.compareTwoObject(operand, (Object)(item = this.calcFormula())) == 0) {
                        bInRes = true;
                    }
                    if ((str = this.lex.getAWord()) != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
                    return null;
                } while (!str.equals(")"));
                this.lex.setPreword(str);
                this.lex.seekToRightBracket();
                slOperand.add(0, bInRes);
                str = this.lex.getAWord();
                optID = Formula.getOptID(str);
                if (optID == -1) {
                    this.lex.setPreword(str);
                    break;
                }
            }
            int op = optStack.pushOpt(optID);
            while (true) {
                if (op == 0) continue block0;
                Object operand2 = slOperand.remove(0);
                Object operand = slOperand.remove(0);
                slOperand.add(0, this.calcOperate(operand, operand2, op));
                op = optStack.pushOpt(optID);
            }
            break;
        }
        int op = optStack.popOpt();
        while (op != 0) {
            Object operand2 = slOperand.remove(0);
            Object operand = slOperand.remove(0);
            slOperand.add(0, this.calcOperate(operand, operand2, op));
            op = optStack.popOpt();
        }
        return slOperand.get(0);
    }

    private Object calcFunc(int nFuncNo, String funcName) {
        String str = this.lex.getAWord();
        if (str == null || str.length() == 0 || !str.equals("(")) {
            if (str != null && str.length() > 0) {
                this.lex.setPreword(str);
            }
            return funcName;
        }
        int prmNo = 0;
        if (EmbedFunc.functionsList[nFuncNo].nFuncID == 108) {
            Object sCondition = this.calcFormula();
            if (sCondition == null) {
                return null;
            }
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",")) {
                return null;
            }
            if (BooleanBaseOpt.castObjectToBoolean((Object)sCondition, (Boolean)false).booleanValue()) {
                Object objRes = this.calcFormula();
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                    return null;
                }
                if (str.equals(")")) {
                    return objRes;
                }
                this.lex.skipAOperand();
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(")")) {
                    return null;
                }
                return objRes;
            }
            this.lex.skipAOperand();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                return null;
            }
            if (str.equals(")")) {
                return null;
            }
            Object objRes = this.calcFormula();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(")")) {
                return null;
            }
            return objRes;
        }
        ArrayList<Object> slOperand = new ArrayList<Object>(5);
        do {
            ++prmNo;
            Object item = this.calcFormula();
            slOperand.add(item);
            str = this.lex.getAWord();
            if (str != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
            return null;
        } while (!str.equals(")"));
        if (!str.equals(")")) {
            return null;
        }
        if (EmbedFunc.functionsList[nFuncNo].nPrmSum != -1 && prmNo < EmbedFunc.functionsList[nFuncNo].nPrmSum) {
            return null;
        }
        return EmbedFunc.runFuncWithRaw(slOperand, EmbedFunc.functionsList[nFuncNo].nFuncID);
    }

    public static Object calculate(String szExpress) {
        VariableFormula formula = new VariableFormula();
        formula.setFormula(szExpress);
        return formula.calcFormula();
    }

    public static Object calculate(String szExpress, VariableTranslate varTrans) {
        VariableFormula formula = new VariableFormula();
        formula.setFormula(szExpress);
        formula.setTrans(varTrans);
        return formula.calcFormula();
    }

    public static Object calculate(String szExpress, Object varMap) {
        return VariableFormula.calculate(szExpress, new ObjectTranslate(varMap));
    }
}

