/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.OptStack;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.VariableTranslate;
import java.math.BigDecimal;
import java.util.ArrayList;

@Deprecated
public class Formula {
    private Lexer lex = new Lexer();

    public void setFormula(String formula) {
        this.lex.setFormula(formula);
    }

    public static int getFuncNo(String sFuncName) {
        return EmbedFunc.getFuncNo(sFuncName);
    }

    public static int getOptID(String sOptName) {
        int sl = sOptName.length();
        if (sl == 0) {
            return -1;
        }
        char sp = sOptName.charAt(0);
        char sp2 = '\u0000';
        if (sl > 1) {
            sp2 = sOptName.charAt(1);
        }
        switch (sp) {
            case '=': {
                if (sp2 == '=') {
                    return 34;
                }
                return 34;
            }
            case '+': {
                return 30;
            }
            case '-': {
                return 31;
            }
            case '*': {
                return 32;
            }
            case '/': {
                return 33;
            }
            case '%': {
                return 50;
            }
            case '^': {
                return 43;
            }
            case '>': {
                if (sp2 == '=') {
                    return 38;
                }
                if (sp2 == '>') {
                    return 45;
                }
                return 35;
            }
            case '<': {
                if (sp2 == '=') {
                    return 37;
                }
                if (sp2 == '>') {
                    return 39;
                }
                if (sp2 == '<') {
                    return 44;
                }
                return 36;
            }
            case '&': {
                if (sp2 == '&') {
                    return 41;
                }
                return 41;
            }
            case '|': {
                if (sp2 == '|') {
                    return 40;
                }
                return 40;
            }
            case '!': {
                if (sp2 == '=') {
                    return 39;
                }
                return 42;
            }
        }
        if (sOptName.equalsIgnoreCase("LIKE")) {
            return 46;
        }
        if (sOptName.equalsIgnoreCase("AND")) {
            return 49;
        }
        if (sOptName.equalsIgnoreCase("OR")) {
            return 48;
        }
        if (sOptName.equalsIgnoreCase("NOT")) {
            return 42;
        }
        if (sOptName.equalsIgnoreCase("IN")) {
            return 47;
        }
        if (sOptName.equalsIgnoreCase("DIV")) {
            return 33;
        }
        if (sOptName.equalsIgnoreCase("MOD")) {
            return 50;
        }
        if (sOptName.equalsIgnoreCase("DBMOD")) {
            return 51;
        }
        return -1;
    }

    public static final boolean isKeyWord(String sWord) {
        if (sWord == null || sWord.length() == 0) {
            return false;
        }
        char firstChar = sWord.charAt(0);
        if (firstChar == ',' || firstChar == '(' || firstChar == ')') {
            return true;
        }
        if (firstChar == '-' && sWord.length() > 1) {
            return false;
        }
        return Formula.getOptID(sWord) > 0;
    }

    private String calcItem() {
        String str = this.lex.getAWord();
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == ')' || str.charAt(0) == ',') {
            this.lex.setPreword(str);
            return null;
        }
        if (str.charAt(0) == '(') {
            String resstr = this.calcFormula();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || str.charAt(0) != ')') {
                return null;
            }
            return resstr;
        }
        if (str.charAt(0) == '!' || str.equalsIgnoreCase("NOT")) {
            str = this.calcItem();
            return StringRegularOpt.isTrue((String)str) ? "0" : "1";
        }
        int funcNo = Formula.getFuncNo(str);
        if (funcNo != -1) {
            str = this.calcFunc(funcNo, str);
        }
        return str;
    }

    private String calcOperate(String operand, String operand2, int optID) {
        String str1 = StringRegularOpt.trimString((String)operand);
        String str2 = StringRegularOpt.trimString((String)operand2);
        switch (optID) {
            case 48: {
                boolean bop = StringRegularOpt.isTrue((String)str1);
                boolean bop2 = StringRegularOpt.isTrue((String)str2);
                if (bop || bop2) {
                    return "1";
                }
                return "0";
            }
            case 41: 
            case 49: {
                boolean bop = StringRegularOpt.isTrue((String)str1);
                boolean bop2 = StringRegularOpt.isTrue((String)str2);
                if (bop && bop2) {
                    return "1";
                }
                return "0";
            }
        }
        if (!StringRegularOpt.isNumber((String)str1) || !StringRegularOpt.isNumber((String)str2)) {
            int res = str1.compareTo(str2);
            switch (optID) {
                case 30: 
                case 32: 
                case 40: {
                    return String.format("\"%s%s\"", str1, str2);
                }
                case 34: {
                    if (res == 0) {
                        return "1";
                    }
                    return "0";
                }
                case 35: {
                    if (res > 0) {
                        return "1";
                    }
                    return "0";
                }
                case 36: {
                    if (res < 0) {
                        return "1";
                    }
                    return "0";
                }
                case 37: {
                    if (res <= 0) {
                        return "1";
                    }
                    return "0";
                }
                case 38: {
                    if (res >= 0) {
                        return "1";
                    }
                    return "0";
                }
                case 39: {
                    if (res != 0) {
                        return "1";
                    }
                    return "0";
                }
                case 44: {
                    int nP2;
                    if (StringRegularOpt.isNumber((String)str2) && (nP2 = Double.valueOf(str2).intValue()) >= 0 && str1.length() > nP2) {
                        String str = str1.substring(nP2);
                        return str;
                    }
                    return null;
                }
                case 45: {
                    int nP2;
                    if (StringRegularOpt.isNumber((String)str2) && (nP2 = Double.valueOf(str2).intValue()) >= 0 && str1.length() > nP2) {
                        String str = str1.substring(0, str1.length() - nP2);
                        return str;
                    }
                    return null;
                }
                case 46: {
                    if (StringRegularOpt.isMatch((String)str1, (String)str2)) {
                        return "1";
                    }
                    return "0";
                }
            }
            return null;
        }
        double dbop = Double.valueOf(str1);
        double dbop2 = Double.valueOf(str2);
        switch (optID) {
            case 40: {
                boolean bop = StringRegularOpt.isTrue((String)str1);
                boolean bop2 = StringRegularOpt.isTrue((String)str2);
                if (bop || bop2) {
                    return "1";
                }
                return "0";
            }
            case 30: {
                return String.format("%f", dbop + dbop2);
            }
            case 31: {
                return String.format("%f", dbop - dbop2);
            }
            case 32: {
                return String.format("%f", dbop * dbop2);
            }
            case 33: {
                if (BigDecimal.valueOf(dbop2).compareTo(BigDecimal.ZERO) == 0) {
                    return "0";
                }
                return String.format("%f", dbop / dbop2);
            }
            case 51: {
                if (BigDecimal.valueOf(dbop2).compareTo(BigDecimal.ZERO) == 0) {
                    return "0";
                }
                return String.format("%f", dbop % dbop2);
            }
            case 50: {
                Long long2 = NumberBaseOpt.castObjectToLong((Object)dbop2);
                if (long2 == null || long2 == 0L) {
                    return "0";
                }
                Long long1 = NumberBaseOpt.castObjectToLong((Object)dbop);
                return String.format("%d", long1 % long2);
            }
            case 34: {
                if (BigDecimal.valueOf(dbop).compareTo(BigDecimal.valueOf(dbop2)) == 0) {
                    return "1";
                }
                return "0";
            }
            case 35: {
                if (dbop > dbop2) {
                    return "1";
                }
                return "0";
            }
            case 36: {
                if (dbop < dbop2) {
                    return "1";
                }
                return "0";
            }
            case 37: {
                if (dbop <= dbop2) {
                    return "1";
                }
                return "0";
            }
            case 38: {
                if (dbop >= dbop2) {
                    return "1";
                }
                return "0";
            }
            case 39: {
                if (BigDecimal.valueOf(dbop).compareTo(BigDecimal.valueOf(dbop2)) != 0) {
                    return "1";
                }
                return "0";
            }
            case 43: {
                return String.format("%f", Math.pow(dbop, dbop2));
            }
            case 44: {
                int nP = Double.valueOf(dbop).intValue();
                int nP2 = Double.valueOf(dbop2).intValue();
                return String.format("%d", nP << nP2);
            }
            case 45: {
                int nP = Double.valueOf(dbop).intValue();
                int nP2 = Double.valueOf(dbop2).intValue();
                return String.format("%d", nP >> nP2);
            }
            case 46: {
                if (StringRegularOpt.isMatch((String)str1, (String)str2)) {
                    return "1";
                }
                return "0";
            }
        }
        return null;
    }

    public String calcFormula() {
        String str;
        ArrayList<String> slOperand = new ArrayList<String>();
        OptStack optStack = new OptStack();
        block0: while (true) {
            str = this.calcItem();
            slOperand.add(0, str);
            if (str == null || str.length() == 0 || (str = this.lex.getAWord()) == null || str.length() == 0) break;
            int optID = Formula.getOptID(str);
            if (optID == -1) {
                this.lex.setPreword(str);
                break;
            }
            if (optID == 47) {
                String sInRes = "0";
                String str1Operand = StringRegularOpt.trimString((String)((String)slOperand.remove(0)));
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals("(")) {
                    return null;
                }
                ArrayList<String> slInnerOperand = new ArrayList<String>();
                do {
                    str = this.calcFormula();
                    slInnerOperand.add(str);
                    str = this.lex.getAWord();
                    if (str != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
                    return null;
                } while (!str.equals(")"));
                for (int i = 0; i < slInnerOperand.size(); ++i) {
                    str = StringRegularOpt.trimString((String)((String)slInnerOperand.get(i)));
                    if (!str1Operand.equals(str)) continue;
                    sInRes = "1";
                    break;
                }
                slOperand.add(0, sInRes);
                str = this.lex.getAWord();
                optID = Formula.getOptID(str);
                if (optID == -1) {
                    this.lex.setPreword(str);
                    break;
                }
            }
            int op = optStack.pushOpt(optID);
            while (true) {
                if (op == 0) continue block0;
                String operand2 = (String)slOperand.remove(0);
                String operand = (String)slOperand.remove(0);
                str = this.calcOperate(operand, operand2, op);
                slOperand.add(0, str);
                op = optStack.pushOpt(optID);
            }
            break;
        }
        int op = optStack.popOpt();
        while (op != 0) {
            String operand2 = (String)slOperand.remove(0);
            String operand = (String)slOperand.remove(0);
            str = this.calcOperate(operand, operand2, op);
            slOperand.add(0, str);
            op = optStack.popOpt();
        }
        return (String)slOperand.get(0);
    }

    private String calcFunc(int nFuncNo, String funcName) {
        String str = this.lex.getAWord();
        if (str == null || str.length() == 0 || !str.equals("(")) {
            if (str != null && str.length() > 0) {
                this.lex.setPreword(str);
            }
            return funcName;
        }
        int prmNo = 0;
        String sRes = "";
        if (EmbedFunc.functionsList[nFuncNo].nFuncID == 108) {
            String sCondition = this.calcFormula();
            if (sCondition == null) {
                return null;
            }
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",")) {
                return null;
            }
            if (StringRegularOpt.isTrue((String)sCondition)) {
                sRes = this.calcFormula();
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                    return null;
                }
                if (str.equals(")")) {
                    return sRes;
                }
                this.lex.skipAOperand();
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals(")")) {
                    return null;
                }
                return sRes;
            }
            this.lex.skipAOperand();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(",") && !str.equals(")")) {
                return null;
            }
            if (str.equals(")")) {
                return "";
            }
            sRes = this.calcFormula();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || !str.equals(")")) {
                return null;
            }
            return sRes;
        }
        ArrayList<String> slOperand = new ArrayList<String>();
        do {
            ++prmNo;
            str = this.calcFormula();
            slOperand.add(str);
            str = this.lex.getAWord();
            if (str != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
            return null;
        } while (!str.equals(")"));
        if (!str.equals(")")) {
            return null;
        }
        if (EmbedFunc.functionsList[nFuncNo].nPrmSum != -1 && prmNo < EmbedFunc.functionsList[nFuncNo].nPrmSum) {
            return null;
        }
        str = EmbedFunc.runFuncBaseString(slOperand, EmbedFunc.functionsList[nFuncNo].nFuncID);
        return str;
    }

    public int checkFormula(String szExpress) {
        boolean nNextType = true;
        int nBrackets = 0;
        this.lex.setFormula(szExpress);
        String sWord = this.lex.getAWord();
        while (!StringBaseOpt.isNvl((String)sWord)) {
            boolean bKW = Formula.isKeyWord(sWord);
            if (nNextType) {
                if (bKW) {
                    if ("(".equals(sWord)) {
                        ++nBrackets;
                    } else if (!sWord.equalsIgnoreCase("NOT") && !"!".equals(sWord)) {
                        return this.lex.getCurrPos() + 1;
                    }
                } else {
                    nNextType = false;
                }
            } else if (bKW) {
                if (")".equals(sWord)) {
                    --nBrackets;
                } else if ("(".equals(sWord)) {
                    ++nBrackets;
                    nNextType = true;
                } else {
                    nNextType = true;
                }
            } else {
                return this.lex.getCurrPos() + 1;
            }
            if (nBrackets < 0) {
                return this.lex.getCurrPos() + 1;
            }
            sWord = this.lex.getAWord();
        }
        if (nBrackets == 0) {
            return 0;
        }
        return this.lex.getCurrPos() + 1;
    }

    public static String calculate(String szExpress) {
        Formula formula = new Formula();
        formula.setFormula(szExpress);
        String sRes = formula.calcFormula();
        if (sRes == null || sRes.length() == 0) {
            return "";
        }
        return StringRegularOpt.trimString((String)sRes);
    }

    public static String calculate(String szExpress, Object varMap) {
        return Formula.calculate(szExpress, new ObjectTranslate(varMap));
    }

    public static String calculate(String szExpress, VariableTranslate varTrans) {
        return Formula.calculate(Pretreatment.runPretreatment(szExpress, varTrans));
    }
}

