/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.FunctionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class EmbedFunc {
    private static double MIN_DOUBLE = 1.0E-8;
    public static final int functionsSum = 53;
    protected static final FunctionInfo[] functionsList = new FunctionInfo[]{new FunctionInfo("ave", -1, 100, 1), new FunctionInfo("getat", -1, 148, 0), new FunctionInfo("byte", 2, 101, 1), new FunctionInfo("capital", 1, 102, 2), new FunctionInfo("if", 3, 108, 2), new FunctionInfo("case", 2, 116, 2), new FunctionInfo("match", 2, 111, 1), new FunctionInfo("max", -1, 103, 1), new FunctionInfo("min", -1, 104, 1), new FunctionInfo("count", -1, 112, 1), new FunctionInfo("countnotnull", -1, 145, 1), new FunctionInfo("countnull", -1, 144, 1), new FunctionInfo("round", 1, 107, 1), new FunctionInfo("concat", -1, 106, 2), new FunctionInfo("strcat", -1, 106, 2), new FunctionInfo("isempty", 1, 146, 1), new FunctionInfo("isnotempty", 1, 147, 1), new FunctionInfo("sum", -1, 105, 1), new FunctionInfo("stddev", -1, 133, 1), new FunctionInfo("log", 1, 117, 1), new FunctionInfo("ln", 1, 113, 1), new FunctionInfo("sin", 1, 118, 1), new FunctionInfo("cos", 1, 119, 1), new FunctionInfo("tan", 1, 120, 1), new FunctionInfo("ctan", 1, 121, 1), new FunctionInfo("exp", 1, 114, 1), new FunctionInfo("sqrt", 1, 115, 1), new FunctionInfo("upcase", 1, 142, 2), new FunctionInfo("lowcase", 1, 143, 2), new FunctionInfo("substr", 2, 110, 2), new FunctionInfo("lpad", 1, 150, 2), new FunctionInfo("rpad", 1, 151, 2), new FunctionInfo("find", 2, 122, 1), new FunctionInfo("frequence", 2, 123, 1), new FunctionInfo("int", 1, 124, 1), new FunctionInfo("integer", 1, 124, 1), new FunctionInfo("frac", 1, 125, 1), new FunctionInfo("today", -1, 132, 2), new FunctionInfo("currentDay", -1, 132, 2), new FunctionInfo("currentTime", -1, 149, 2), new FunctionInfo("day", -1, 126, 2), new FunctionInfo("month", -1, 127, 2), new FunctionInfo("year", -1, 128, 2), new FunctionInfo("dayspan", -1, 129, 1), new FunctionInfo("adddays", 2, 137, 2), new FunctionInfo("addmonths", 2, 138, 2), new FunctionInfo("addyears", 2, 139, 2), new FunctionInfo("truncday", -1, 140, 2), new FunctionInfo("firstofmonth", -1, 141, 2), new FunctionInfo("toDate", 1, 152, 3), new FunctionInfo("toString", 1, 153, 2), new FunctionInfo("toNumber", 1, 154, 1), new FunctionInfo("getpy", 1, 135, 2)};

    private EmbedFunc() {
        throw new IllegalAccessError("Utility class");
    }

    public static final int getFuncNo(String sFuncName) {
        for (int i = 0; i < 53; ++i) {
            if (!sFuncName.equalsIgnoreCase(EmbedFunc.functionsList[i].sName)) continue;
            return i;
        }
        return -1;
    }

    public static Object runFuncWithRaw(List<Object> rawOperand, int funcID) {
        ArrayList<Object> slOperand = new ArrayList<Object>(rawOperand.size() + 1);
        for (Object objValue : rawOperand) {
            if (objValue instanceof Object[]) {
                Object[] objs = (Object[])objValue;
                for (int i = 0; i < objs.length; ++i) {
                    slOperand.add(objs[i]);
                }
                continue;
            }
            if (objValue instanceof Collection) {
                Collection valueList = (Collection)objValue;
                slOperand.addAll(valueList);
                continue;
            }
            slOperand.add(objValue);
        }
        return EmbedFunc.runFuncWithObject(slOperand, funcID);
    }

    private static Object runFuncWithObject(List<Object> slOperand, int funcID) {
        int nOpSum = slOperand == null ? 0 : slOperand.size();
        double dbtemp = 0.0;
        switch (funcID) {
            case 100: {
                for (int i = 0; i < nOpSum; ++i) {
                    dbtemp += NumberBaseOpt.castObjectToDouble((Object)slOperand.get(i), (Double)0.0).doubleValue();
                }
                if (nOpSum > 0) {
                    return dbtemp / (double)nOpSum;
                }
                return null;
            }
            case 148: {
                int nbit;
                if (nOpSum < 2) {
                    return null;
                }
                Object objTemp = slOperand.get(0);
                if (NumberBaseOpt.isNumber((Object)objTemp) && (nbit = NumberBaseOpt.castObjectToInteger((Object)objTemp).intValue()) < nOpSum - 1) {
                    return slOperand.get(nbit + 1);
                }
                return null;
            }
            case 101: {
                if (nOpSum < 2 || !NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    return null;
                }
                Object objTemp = slOperand.get(0);
                int nbit = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                if (NumberBaseOpt.isNumber((Object)objTemp)) {
                    return String.valueOf(NumberBaseOpt.getNumByte((String)StringBaseOpt.objectToString((Object)objTemp), (int)nbit));
                }
                if (objTemp != null) {
                    String tempstr = StringBaseOpt.objectToString((Object)objTemp);
                    int sl = tempstr.length();
                    if (nbit >= 0 && nbit < sl) {
                        return String.valueOf(tempstr.charAt(nbit));
                    }
                }
                return null;
            }
            case 111: {
                if (nOpSum < 2) {
                    return false;
                }
                return StringRegularOpt.isMatch((String)StringBaseOpt.objectToString((Object)slOperand.get(0)), (String)StringBaseOpt.objectToString((Object)slOperand.get(1)));
            }
            case 102: {
                if (nOpSum < 1) {
                    return null;
                }
                boolean nT = false;
                if (nOpSum > 1) {
                    nT = BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(1));
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
                }
                return NumberBaseOpt.capitalization((String)StringBaseOpt.objectToString((Object)slOperand.get(0)), (boolean)nT);
            }
            case 103: {
                if (nOpSum < 1) {
                    return null;
                }
                return GeneralAlgorithm.maxObject(slOperand);
            }
            case 104: {
                if (nOpSum < 1) {
                    return null;
                }
                return GeneralAlgorithm.minObject(slOperand);
            }
            case 112: {
                return String.valueOf(nOpSum);
            }
            case 145: {
                if (nOpSum == 0) {
                    return 0;
                }
                int nc = 0;
                for (Object obj : slOperand) {
                    String s;
                    if (obj == null || !StringUtils.isNotBlank((CharSequence)(s = StringBaseOpt.objectToString((Object)obj))) || "''".equals(s) || "\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 144: {
                if (nOpSum == 0) {
                    return 0;
                }
                int nc = 0;
                for (Object obj : slOperand) {
                    if (obj == null) {
                        ++nc;
                        continue;
                    }
                    String s = StringBaseOpt.objectToString((Object)obj);
                    if (!StringUtils.isBlank((CharSequence)s) && !"''".equals(s) && !"\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 105: {
                if (nOpSum < 1) {
                    return null;
                }
                return GeneralAlgorithm.sumObjects(slOperand);
            }
            case 133: {
                if (nOpSum < 2) {
                    return 0;
                }
                int numberSum = 0;
                for (int i = 0; i < nOpSum; ++i) {
                    if (!NumberBaseOpt.isNumber((Object)slOperand.get(i))) continue;
                    ++numberSum;
                    dbtemp += NumberBaseOpt.castObjectToDouble((Object)slOperand.get(i), (Double)0.0).doubleValue();
                }
                double dbAvg = dbtemp / (double)numberSum;
                dbtemp = 0.0;
                for (int i = 0; i < nOpSum; ++i) {
                    if (!NumberBaseOpt.isNumber((Object)slOperand.get(i))) continue;
                    double dtp = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(i), (Double)0.0) - dbAvg;
                    dbtemp += dtp * dtp;
                }
                return Math.sqrt(dbtemp / (double)(numberSum - 1));
            }
            case 106: {
                if (nOpSum < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nOpSum; ++i) {
                    sb.append(StringBaseOpt.castObjectToString((Object)slOperand.get(i), (String)""));
                }
                return sb.toString();
            }
            case 110: {
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                if (slOperand.get(0) == null) {
                    return null;
                }
                int nStart = 0;
                if (NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    nStart = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                int nLength = nOpSum > 2 && NumberBaseOpt.isNumber((Object)slOperand.get(2)) ? NumberBaseOpt.castObjectToInteger((Object)slOperand.get(2)).intValue() : tempStr.length();
                if (nLength <= 0) {
                    nLength = 1;
                }
                return tempStr.substring(nStart, nStart + nLength);
            }
            case 150: {
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString((Object)slOperand.get(2));
                    return StringUtils.leftPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.leftPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength);
            }
            case 151: {
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString((Object)slOperand.get(2));
                    return StringUtils.rightPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.rightPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength);
            }
            case 122: {
                if (nOpSum < 2) {
                    return -1;
                }
                int nStart = 0;
                if (nOpSum > 2 && NumberBaseOpt.isNumber((Object)slOperand.get(2))) {
                    nStart = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(2));
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                return tempStr.indexOf(StringBaseOpt.objectToString((Object)slOperand.get(1)), nStart);
            }
            case 142: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 143: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.lowerCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 123: {
                if (nOpSum < 2) {
                    return -1;
                }
                if (slOperand.get(0) == null || slOperand.get(1) == null) {
                    return 0;
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                String str = StringBaseOpt.objectToString((Object)slOperand.get(1));
                int nSt = 0;
                int sl = str.length();
                int nC = 0;
                if (sl == 0) {
                    return 0;
                }
                nSt = tempStr.indexOf(str, nSt);
                while (nSt >= 0) {
                    ++nC;
                    nSt += sl;
                    nSt = tempStr.indexOf(str, nSt);
                }
                return nC;
            }
            case 124: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                return NumberBaseOpt.castObjectToInteger((Object)slOperand.get(0));
            }
            case 107: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0)) + 0.5;
                return tempDouble.intValue();
            }
            case 146: {
                if (nOpSum < 1 || slOperand.get(0) == null) {
                    return true;
                }
                return StringUtils.isBlank((CharSequence)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 147: {
                if (nOpSum < 1 || slOperand.get(0) == null) {
                    return false;
                }
                return StringUtils.isNotBlank((CharSequence)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 113: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.log(af);
            }
            case 117: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.log10(af);
            }
            case 118: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.sin(af);
            }
            case 119: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.cos(af);
            }
            case 120: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.tan(af);
            }
            case 121: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.atan(af);
            }
            case 125: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                Double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return af - (double)af.intValue();
            }
            case 114: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.exp(af);
            }
            case 115: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.sqrt(af);
            }
            case 108: {
                if (nOpSum < 2) {
                    return null;
                }
                if (BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(0)).booleanValue()) {
                    return slOperand.get(1);
                }
                if (nOpSum > 2) {
                    return slOperand.get(2);
                }
                return null;
            }
            case 116: {
                if (nOpSum < 2) {
                    return null;
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                int MatchType = 0;
                if (tempStr.equalsIgnoreCase("true")) {
                    MatchType = 1;
                } else if (NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    dbtemp = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                    MatchType = 2;
                }
                int i = 1;
                while (i + 1 < nOpSum) {
                    if (MatchType == 1 ? BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(i)) != false : (MatchType == 2 ? NumberBaseOpt.isNumber((Object)slOperand.get(i)) && Math.abs(dbtemp - NumberBaseOpt.castObjectToDouble((Object)slOperand.get(i))) < MIN_DOUBLE : tempStr.equals(StringBaseOpt.objectToString((Object)slOperand.get(i))))) {
                        return slOperand.get(i + 1);
                    }
                    i += 2;
                }
                if (nOpSum % 2 == 0) {
                    return slOperand.get(nOpSum - 1);
                }
                return null;
            }
            case 132: {
                return DatetimeOpt.currentUtilDate();
            }
            case 149: {
                return DatetimeOpt.currentSqlTimeStamp();
            }
            case 126: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : DatetimeOpt.currentUtilDate();
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getDay((Date)dt);
            }
            case 127: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getMonth((Date)dt);
            }
            case 128: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getYear((Date)dt);
            }
            case 129: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                Date dt2 = DatetimeOpt.castObjectToDate((Object)slOperand.get(1));
                if (dt == null || dt2 == null) {
                    return null;
                }
                return DatetimeOpt.calcSpanDays((Date)dt, (Date)dt2);
            }
            case 137: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                if (dt == null) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                return DatetimeOpt.addDays((Date)dt, (int)ti);
            }
            case 138: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                if (dt == null) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                return DatetimeOpt.addMonths((Date)dt, (int)ti);
            }
            case 139: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                if (dt == null) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                return DatetimeOpt.addYears((Date)dt, (int)ti);
            }
            case 140: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                if (nOpSum < 2) {
                    return DatetimeOpt.truncateToDay((Date)dt);
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(1));
                if ("M".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToMonth((Date)dt);
                }
                if ("Y".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToYear((Date)dt);
                }
                return DatetimeOpt.truncateToDay((Date)dt);
            }
            case 141: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.truncateToMonth((Date)dt);
            }
            case 152: {
                Object dt;
                Object object = dt = nOpSum > 0 ? slOperand.get(0) : null;
                if (dt == null) {
                    return DatetimeOpt.currentUtilDate();
                }
                if (nOpSum > 1) {
                    return DatetimeOpt.convertStringToDate((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (String)StringBaseOpt.castObjectToString((Object)slOperand.get(1)));
                }
                return DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
            }
            case 153: {
                return nOpSum > 0 ? StringBaseOpt.castObjectToString((Object)slOperand.get(0)) : null;
            }
            case 154: {
                return nOpSum > 0 ? (Number)NumberBaseOpt.castObjectToNumber((Object)slOperand.get(0)) : (Number)null;
            }
            case 135: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringBaseOpt.getFirstLetter((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
        }
        return null;
    }
}

