/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.FunctionInfo;
import java.util.Date;
import java.util.List;

public class EmbedFunc {
    public static final int functionsSum = 46;
    protected static final FunctionInfo[] functionsList = new FunctionInfo[]{new FunctionInfo("ave", -1, 100, 1), new FunctionInfo("getat", -1, 148, 0), new FunctionInfo("byte", 2, 101, 1), new FunctionInfo("capital", 1, 102, 2), new FunctionInfo("if", 3, 108, 2), new FunctionInfo("case", 2, 116, 2), new FunctionInfo("match", 2, 111, 1), new FunctionInfo("max", -1, 103, 1), new FunctionInfo("min", -1, 104, 1), new FunctionInfo("count", -1, 112, 1), new FunctionInfo("countnotnull", -1, 145, 1), new FunctionInfo("countnull", -1, 144, 1), new FunctionInfo("round", 1, 107, 1), new FunctionInfo("concat", -1, 106, 2), new FunctionInfo("strcat", -1, 106, 2), new FunctionInfo("isempty", 1, 146, 1), new FunctionInfo("isnotempty", 1, 147, 1), new FunctionInfo("sum", -1, 105, 1), new FunctionInfo("stddev", -1, 133, 1), new FunctionInfo("log", 1, 117, 1), new FunctionInfo("ln", 1, 113, 1), new FunctionInfo("sin", 1, 118, 1), new FunctionInfo("cos", 1, 119, 1), new FunctionInfo("tan", 1, 120, 1), new FunctionInfo("ctan", 1, 121, 1), new FunctionInfo("exp", 1, 114, 1), new FunctionInfo("sqrt", 1, 115, 1), new FunctionInfo("upcase", 1, 142, 2), new FunctionInfo("lowcase", 1, 143, 2), new FunctionInfo("substr", 2, 110, 2), new FunctionInfo("find", 2, 122, 1), new FunctionInfo("frequence", 2, 123, 1), new FunctionInfo("int", 1, 124, 1), new FunctionInfo("integer", 1, 124, 1), new FunctionInfo("frac", 1, 125, 1), new FunctionInfo("today", -1, 132, 2), new FunctionInfo("day", -1, 126, 2), new FunctionInfo("month", -1, 127, 2), new FunctionInfo("year", -1, 128, 2), new FunctionInfo("dayspan", -1, 129, 1), new FunctionInfo("adddays", 2, 137, 2), new FunctionInfo("addmonths", 2, 138, 2), new FunctionInfo("addyears", 2, 139, 2), new FunctionInfo("truncday", -1, 140, 2), new FunctionInfo("firstofmonth", -1, 141, 2), new FunctionInfo("getpy", 1, 135, 2)};

    public static final int getFuncNo(String sFuncName) {
        for (int i = 0; i < 46; ++i) {
            if (!sFuncName.equalsIgnoreCase(EmbedFunc.functionsList[i].sName)) continue;
            return i;
        }
        return -1;
    }

    public static final String runFunc(List<String> slOperand, int funcID) {
        int nOpSum = 0;
        if (slOperand != null) {
            nOpSum = slOperand.size();
        }
        String str = "";
        double dbtemp = 0.0;
        switch (funcID) {
            case 100: {
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.isNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(i))).doubleValue();
                }
                str = nOpSum > 0 ? String.format("%f", dbtemp / (double)nOpSum) : "0";
                return str;
            }
            case 148: {
                int nbit;
                if (nOpSum < 2) {
                    return "";
                }
                String tempstr = slOperand.get(0);
                if (StringRegularOpt.isNumber((String)tempstr) && (nbit = Integer.valueOf(tempstr).intValue()) < nOpSum - 1) {
                    return slOperand.get(nbit + 1);
                }
                return "";
            }
            case 101: {
                if (nOpSum < 2 || !StringRegularOpt.isNumber((String)slOperand.get(1))) {
                    return "";
                }
                String tempstr = slOperand.get(0);
                int nbit = Integer.valueOf(slOperand.get(1));
                if (StringRegularOpt.isNumber((String)tempstr)) {
                    str = String.valueOf(NumberBaseOpt.getNumByte((String)tempstr, (int)nbit));
                } else {
                    int sl = tempstr.length();
                    str = nbit >= 0 && nbit < sl ? String.valueOf(tempstr.charAt(nbit)) : "";
                }
                return str;
            }
            case 111: {
                if (nOpSum < 2) {
                    return "0";
                }
                if (StringRegularOpt.isMatch((String)slOperand.get(0), (String)slOperand.get(1))) {
                    return "1";
                }
                return "0";
            }
            case 102: {
                if (nOpSum < 1) {
                    return "";
                }
                boolean nT = false;
                if (nOpSum > 1) {
                    nT = StringRegularOpt.isTrue((String)slOperand.get(1));
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                str = NumberBaseOpt.capitalization((String)slOperand.get(0), (boolean)nT);
                return str;
            }
            case 103: {
                if (nOpSum < 1) {
                    return "";
                }
                List trimOperand = ListOpt.removeNullItem(slOperand);
                if (trimOperand == null || trimOperand.size() < 1) {
                    return "";
                }
                boolean hasNotNumber = false;
                dbtemp = -1.0;
                if (StringRegularOpt.isNumber((String)((String)trimOperand.get(0)))) {
                    dbtemp = Double.valueOf(StringRegularOpt.trimString((String)((String)trimOperand.get(0))));
                } else {
                    hasNotNumber = true;
                }
                for (int i = 1; i < trimOperand.size(); ++i) {
                    if (StringRegularOpt.isNumber((String)((String)trimOperand.get(i)))) {
                        double tMidF = Double.valueOf(StringRegularOpt.trimString((String)((String)trimOperand.get(i))));
                        if (!(dbtemp < tMidF)) continue;
                        dbtemp = tMidF;
                        continue;
                    }
                    hasNotNumber = true;
                }
                if (!hasNotNumber) {
                    return String.valueOf(dbtemp);
                }
                String strRet = (String)trimOperand.get(0);
                for (int i = 1; i < trimOperand.size(); ++i) {
                    if (strRet.compareTo((String)trimOperand.get(i)) >= 0) continue;
                    strRet = (String)trimOperand.get(i);
                }
                return strRet;
            }
            case 104: {
                if (nOpSum < 1) {
                    return "";
                }
                List trimOperand = ListOpt.removeNullItem(slOperand);
                if (trimOperand == null || trimOperand.size() < 1) {
                    return "";
                }
                dbtemp = -1.0;
                boolean hasNotNumber = false;
                if (StringRegularOpt.isNumber((String)((String)trimOperand.get(0)))) {
                    dbtemp = Double.valueOf(StringRegularOpt.trimString((String)((String)trimOperand.get(0))));
                } else {
                    hasNotNumber = true;
                }
                for (int i = 1; i < trimOperand.size(); ++i) {
                    if (StringRegularOpt.isNumber((String)((String)trimOperand.get(i)))) {
                        double tMidF = Double.valueOf(StringRegularOpt.trimString((String)((String)trimOperand.get(i))));
                        if (!(dbtemp > tMidF)) continue;
                        dbtemp = tMidF;
                        continue;
                    }
                    hasNotNumber = true;
                }
                if (!hasNotNumber) {
                    return String.valueOf(dbtemp);
                }
                String strRet = (String)trimOperand.get(0);
                for (int i = 1; i < trimOperand.size(); ++i) {
                    if (strRet.compareTo((String)trimOperand.get(i)) <= 0) continue;
                    strRet = (String)trimOperand.get(i);
                }
                return strRet;
            }
            case 112: {
                return String.valueOf(nOpSum);
            }
            case 145: {
                if (nOpSum == 0) {
                    return "0";
                }
                int nc = 0;
                for (String s : slOperand) {
                    if (s == null || s.length() <= 0 || "''".equals(s) || "\"\"".equals(s)) continue;
                    ++nc;
                }
                return String.valueOf(nc);
            }
            case 144: {
                if (nOpSum == 0) {
                    return "0";
                }
                int nc = 0;
                for (String s : slOperand) {
                    if (s != null && s.length() != 0 && !"''".equals(s) && !"\"\"".equals(s)) continue;
                    ++nc;
                }
                return String.valueOf(nc);
            }
            case 105: {
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.isNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(i))).doubleValue();
                }
                return String.valueOf(dbtemp);
            }
            case 133: {
                if (nOpSum < 2) {
                    return "0";
                }
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.isNumber((String)slOperand.get(i))) continue;
                    dbtemp += Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(i))).doubleValue();
                }
                double dbAvg = dbtemp / (double)nOpSum;
                dbtemp = 0.0;
                for (int i = 0; i < nOpSum; ++i) {
                    if (!StringRegularOpt.isNumber((String)slOperand.get(i))) continue;
                    double dtp = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(i))) - dbAvg;
                    dbtemp += dtp * dtp;
                }
                dbtemp = Math.sqrt(dbtemp / (double)(nOpSum - 1));
                str = String.format("%f", dbtemp);
                return str;
            }
            case 106: {
                if (nOpSum < 1) {
                    return "";
                }
                StringBuilder sb = new StringBuilder("\"");
                for (int i = 0; i < nOpSum; ++i) {
                    sb.append(StringRegularOpt.trimString((String)slOperand.get(i)));
                }
                sb.append('\"');
                return sb.toString();
            }
            case 110: {
                int nLength;
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                if (slOperand.get(0) == null) {
                    return "";
                }
                int nStart = 0;
                if (StringRegularOpt.isNumber((String)slOperand.get(1))) {
                    nStart = Integer.valueOf(StringRegularOpt.trimString((String)slOperand.get(1)));
                }
                if ((nLength = nOpSum > 2 && StringRegularOpt.isNumber((String)slOperand.get(2)) ? Integer.valueOf(StringRegularOpt.trimString((String)slOperand.get(2))).intValue() : slOperand.get(0).length()) <= 0) {
                    nLength = 1;
                }
                String tempstr = slOperand.get(0).substring(nStart, nStart + nLength);
                str = '\"' + tempstr + '\"';
                return str;
            }
            case 122: {
                if (nOpSum < 2) {
                    return "-1";
                }
                int nStart = 0;
                if (nOpSum > 2 && StringRegularOpt.isNumber((String)slOperand.get(2))) {
                    nStart = Integer.valueOf(StringRegularOpt.trimString((String)slOperand.get(2)));
                }
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                str = StringRegularOpt.trimString((String)slOperand.get(1));
                int nS = tempstr.indexOf(str, nStart);
                return String.format("%d", nS);
            }
            case 142: {
                if (nOpSum < 1) {
                    return "";
                }
                return slOperand.get(0).toUpperCase();
            }
            case 143: {
                if (nOpSum < 1) {
                    return "";
                }
                return slOperand.get(0).toLowerCase();
            }
            case 123: {
                if (nOpSum < 2) {
                    return "-1";
                }
                if (slOperand.get(0) == null) {
                    return "0";
                }
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                str = StringRegularOpt.trimString((String)slOperand.get(1));
                int nSt = 0;
                int sl = str.length();
                int nC = 0;
                nSt = tempstr.indexOf(str, nSt);
                while (nSt >= 0) {
                    ++nC;
                    nSt += sl;
                    nSt = tempstr.indexOf(str, nSt);
                }
                return String.valueOf(nC);
            }
            case 107: {
                if (nOpSum < 1) {
                    return "";
                }
                if (StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                int nS = 0;
                if (nOpSum > 1 && StringRegularOpt.isNumber((String)slOperand.get(1))) {
                    nS = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(1))).intValue();
                }
                if (nS < 0) {
                    nS = 0;
                }
                return String.format("%." + String.valueOf(nS) + "f", slOperand.get(1));
            }
            case 146: {
                if (nOpSum < 1) {
                    return "1";
                }
                if (StringBaseOpt.isNvl((String)slOperand.get(0)) || "''".equals(slOperand.get(0)) || "\"\"".equals(slOperand.get(0))) {
                    return "1";
                }
                return "0";
            }
            case 147: {
                if (nOpSum < 1) {
                    return "0";
                }
                if (StringBaseOpt.isNvl((String)slOperand.get(0)) || "''".equals(slOperand.get(0)) || "\"\"".equals(slOperand.get(0))) {
                    return "0";
                }
                return "1";
            }
            case 113: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.log(af);
                return String.valueOf(af);
            }
            case 117: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.log10(af);
                return String.valueOf(af);
            }
            case 118: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.sin(af);
                return String.valueOf(af);
            }
            case 119: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.cos(af);
                return String.valueOf(af);
            }
            case 120: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.tan(af);
                return String.valueOf(af);
            }
            case 121: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.atan(af);
                return String.valueOf(af);
            }
            case 124: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                int nN = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0))).intValue();
                return String.valueOf(nN);
            }
            case 125: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                int nN = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0))).intValue();
                return String.valueOf(af - (double)nN);
            }
            case 114: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.exp(af);
                return String.valueOf(af);
            }
            case 115: {
                if (nOpSum < 1) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)slOperand.get(0))) {
                    return "";
                }
                double af = Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(0)));
                af = Math.sqrt(af);
                return String.valueOf(af);
            }
            case 108: {
                if (nOpSum < 2) {
                    return "";
                }
                String str1 = "";
                if (nOpSum > 2) {
                    str1 = slOperand.get(2);
                }
                if (StringRegularOpt.isTrue((String)slOperand.get(0))) {
                    return slOperand.get(1);
                }
                return str1;
            }
            case 116: {
                if (nOpSum < 2) {
                    return "";
                }
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                int MatchType = 0;
                if (tempstr.equalsIgnoreCase("true")) {
                    MatchType = 1;
                } else if (StringRegularOpt.isNumber((String)tempstr)) {
                    dbtemp = Double.valueOf(tempstr);
                    MatchType = 2;
                }
                int i = 1;
                while (i + 1 < nOpSum) {
                    if (MatchType == 1 ? StringRegularOpt.isTrue((String)slOperand.get(i)) : (MatchType == 2 ? StringRegularOpt.isNumber((String)slOperand.get(i)) && Math.abs(dbtemp - Double.valueOf(StringRegularOpt.trimString((String)slOperand.get(i)))) < 1.0E-4 : tempstr.equals(StringRegularOpt.trimString((String)slOperand.get(i))))) {
                        return slOperand.get(i + 1);
                    }
                    i += 2;
                }
                if (nOpSum % 2 == 0) {
                    return slOperand.get(nOpSum - 1);
                }
                return "";
            }
            case 132: {
                return DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate());
            }
            case 126: {
                Date dt = null;
                if (nOpSum > 0) {
                    String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                    dt = DatetimeOpt.smartPraseDate((String)tempstr);
                }
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return String.valueOf(DatetimeOpt.getDay((Date)dt));
            }
            case 127: {
                Date dt = null;
                if (nOpSum > 0) {
                    String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                    dt = DatetimeOpt.smartPraseDate((String)tempstr);
                }
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return String.valueOf(DatetimeOpt.getMonth((Date)dt));
            }
            case 128: {
                Date dt = null;
                if (nOpSum > 0) {
                    String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                    dt = DatetimeOpt.smartPraseDate((String)tempstr);
                }
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return String.valueOf(DatetimeOpt.getYear((Date)dt));
            }
            case 129: {
                if (nOpSum < 2) {
                    return "";
                }
                str = StringRegularOpt.trimString((String)slOperand.get(0));
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(1));
                Date dt = DatetimeOpt.smartPraseDate((String)str);
                Date dt2 = DatetimeOpt.smartPraseDate((String)tempstr);
                if (dt == null || dt2 == null) {
                    return "";
                }
                return String.valueOf(DatetimeOpt.calcSpanDays((Date)dt, (Date)dt2));
            }
            case 137: {
                if (nOpSum < 2) {
                    return "";
                }
                str = StringRegularOpt.trimString((String)slOperand.get(0));
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(1));
                Date dt = DatetimeOpt.smartPraseDate((String)str);
                if (dt == null) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)tempstr)) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = Double.valueOf(StringRegularOpt.trimString((String)tempstr)).intValue();
                return DatetimeOpt.convertDateToString((Date)DatetimeOpt.addDays((Date)dt, (int)ti));
            }
            case 138: {
                if (nOpSum < 2) {
                    return "";
                }
                str = StringRegularOpt.trimString((String)slOperand.get(0));
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(1));
                Date dt = DatetimeOpt.smartPraseDate((String)str);
                if (dt == null) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)tempstr)) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = Double.valueOf(tempstr).intValue();
                return DatetimeOpt.convertDateToString((Date)DatetimeOpt.addMonths((Date)dt, (int)ti));
            }
            case 139: {
                if (nOpSum < 2) {
                    return "";
                }
                str = StringRegularOpt.trimString((String)slOperand.get(0));
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(1));
                Date dt = DatetimeOpt.smartPraseDate((String)str);
                if (dt == null) {
                    return "";
                }
                if (!StringRegularOpt.isNumber((String)tempstr)) {
                    return DatetimeOpt.convertDateToString((Date)dt);
                }
                int ti = Double.valueOf(tempstr).intValue();
                return DatetimeOpt.convertDateToString((Date)DatetimeOpt.addYears((Date)dt, (int)ti));
            }
            case 140: {
                if (nOpSum < 1) {
                    return "";
                }
                str = StringRegularOpt.trimString((String)slOperand.get(0));
                Date dt = DatetimeOpt.smartPraseDate((String)str);
                if (dt == null) {
                    return "";
                }
                String tempstr = "D";
                if (nOpSum > 1) {
                    tempstr = StringRegularOpt.trimString((String)slOperand.get(1));
                }
                dt = "M".equalsIgnoreCase(tempstr) ? DatetimeOpt.truncateToMonth((Date)dt) : ("Y".equalsIgnoreCase(tempstr) ? DatetimeOpt.truncateToYear((Date)dt) : DatetimeOpt.truncateToDay((Date)dt));
                return DatetimeOpt.convertDateToString((Date)dt);
            }
            case 141: {
                Date dt = null;
                if (nOpSum > 0) {
                    String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                    dt = DatetimeOpt.smartPraseDate((String)tempstr);
                }
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                dt = DatetimeOpt.truncateToMonth((Date)dt);
                return DatetimeOpt.convertDateToString((Date)dt);
            }
            case 135: {
                if (nOpSum < 1) {
                    return "";
                }
                String tempstr = StringRegularOpt.trimString((String)slOperand.get(0));
                return StringBaseOpt.getFirstLetter((String)tempstr);
            }
        }
        return "";
    }
}

