/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.VariableTranslate;
import java.util.Collection;
import java.util.Date;

public class ObjectTranslate
implements VariableTranslate {
    private Object varObj;

    public ObjectTranslate() {
        this.varObj = null;
    }

    public ObjectTranslate(Object varObj) {
        this.varObj = varObj;
    }

    @Override
    public String getVarValue(String varName) {
        if (this.varObj == null) {
            return "\"\"";
        }
        Object obj = ReflectionOpt.attainExpressionValue((Object)this.varObj, (String)varName);
        if (obj == null) {
            return "\"\"";
        }
        return ObjectTranslate.objectToFormulaString(obj);
    }

    public static String objectToFormulaString(Object objValue) {
        if (objValue == null) {
            return "\"\"";
        }
        if (objValue instanceof Object[]) {
            Object[] objs = (Object[])objValue;
            if (objs.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < objs.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    if (objs[i] == null) continue;
                    if (ReflectionOpt.isNumberType(objs[i].getClass())) {
                        sb.append(objs[i].toString());
                        continue;
                    }
                    if (objs[i] instanceof Date) {
                        sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)objs[i]))));
                        continue;
                    }
                    if (objs[i] instanceof java.sql.Date) {
                        sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.convertUtilDate((java.sql.Date)((java.sql.Date)objs[i])))));
                        continue;
                    }
                    sb.append(StringRegularOpt.quotedString((String)objs[i].toString()));
                }
                return sb.toString();
            }
            return "\"\"";
        }
        if (objValue instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int vc = 0;
            Collection valueList = (Collection)objValue;
            for (Object ov : valueList) {
                if (ov == null) continue;
                if (vc > 0) {
                    sb.append(",");
                }
                if (ReflectionOpt.isNumberType(ov.getClass())) {
                    sb.append(ov.toString());
                } else if (ov instanceof Date) {
                    sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)ov))));
                } else if (ov instanceof java.sql.Date) {
                    sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.convertUtilDate((java.sql.Date)((java.sql.Date)ov)))));
                } else {
                    sb.append(StringRegularOpt.quotedString((String)ov.toString()));
                }
                ++vc;
            }
            if (vc == 0) {
                return "\"\"";
            }
            return sb.toString();
        }
        if (objValue instanceof Date) {
            return StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)objValue)));
        }
        if (objValue instanceof java.sql.Date) {
            return StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)DatetimeOpt.convertUtilDate((java.sql.Date)((java.sql.Date)objValue))));
        }
        return StringRegularOpt.quotedString((String)objValue.toString());
    }

    @Override
    public String getLabelValue(String labelName) {
        return this.getVarValue(labelName);
    }

    public void setVarObject(Object varObj) {
        this.varObj = varObj;
    }
}

