/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.FunctionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class EmbedFunc {
    public static final int functionsSum = 66;
    protected static final FunctionInfo[] functionsList = new FunctionInfo[]{new FunctionInfo("getat", -1, 148, 0), new FunctionInfo("byte", 2, 101, 1), new FunctionInfo("capital", 1, 102, 2), new FunctionInfo("if", 3, 108, 0), new FunctionInfo("case", 2, 116, 0), new FunctionInfo("match", 2, 111, 1), new FunctionInfo("regexmatch", 2, 159, 1), new FunctionInfo("regexmatchvalue", 2, 160, 0), new FunctionInfo("max", -1, 103, 0), new FunctionInfo("min", -1, 104, 0), new FunctionInfo("ave", -1, 100, 1), new FunctionInfo("count", -1, 112, 1), new FunctionInfo("countnotnull", -1, 145, 1), new FunctionInfo("countnull", -1, 144, 1), new FunctionInfo("sum", -1, 105, 1), new FunctionInfo("stddev", -1, 133, 1), new FunctionInfo("round", -1, 107, 1), new FunctionInfo("floor", -1, 165, 1), new FunctionInfo("ceil", -1, 166, 1), new FunctionInfo("concat", -1, 106, 2), new FunctionInfo("strcat", -1, 106, 2), new FunctionInfo("isempty", 1, 146, 1), new FunctionInfo("isnotempty", 1, 147, 1), new FunctionInfo("log", 1, 117, 1), new FunctionInfo("ln", 1, 113, 1), new FunctionInfo("sin", 1, 118, 1), new FunctionInfo("cos", 1, 119, 1), new FunctionInfo("tan", 1, 120, 1), new FunctionInfo("ctan", 1, 121, 1), new FunctionInfo("exp", 1, 114, 1), new FunctionInfo("sqrt", 1, 115, 1), new FunctionInfo("upcase", 1, 142, 2), new FunctionInfo("lowcase", 1, 143, 2), new FunctionInfo("substr", 2, 110, 2), new FunctionInfo("lpad", 1, 150, 2), new FunctionInfo("rpad", 1, 151, 2), new FunctionInfo("find", 2, 122, 1), new FunctionInfo("frequence", 2, 123, 1), new FunctionInfo("split", 2, 167, 2), new FunctionInfo("int", 1, 124, 1), new FunctionInfo("integer", 1, 124, 1), new FunctionInfo("frac", 1, 125, 1), new FunctionInfo("today", -1, 149, 3), new FunctionInfo("currentDate", -1, 132, 3), new FunctionInfo("currentDatetime", -1, 149, 3), new FunctionInfo("currentTimestamp", -1, 155, 3), new FunctionInfo("day", -1, 126, 2), new FunctionInfo("month", -1, 127, 2), new FunctionInfo("year", -1, 128, 2), new FunctionInfo("week", -1, 161, 2), new FunctionInfo("weekday", -1, 162, 2), new FunctionInfo("formatdate", -1, 163, 2), new FunctionInfo("dateinfo", -1, 164, 2), new FunctionInfo("dayspan", -1, 129, 1), new FunctionInfo("datespan", -1, 157, 1), new FunctionInfo("adddate", 2, 158, 0), new FunctionInfo("adddays", 2, 137, 0), new FunctionInfo("addmonths", 2, 138, 0), new FunctionInfo("addyears", 2, 139, 0), new FunctionInfo("truncdate", -1, 140, 0), new FunctionInfo("lastofmonth", -1, 141, 0), new FunctionInfo("toDate", 1, 152, 3), new FunctionInfo("toString", 1, 153, 2), new FunctionInfo("toNumber", 1, 154, 1), new FunctionInfo("singleton", -1, 156, 0), new FunctionInfo("getpy", 1, 135, 2)};
    private static double COMPARE_MIN_DOUBLE = 1.0E-7;

    private EmbedFunc() {
        throw new IllegalAccessError("Utility class");
    }

    public static int getFuncNo(String sFuncName) {
        for (int i = 0; i < 66; ++i) {
            if (!sFuncName.equalsIgnoreCase(EmbedFunc.functionsList[i].sName)) continue;
            return i;
        }
        return -1;
    }

    private static LeftRightPair<Integer, List<Object>> flatOperands(List<Object> slOperand) {
        int nCount = 0;
        ArrayList<Object> ret = new ArrayList<Object>();
        if (slOperand != null && slOperand.size() > 0) {
            for (Object obj : slOperand) {
                if (obj instanceof Object[]) {
                    Object[] objs;
                    for (Object obj1 : objs = (Object[])obj) {
                        ret.add(obj1);
                        ++nCount;
                    }
                    continue;
                }
                if (obj instanceof Collection) {
                    ret.addAll((Collection)obj);
                    nCount += ((Collection)obj).size();
                    continue;
                }
                ret.add(obj);
                ++nCount;
            }
        }
        return new LeftRightPair((Object)nCount, ret);
    }

    private static LeftRightPair<Date, Object> fetchDateOpt(int nOpSum, List<Object> slOperand) {
        Date dt = null;
        Object ti = null;
        if (nOpSum == 1) {
            dt = DatetimeOpt.currentUtilDate();
            if (NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                ti = slOperand.get(0);
            }
        } else if (nOpSum > 1) {
            dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
            if (NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                ti = slOperand.get(1);
            }
        }
        return new LeftRightPair((Object)dt, ti);
    }

    public static Object runFuncWithObject(List<Object> slOperand, int funcID) {
        int nOpSum = slOperand == null ? 0 : slOperand.size();
        double dbtemp = 0.0;
        switch (funcID) {
            case 100: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                nOpSum = 0;
                for (int i = 0; i < (Integer)opt.getLeft(); ++i) {
                    Double db = NumberBaseOpt.castObjectToDouble(((List)opt.getRight()).get(i));
                    if (db == null) continue;
                    dbtemp += db.doubleValue();
                    ++nOpSum;
                }
                if (nOpSum > 0) {
                    return dbtemp / (double)nOpSum;
                }
                return null;
            }
            case 156: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                ArrayList retObjs = new ArrayList();
                for (Object obj : (List)opt.getRight()) {
                    if (obj == null || retObjs.contains(obj)) continue;
                    retObjs.add(obj);
                }
                return retObjs;
            }
            case 148: {
                Integer nbit;
                if (nOpSum < 2) {
                    return null;
                }
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                Object objTemp = slOperand.get(0);
                if (NumberBaseOpt.isNumber((Object)objTemp) && (nbit = NumberBaseOpt.castObjectToInteger((Object)objTemp)) != null) {
                    if (nbit < 0) {
                        nbit = (Integer)opt.getLeft() - 1 + nbit;
                    }
                    if (nbit >= 0 && nbit < (Integer)opt.getLeft() - 1) {
                        return ((List)opt.getRight()).get(nbit + 1);
                    }
                }
                return null;
            }
            case 101: {
                if (nOpSum < 2 || !NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    return null;
                }
                Object objTemp = slOperand.get(0);
                int nbit = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                if (NumberBaseOpt.isNumber((Object)objTemp)) {
                    return String.valueOf(NumberBaseOpt.getNumByte((String)StringBaseOpt.objectToString((Object)objTemp), (int)nbit));
                }
                if (objTemp != null) {
                    String tempstr = StringBaseOpt.objectToString((Object)objTemp);
                    int sl = tempstr.length();
                    if (nbit >= 0 && nbit < sl) {
                        return String.valueOf(tempstr.charAt(nbit));
                    }
                }
                return null;
            }
            case 111: {
                if (nOpSum < 2) {
                    return false;
                }
                return StringRegularOpt.isMatch((String)StringBaseOpt.objectToString((Object)slOperand.get(0)), (String)StringBaseOpt.objectToString((Object)slOperand.get(1)));
            }
            case 159: {
                if (nOpSum < 2) {
                    return false;
                }
                return Pattern.matches(StringBaseOpt.objectToString((Object)slOperand.get(0)), StringBaseOpt.objectToString((Object)slOperand.get(1)));
            }
            case 160: {
                if (nOpSum < 2) {
                    return false;
                }
                String sValues = StringBaseOpt.objectToString((Object)slOperand.get(1));
                Pattern p = Pattern.compile(StringBaseOpt.objectToString((Object)slOperand.get(0)));
                Matcher m = p.matcher(sValues);
                ArrayList<String> matchValues = new ArrayList<String>();
                while (m.find()) {
                    matchValues.add(sValues.substring(m.start(), m.end()));
                }
                return matchValues;
            }
            case 102: {
                if (nOpSum < 1) {
                    return null;
                }
                boolean nT = false;
                if (nOpSum > 1) {
                    nT = BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(1), (Boolean)false);
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
                }
                return NumberBaseOpt.capitalization((String)StringBaseOpt.objectToString((Object)slOperand.get(0)), (boolean)nT);
            }
            case 103: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.maxObject((Collection)((Collection)opt.getRight()));
            }
            case 104: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.minObject((Collection)((Collection)opt.getRight()));
            }
            case 112: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return opt.getLeft();
            }
            case 145: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                int nc = 0;
                for (Object obj : (List)opt.getRight()) {
                    String s;
                    if (obj == null || !StringUtils.isNotBlank((CharSequence)(s = StringBaseOpt.objectToString(obj))) || "''".equals(s) || "\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 144: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                int nc = 0;
                for (Object obj : (List)opt.getRight()) {
                    if (obj == null) {
                        ++nc;
                        continue;
                    }
                    String s = StringBaseOpt.objectToString(obj);
                    if (!StringUtils.isBlank((CharSequence)s) && !"''".equals(s) && !"\"\"".equals(s)) continue;
                    ++nc;
                }
                return nc;
            }
            case 105: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                return GeneralAlgorithm.sumObjects((Collection)((Collection)opt.getRight()));
            }
            case 133: {
                LeftRightPair<Integer, List<Object>> opt = EmbedFunc.flatOperands(slOperand);
                if ((Integer)opt.getLeft() < 2) {
                    return 0;
                }
                int numberSum = 0;
                for (int i = 0; i < (Integer)opt.getLeft(); ++i) {
                    if (!NumberBaseOpt.isNumber(((List)opt.getRight()).get(i))) continue;
                    ++numberSum;
                    dbtemp += NumberBaseOpt.castObjectToDouble(((List)opt.getRight()).get(i), (Double)0.0).doubleValue();
                }
                if (numberSum < 2) {
                    return 0;
                }
                double dbAvg = dbtemp / (double)numberSum;
                dbtemp = 0.0;
                for (int i = 0; i < (Integer)opt.getLeft(); ++i) {
                    if (!NumberBaseOpt.isNumber(((List)opt.getRight()).get(i))) continue;
                    double dtp = NumberBaseOpt.castObjectToDouble(((List)opt.getRight()).get(i), (Double)0.0) - dbAvg;
                    dbtemp += dtp * dtp;
                }
                return Math.sqrt(dbtemp / (double)(numberSum - 1));
            }
            case 106: {
                if (nOpSum < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nOpSum; ++i) {
                    sb.append(StringBaseOpt.castObjectToString((Object)slOperand.get(i), (String)""));
                }
                return sb.toString();
            }
            case 110: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                if (slOperand.get(0) == null) {
                    return null;
                }
                int nStart = 0;
                if (NumberBaseOpt.isNumber((Object)slOperand.get(1))) {
                    nStart = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1));
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                int nLength = nOpSum > 2 && NumberBaseOpt.isNumber((Object)slOperand.get(2)) ? NumberBaseOpt.castObjectToInteger((Object)slOperand.get(2)).intValue() : tempStr.length();
                if (nLength <= 0) {
                    nLength = 1;
                }
                return tempStr.substring(nStart, nStart + nLength);
            }
            case 150: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString((Object)slOperand.get(2));
                    return StringUtils.leftPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.leftPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength);
            }
            case 151: {
                if (nOpSum < 1) {
                    return null;
                }
                if (nOpSum < 2) {
                    return slOperand.get(0);
                }
                int nLength = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0);
                if (nOpSum > 2) {
                    String padChar = StringBaseOpt.castObjectToString((Object)slOperand.get(2));
                    return StringUtils.rightPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength, (String)padChar);
                }
                return StringUtils.rightPad((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (int)nLength);
            }
            case 122: {
                Object obj;
                if (nOpSum < 2) {
                    return -1;
                }
                int nStart = 0;
                if (nOpSum > 2 && NumberBaseOpt.isNumber((Object)slOperand.get(2))) {
                    nStart = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(2));
                }
                if ((obj = slOperand.get(0)) instanceof Collection) {
                    return ((Collection)obj).contains(slOperand.get(1));
                }
                String tempStr = StringBaseOpt.objectToString((Object)obj);
                return tempStr.indexOf(StringBaseOpt.objectToString((Object)slOperand.get(1)), nStart);
            }
            case 142: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 143: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringUtils.lowerCase((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 123: {
                if (nOpSum < 2) {
                    return -1;
                }
                if (slOperand.get(0) == null || slOperand.get(1) == null) {
                    return 0;
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                String str = StringBaseOpt.objectToString((Object)slOperand.get(1));
                int nSt = 0;
                int sl = str.length();
                int nC = 0;
                if (sl == 0) {
                    return 0;
                }
                nSt = tempStr.indexOf(str, nSt);
                while (nSt >= 0) {
                    ++nC;
                    nSt += sl;
                    nSt = tempStr.indexOf(str, nSt);
                }
                return nC;
            }
            case 167: {
                if (nOpSum < 1) {
                    return null;
                }
                String str = StringBaseOpt.castObjectToString((Object)slOperand.get(0));
                String splitStr = nOpSum > 1 ? StringBaseOpt.castObjectToString((Object)slOperand.get(0), (String)" ") : ",";
                return str.split(splitStr);
            }
            case 124: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                return NumberBaseOpt.castObjectToInteger((Object)slOperand.get(0));
            }
            case 107: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.round((Number)tempDouble, (int)pos);
                }
                return Math.round(tempDouble);
            }
            case 165: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.floor((Number)tempDouble, (int)pos);
                }
                return Double.valueOf(Math.floor(tempDouble)).longValue();
            }
            case 166: {
                int pos;
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return slOperand.get(0);
                }
                Double tempDouble = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                int n = pos = nOpSum > 1 ? NumberBaseOpt.castObjectToInteger((Object)slOperand.get(1), (Integer)0) : 0;
                if (pos != 0) {
                    return NumberBaseOpt.ceil((Number)tempDouble, (int)pos);
                }
                return Double.valueOf(Math.ceil(tempDouble)).longValue();
            }
            case 146: {
                if (nOpSum < 1 || slOperand.get(0) == null) {
                    return true;
                }
                return StringUtils.isBlank((CharSequence)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 147: {
                if (nOpSum < 1 || slOperand.get(0) == null) {
                    return false;
                }
                return StringUtils.isNotBlank((CharSequence)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
            case 113: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.log(af);
            }
            case 117: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.log10(af);
            }
            case 118: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.sin(af);
            }
            case 119: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.cos(af);
            }
            case 120: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.tan(af);
            }
            case 121: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.atan(af);
            }
            case 125: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                Double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return af - (double)af.intValue();
            }
            case 114: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.exp(af);
            }
            case 115: {
                if (nOpSum < 1) {
                    return null;
                }
                if (!NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    return null;
                }
                double af = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                return Math.sqrt(af);
            }
            case 108: {
                if (nOpSum < 2) {
                    return null;
                }
                if (BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(0), (Boolean)false).booleanValue()) {
                    return slOperand.get(1);
                }
                if (nOpSum > 2) {
                    return slOperand.get(2);
                }
                return null;
            }
            case 116: {
                if (nOpSum < 2) {
                    return null;
                }
                String tempStr = StringBaseOpt.objectToString((Object)slOperand.get(0));
                int MatchType = 0;
                if (tempStr.equalsIgnoreCase("true")) {
                    MatchType = 1;
                } else if (NumberBaseOpt.isNumber((Object)slOperand.get(0))) {
                    dbtemp = NumberBaseOpt.castObjectToDouble((Object)slOperand.get(0));
                    MatchType = 2;
                }
                int i = 1;
                while (i + 1 < nOpSum) {
                    if (MatchType == 1 ? BooleanBaseOpt.castObjectToBoolean((Object)slOperand.get(i), (Boolean)false) != false : (MatchType == 2 ? NumberBaseOpt.isNumber((Object)slOperand.get(i)) && Math.abs(dbtemp - NumberBaseOpt.castObjectToDouble((Object)slOperand.get(i))) < COMPARE_MIN_DOUBLE : tempStr.equals(StringBaseOpt.objectToString((Object)slOperand.get(i))))) {
                        return slOperand.get(i + 1);
                    }
                    i += 2;
                }
                if (nOpSum % 2 == 0) {
                    return slOperand.get(nOpSum - 1);
                }
                return null;
            }
            case 132: {
                return DatetimeOpt.truncateToDay((Date)DatetimeOpt.currentUtilDate());
            }
            case 149: {
                return DatetimeOpt.currentUtilDate();
            }
            case 155: {
                return DatetimeOpt.currentSqlTimeStamp();
            }
            case 126: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getDay((Date)dt);
            }
            case 127: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getMonth((Date)dt);
            }
            case 128: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getYear((Date)dt);
            }
            case 161: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getWeekOfYear((Date)dt);
            }
            case 162: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.getDayOfWeek((Date)dt);
            }
            case 163: {
                Date dt;
                if (nOpSum < 1) {
                    return null;
                }
                String dateFormat = StringBaseOpt.castObjectToString((Object)slOperand.get(0));
                Date date = dt = nOpSum > 1 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(1)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.convertDateToString((Date)dt, (String)dateFormat);
            }
            case 164: {
                Date dt;
                if (nOpSum < 1) {
                    return null;
                }
                int field = NumberBaseOpt.castObjectToInteger((Object)slOperand.get(0), (Integer)0);
                Date date = dt = nOpSum > 1 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(1)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(dt);
                return cal.get(field);
            }
            case 129: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                Date dt2 = DatetimeOpt.castObjectToDate((Object)slOperand.get(1));
                if (dt == null || dt2 == null) {
                    return null;
                }
                return DatetimeOpt.calcSpanDays((Date)dt, (Date)dt2);
            }
            case 157: {
                if (nOpSum < 2) {
                    return null;
                }
                Date dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                Date dt2 = DatetimeOpt.castObjectToDate((Object)slOperand.get(1));
                if (dt == null || dt2 == null) {
                    return null;
                }
                return Float.valueOf(DatetimeOpt.calcDateSpan((Date)dt, (Date)dt2));
            }
            case 158: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addDays((Date)((Date)dateOpt.getLeft()), (float)NumberBaseOpt.castObjectToFloat((Object)dateOpt.getRight()).floatValue());
            }
            case 137: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addDays((Date)((Date)dateOpt.getLeft()), (int)NumberBaseOpt.castObjectToInteger((Object)dateOpt.getRight()));
            }
            case 138: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addMonths((Date)((Date)dateOpt.getLeft()), (int)NumberBaseOpt.castObjectToInteger((Object)dateOpt.getRight()));
            }
            case 139: {
                LeftRightPair<Date, Object> dateOpt = EmbedFunc.fetchDateOpt(nOpSum, slOperand);
                if (dateOpt.getLeft() == null || dateOpt.getRight() == null) {
                    return null;
                }
                return DatetimeOpt.addYears((Date)((Date)dateOpt.getLeft()), (int)NumberBaseOpt.castObjectToInteger((Object)dateOpt.getRight()));
            }
            case 140: {
                Date dt = null;
                Object ti = null;
                if (nOpSum == 1) {
                    dt = DatetimeOpt.currentUtilDate();
                    ti = slOperand.get(0);
                } else if (nOpSum > 1) {
                    dt = DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
                    if (dt == null) {
                        dt = DatetimeOpt.currentUtilDate();
                    }
                    ti = slOperand.get(1);
                }
                String tempStr = StringBaseOpt.objectToString(ti);
                if ("M".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToMonth((Date)dt);
                }
                if ("Y".equalsIgnoreCase(tempStr)) {
                    return DatetimeOpt.truncateToYear((Date)dt);
                }
                return DatetimeOpt.truncateToDay((Date)dt);
            }
            case 141: {
                Date dt;
                Date date = dt = nOpSum > 0 ? DatetimeOpt.castObjectToDate((Object)slOperand.get(0)) : null;
                if (dt == null) {
                    dt = DatetimeOpt.currentUtilDate();
                }
                return DatetimeOpt.seekEndOfMonth((Date)dt);
            }
            case 152: {
                Object dt;
                Object object = dt = nOpSum > 0 ? slOperand.get(0) : null;
                if (dt == null) {
                    return DatetimeOpt.currentUtilDate();
                }
                if (nOpSum > 1) {
                    return DatetimeOpt.convertStringToDate((String)StringBaseOpt.castObjectToString((Object)slOperand.get(0)), (String)StringBaseOpt.castObjectToString((Object)slOperand.get(1)));
                }
                return DatetimeOpt.castObjectToDate((Object)slOperand.get(0));
            }
            case 153: {
                if (nOpSum < 1) {
                    return null;
                }
                String svalue = StringBaseOpt.castObjectToString((Object)slOperand.get(0));
                if (StringUtils.isBlank((CharSequence)svalue) && nOpSum > 1) {
                    return slOperand.get(1);
                }
                return svalue;
            }
            case 154: {
                if (nOpSum < 1) {
                    return null;
                }
                Number num = NumberBaseOpt.castObjectToNumber((Object)slOperand.get(0));
                if (num == null && nOpSum > 1) {
                    return slOperand.get(1);
                }
                return num;
            }
            case 135: {
                if (nOpSum < 1) {
                    return null;
                }
                return StringBaseOpt.getFirstLetter((String)StringBaseOpt.objectToString((Object)slOperand.get(0)));
            }
        }
        return null;
    }
}

