/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.OptStack;
import com.centit.support.compiler.VariableTranslate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class VariableFormula {
    private Lexer lex = new Lexer();
    private VariableTranslate trans;
    private Map<String, Function<Object[], Object>> extendFuncMap;

    public static int getOptID(String sOptName) {
        int sl = sOptName.length();
        if (sl == 0) {
            return -1;
        }
        char sp = sOptName.charAt(0);
        char sp2 = '\u0000';
        if (sl > 1) {
            sp2 = sOptName.charAt(1);
        }
        switch (sp) {
            case '=': {
                if (sp2 == '=') {
                    return 34;
                }
                return 34;
            }
            case '+': {
                if (sl != 1) break;
                return 30;
            }
            case '-': {
                if (sl != 1) break;
                return 31;
            }
            case '*': {
                return 32;
            }
            case '/': {
                return 33;
            }
            case '%': {
                return 50;
            }
            case '^': {
                return 43;
            }
            case '>': {
                if (sp2 == '=') {
                    return 38;
                }
                if (sp2 == '>') {
                    return 45;
                }
                return 35;
            }
            case '<': {
                if (sp2 == '=') {
                    return 37;
                }
                if (sp2 == '>') {
                    return 39;
                }
                if (sp2 == '<') {
                    return 44;
                }
                return 36;
            }
            case '&': {
                if (sp2 == '&') {
                    return 41;
                }
                return 41;
            }
            case '|': {
                if (sp2 == '|') {
                    return 40;
                }
                return 40;
            }
            case '!': {
                if (sp2 == '=') {
                    return 39;
                }
                return 42;
            }
        }
        if (sOptName.equalsIgnoreCase("LIKE")) {
            return 46;
        }
        if (sOptName.equalsIgnoreCase("AND")) {
            return 49;
        }
        if (sOptName.equalsIgnoreCase("OR")) {
            return 48;
        }
        if (sOptName.equalsIgnoreCase("NOT")) {
            return 42;
        }
        if (sOptName.equalsIgnoreCase("IN")) {
            return 47;
        }
        if (sOptName.equalsIgnoreCase("DIV")) {
            return 33;
        }
        if (sOptName.equalsIgnoreCase("MOD")) {
            return 50;
        }
        if (sOptName.equalsIgnoreCase("DBMOD")) {
            return 51;
        }
        return -1;
    }

    public static boolean isKeyWord(String sWord) {
        if (sWord == null || sWord.length() == 0) {
            return false;
        }
        char firstChar = sWord.charAt(0);
        if (firstChar == ',' || firstChar == '(' || firstChar == ')') {
            return true;
        }
        return VariableFormula.getOptID(sWord) > 0;
    }

    private static boolean isBinocularOperator(String sWord) {
        if (sWord == null || sWord.length() == 0) {
            return false;
        }
        char firstChar = sWord.charAt(0);
        if (firstChar == ',') {
            return true;
        }
        if (firstChar == '!' && sWord.length() == 1 || "not".equalsIgnoreCase(sWord)) {
            return false;
        }
        return VariableFormula.getOptID(sWord) > 0;
    }

    public static Object calculate(String szExpress) {
        VariableFormula formula = new VariableFormula();
        formula.setFormula(szExpress);
        return formula.calcFormula();
    }

    public static Object calculate(String szExpress, VariableTranslate varTrans, Map<String, Function<Object[], Object>> extendFuncMap) {
        VariableFormula formula = new VariableFormula();
        formula.setExtendFuncMap(extendFuncMap);
        formula.setFormula(szExpress);
        formula.setTrans(varTrans);
        return formula.calcFormula();
    }

    public static Object calculate(String szExpress, VariableTranslate varTrans) {
        return VariableFormula.calculate(szExpress, varTrans, null);
    }

    public static Object calculate(String szExpress, Object varMap) {
        return VariableFormula.calculate(szExpress, new ObjectTranslate(varMap), null);
    }

    public static int checkFormula(String szExpress) {
        VariableFormula formula = new VariableFormula();
        formula.setFormula(szExpress);
        return formula.checkFormula();
    }

    public void setTrans(VariableTranslate trans) {
        this.trans = trans;
    }

    public void setFormula(String formula) {
        this.lex.setFormula(formula);
    }

    public void setExtendFuncMap(Map<String, Function<Object[], Object>> extendFuncMap) {
        this.extendFuncMap = extendFuncMap;
    }

    public void addExtendFunc(String funcName, Function<Object[], Object> extendFunc) {
        if (this.extendFuncMap == null) {
            this.extendFuncMap = new HashMap<String, Function<Object[], Object>>(16);
        }
        this.extendFuncMap.put(funcName, extendFunc);
    }

    private Object calcItem() {
        int funcNo;
        String nextWord;
        Function<Object[], Object> func;
        String str = this.lex.getAWord();
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.charAt(0) == ')' || str.charAt(0) == ',') {
            this.lex.writeBackAWord(str);
            return null;
        }
        if (str.charAt(0) == '(') {
            Object resStr = this.calcFormula();
            str = this.lex.getAWord();
            if (str == null || str.length() == 0 || str.charAt(0) != ')') {
                return null;
            }
            return resStr;
        }
        if (str.charAt(0) == '!' || str.equalsIgnoreCase("NOT")) {
            Object obj = this.calcItem();
            return BooleanBaseOpt.castObjectToBoolean((Object)obj, (Boolean)false) == false;
        }
        if (str.charAt(0) == '$') {
            str = this.lex.getAWord();
            if (str.equals("{")) {
                str = this.lex.getStringUntil("}");
                if (this.trans != null) {
                    return this.trans.getVarValue(str);
                }
                return null;
            }
            return null;
        }
        if (str.charAt(0) == '[') {
            ArrayList<Object> slOperand = new ArrayList<Object>();
            do {
                Object item = this.calcFormula();
                slOperand.add(item);
                str = this.lex.getAWord();
                if (str != null && str.length() != 0 && (str.equals(",") || str.equals("]"))) continue;
                return null;
            } while (!str.equals("]"));
            return slOperand;
        }
        if (this.extendFuncMap != null && (func = this.extendFuncMap.get(str)) != null) {
            nextWord = this.lex.getAWord();
            if ("(".equals(nextWord)) {
                return this.calcExtendFunc(func);
            }
            this.lex.writeBackAWord(nextWord);
        }
        if ((funcNo = EmbedFunc.getFuncNo(str)) != -1) {
            nextWord = this.lex.getAWord();
            if ("(".equals(nextWord)) {
                return this.calcFunc(funcNo);
            }
            this.lex.writeBackAWord(nextWord);
        }
        if (this.trans != null && Lexer.isLabel(str)) {
            return this.trans.getVarValue(str);
        }
        if (StringRegularOpt.isNumber((String)str)) {
            return NumberBaseOpt.castObjectToNumber((Object)str);
        }
        return StringRegularOpt.trimString((String)str);
    }

    private Object calcOperate(Object operand, Object operand2, int optID) {
        switch (optID) {
            case 48: {
                return BooleanBaseOpt.castObjectToBoolean((Object)operand, (Boolean)false) != false || BooleanBaseOpt.castObjectToBoolean((Object)operand2, (Boolean)false) != false;
            }
            case 41: 
            case 49: {
                return BooleanBaseOpt.castObjectToBoolean((Object)operand, (Boolean)false) != false && BooleanBaseOpt.castObjectToBoolean((Object)operand2, (Boolean)false) != false;
            }
            case 40: {
                if ((BooleanBaseOpt.isBoolean((Object)operand) || NumberBaseOpt.isNumber((Object)operand)) && (BooleanBaseOpt.isBoolean((Object)operand2) || NumberBaseOpt.isNumber((Object)operand2))) {
                    return BooleanBaseOpt.castObjectToBoolean((Object)operand) != false || BooleanBaseOpt.castObjectToBoolean((Object)operand2) != false;
                }
                return StringBaseOpt.concat((Object[])new Object[]{operand, operand2});
            }
            case 30: {
                return GeneralAlgorithm.addTwoObject((Object)operand, (Object)operand2);
            }
            case 32: {
                return GeneralAlgorithm.multiplyTwoObject((Object)operand, (Object)operand2);
            }
            case 34: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) == 0;
            }
            case 35: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) > 0;
            }
            case 36: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) < 0;
            }
            case 37: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) <= 0;
            }
            case 38: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) >= 0;
            }
            case 39: {
                return GeneralAlgorithm.compareTwoObject((Object)operand, (Object)operand2) != 0;
            }
            case 44: {
                if (NumberBaseOpt.isNumber((Object)operand2)) {
                    int nP2 = NumberBaseOpt.castObjectToInteger((Object)operand2);
                    if (NumberBaseOpt.isNumber((Object)operand)) {
                        int nP = NumberBaseOpt.castObjectToInteger((Object)operand);
                        return nP << nP2;
                    }
                    String str1 = StringBaseOpt.objectToString((Object)operand);
                    if (nP2 >= 0 && str1.length() > nP2) {
                        return str1.substring(nP2);
                    }
                }
                return null;
            }
            case 45: {
                if (NumberBaseOpt.isNumber((Object)operand2)) {
                    int nP2 = NumberBaseOpt.castObjectToInteger((Object)operand2);
                    if (NumberBaseOpt.isNumber((Object)operand)) {
                        int nP = NumberBaseOpt.castObjectToInteger((Object)operand);
                        return nP >> nP2;
                    }
                    String str1 = StringBaseOpt.objectToString((Object)operand);
                    if (nP2 >= 0 && str1.length() > nP2) {
                        return str1.substring(0, str1.length() - nP2);
                    }
                }
                return null;
            }
            case 46: {
                return StringRegularOpt.isMatch((String)StringBaseOpt.objectToString((Object)operand), (String)StringBaseOpt.objectToString((Object)operand2));
            }
            case 31: {
                return GeneralAlgorithm.subtractTwoObject((Object)operand, (Object)operand2);
            }
            case 33: {
                return GeneralAlgorithm.divideTwoObject((Object)operand, (Object)operand2);
            }
            case 50: {
                Long dbop2 = NumberBaseOpt.castObjectToLong((Object)operand2);
                if (dbop2 == null || dbop2 == 0L) {
                    return null;
                }
                Long dbop = NumberBaseOpt.castObjectToLong((Object)operand);
                return dbop % dbop2;
            }
            case 51: {
                BigDecimal dbop2 = NumberBaseOpt.castObjectToBigDecimal((Object)operand2);
                if (dbop2 == null || dbop2.compareTo(BigDecimal.ZERO) == 0) {
                    return null;
                }
                return GeneralAlgorithm.modTwoObject((Object)operand, (Object)operand2);
            }
            case 43: {
                Double dbop = NumberBaseOpt.castObjectToDouble((Object)operand);
                Double dbop2 = NumberBaseOpt.castObjectToDouble((Object)operand2);
                if (dbop == null || dbop2 == null) {
                    return null;
                }
                return Math.pow(dbop, dbop2);
            }
        }
        return null;
    }

    public String skipAWord() {
        return this.lex.getAWord();
    }

    public Object calcFormula() {
        ArrayList<Object> slOperand = new ArrayList<Object>();
        OptStack optStack = new OptStack();
        block0: while (true) {
            Object item = this.calcItem();
            slOperand.add(0, item);
            String str = this.lex.getAWord();
            if (str == null || str.length() == 0) break;
            int optID = VariableFormula.getOptID(str);
            if (optID == -1) {
                this.lex.writeBackAWord(str);
                break;
            }
            if (optID == 47) {
                Boolean bInRes = false;
                Object operand = slOperand.remove(0);
                str = this.lex.getAWord();
                if (str == null || str.length() == 0 || !str.equals("(")) {
                    return null;
                }
                do {
                    if ((item = this.calcFormula()) instanceof Object[]) {
                        Object[] objs = (Object[])item;
                        for (int i = 0; i < objs.length; ++i) {
                            if (GeneralAlgorithm.compareTwoObject(operand, (Object)objs[i]) != 0) continue;
                            bInRes = true;
                            break;
                        }
                    } else if (item instanceof Collection) {
                        for (Object obj : (Collection)item) {
                            if (GeneralAlgorithm.compareTwoObject(operand, obj) != 0) continue;
                            bInRes = true;
                            break;
                        }
                    } else if (GeneralAlgorithm.compareTwoObject(operand, (Object)item) == 0) {
                        bInRes = true;
                    }
                    if ((str = this.lex.getAWord()) != null && str.length() != 0 && (str.equals(",") || str.equals(")"))) continue;
                    return null;
                } while (!str.equals(")"));
                this.lex.writeBackAWord(str);
                this.lex.seekToRightBracket();
                slOperand.add(0, bInRes);
                str = this.lex.getAWord();
                optID = VariableFormula.getOptID(str);
                if (optID == -1) {
                    this.lex.writeBackAWord(str);
                    break;
                }
            }
            int op = optStack.pushOpt(optID);
            while (true) {
                if (op == 0) continue block0;
                Object operand2 = slOperand.remove(0);
                Object operand = slOperand.remove(0);
                slOperand.add(0, this.calcOperate(operand, operand2, op));
                op = optStack.pushOpt(optID);
            }
            break;
        }
        int op = optStack.popOpt();
        while (op != 0) {
            Object operand2 = slOperand.remove(0);
            Object operand = slOperand.remove(0);
            slOperand.add(0, this.calcOperate(operand, operand2, op));
            op = optStack.popOpt();
        }
        return slOperand.get(0);
    }

    private Object calcFunc(int nFuncNo) {
        String str;
        if (EmbedFunc.functionsList[nFuncNo].nFuncID == 108) {
            Object sCondition = this.calcFormula();
            if (sCondition == null) {
                return null;
            }
            String str2 = this.lex.getAWord();
            if (str2 == null || str2.length() == 0 || !str2.equals(",")) {
                return null;
            }
            if (BooleanBaseOpt.castObjectToBoolean((Object)sCondition, (Boolean)false).booleanValue()) {
                Object objRes = this.calcFormula();
                str2 = this.lex.getAWord();
                if (str2 == null || str2.length() == 0 || !str2.equals(",") && !str2.equals(")")) {
                    return null;
                }
                if (str2.equals(")")) {
                    return objRes;
                }
                this.lex.skipAOperand();
                str2 = this.lex.getAWord();
                if (str2 == null || str2.length() == 0 || !str2.equals(")")) {
                    return null;
                }
                return objRes;
            }
            this.lex.skipAOperand();
            str2 = this.lex.getAWord();
            if (str2 == null || str2.length() == 0 || !str2.equals(",") && !str2.equals(")")) {
                return null;
            }
            if (str2.equals(")")) {
                return null;
            }
            Object objRes = this.calcFormula();
            str2 = this.lex.getAWord();
            if (str2 == null || str2.length() == 0 || !str2.equals(")")) {
                return null;
            }
            return objRes;
        }
        ArrayList<Object> slOperand = new ArrayList<Object>(5);
        int prmNo = 0;
        while (!(str = this.lex.getAWord()).equals(")")) {
            this.lex.writeBackAWord(str);
            Object item = this.calcFormula();
            slOperand.add(item);
            ++prmNo;
            str = this.lex.getAWord();
            if (",".equals(str)) continue;
            break;
        }
        if (!")".equals(str)) {
            return null;
        }
        if (EmbedFunc.functionsList[nFuncNo].nPrmSum != -1 && prmNo < EmbedFunc.functionsList[nFuncNo].nPrmSum) {
            return null;
        }
        return EmbedFunc.runFuncWithObject(slOperand, EmbedFunc.functionsList[nFuncNo].nFuncID);
    }

    private Object calcExtendFunc(Function<Object[], Object> func) {
        String str;
        ArrayList<Object> slOperand = new ArrayList<Object>(5);
        while (!(str = this.lex.getAWord()).equals(")")) {
            this.lex.writeBackAWord(str);
            Object item = this.calcFormula();
            if (item != null) {
                slOperand.add(item);
            }
            if (",".equals(str = this.lex.getAWord())) continue;
            break;
        }
        if (!")".equals(str)) {
            return null;
        }
        return func.apply(CollectionsOpt.listToArray(slOperand));
    }

    public Object calcFormula(String szExpress) {
        this.setFormula(szExpress);
        return this.calcFormula();
    }

    public int checkFormula() {
        boolean endWithBracket = false;
        boolean endWithOpt = true;
        int nBrackets = 0;
        String sWord = this.lex.getAWord();
        while (!StringBaseOpt.isNvl((String)sWord)) {
            boolean isOpt = VariableFormula.isBinocularOperator(sWord);
            if (isOpt && endWithOpt) {
                return this.lex.getCurrPos() + 1;
            }
            if ("(".equals(sWord)) {
                if (endWithBracket) {
                    return this.lex.getCurrPos() + 1;
                }
                ++nBrackets;
            } else if (")".equals(sWord)) {
                if (endWithOpt) {
                    return this.lex.getCurrPos() + 1;
                }
                --nBrackets;
            }
            if (",".equals(sWord) && nBrackets == 0) {
                return this.lex.getCurrPos() + 1;
            }
            endWithBracket = ")".equals(sWord);
            endWithOpt = isOpt;
            if (nBrackets < 0) {
                return this.lex.getCurrPos() + 1;
            }
            sWord = this.lex.getAWord();
        }
        if (nBrackets == 0) {
            return 0;
        }
        return this.lex.getCurrPos() + 1;
    }
}

