/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.database.utils.DataSourceDescription;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbcpConnectPools {
    protected static final Logger logger = LoggerFactory.getLogger(DbcpConnectPools.class);
    private static final Map<DataSourceDescription, BasicDataSource> dbcpDataSourcePools = new ConcurrentHashMap<DataSourceDescription, BasicDataSource>();

    private DbcpConnectPools() {
        throw new IllegalAccessError("Utility class");
    }

    private static synchronized BasicDataSource addDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setUrl(dsDesc.getConnUrl());
        ds.setInitialSize(dsDesc.getInitialSize());
        ds.setMaxTotal(dsDesc.getMaxTotal());
        ds.setMaxIdle(dsDesc.getMaxIdle());
        ds.setMaxWaitMillis((long)dsDesc.getMaxWaitMillis());
        ds.setMinIdle(dsDesc.getMinIdle());
        dbcpDataSourcePools.put(dsDesc, ds);
        return ds;
    }

    public static synchronized BasicDataSource getDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.addDataSource(dsDesc);
        }
        return ds;
    }

    public static synchronized Connection getDbcpConnect(DataSourceDescription dsDesc) throws SQLException {
        BasicDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.addDataSource(dsDesc);
        }
        Connection conn = null;
        conn = ds.getConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    public static Map<String, Integer> getDataSourceStats(DataSourceDescription dsDesc) {
        BasicDataSource bds = dbcpDataSourcePools.get(dsDesc);
        if (bds == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("active_number", bds.getNumActive());
        map.put("idle_number", bds.getNumIdle());
        return map;
    }

    public static synchronized void shutdownDataSource() {
        for (Map.Entry<DataSourceDescription, BasicDataSource> dbs : dbcpDataSourcePools.entrySet()) {
            try {
                dbs.getValue().close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean testDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setUrl(dsDesc.getConnUrl());
        ds.setInitialSize(dsDesc.getInitialSize());
        ds.setMaxTotal(dsDesc.getMaxTotal());
        ds.setMaxIdle(dsDesc.getMaxIdle());
        ds.setMaxWaitMillis((long)dsDesc.getMaxWaitMillis());
        ds.setMinIdle(dsDesc.getMinIdle());
        boolean connOk = false;
        try {
            Connection conn = ds.getConnection();
            if (conn != null) {
                connOk = true;
                conn.close();
            }
            ds.close();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ds.close();
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return connOk;
    }

    public static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

