/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DbcpConnectPools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionHandler {
    private static final Logger logger = LoggerFactory.getLogger(TransactionHandler.class);

    private TransactionHandler() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> T executeInTransaction(DataSourceDescription dataSourceDesc, TransactionWork<T> realWork) throws SQLException {
        Connection conn = DbcpConnectPools.getDbcpConnect(dataSourceDesc);
        try {
            T relRet = realWork.execute(conn);
            conn.commit();
            T t = relRet;
            return t;
        }
        catch (SQLException e) {
            logger.error("error code :" + e.getSQLState() + e.getLocalizedMessage(), (Throwable)e);
            conn.rollback();
            throw e;
        }
        finally {
            DbcpConnectPools.closeConnect(conn);
        }
    }

    public static interface TransactionWork<T> {
        public T execute(Connection var1) throws SQLException;
    }
}

