/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.transaction;

import com.centit.support.database.DBConnect;
import com.centit.support.database.transaction.Transactional;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class TransactionInvocationHandler
implements InvocationHandler {
    private Object obj;

    public TransactionInvocationHandler(Object obj) {
        this.obj = obj;
    }

    public static Object getProxyInstanceFactory(Object realObj) {
        Class<?> classType = realObj.getClass();
        return Proxy.newProxyInstance(classType.getClassLoader(), classType.getInterfaces(), (InvocationHandler)new TransactionInvocationHandler(realObj));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object retObj = null;
        boolean inTransaction = false;
        ArrayList<DBConnect> needCommitConn = new ArrayList<DBConnect>(3);
        try {
            inTransaction = method.isAnnotationPresent(Transactional.class);
            if (inTransaction && args != null) {
                for (Object arg : args) {
                    DBConnect conn;
                    if (!(arg instanceof DBConnect) || !(conn = (DBConnect)arg).startTransaction()) continue;
                    needCommitConn.add(conn);
                }
            }
            retObj = method.invoke(this.obj, args);
            if (inTransaction && needCommitConn.size() > 0) {
                for (DBConnect conn : needCommitConn) {
                    conn.commit();
                }
            }
        }
        catch (Exception e) {
            if (inTransaction && needCommitConn.size() > 0) {
                for (DBConnect conn : needCommitConn) {
                    conn.rollback();
                }
            }
            throw e;
        }
        return retObj;
    }
}

