/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.ddl;

import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.sql.Connection;
import org.apache.commons.lang3.StringUtils;

public class MySqlDDLOperations
extends GeneralDDLOperations {
    public MySqlDDLOperations() {
    }

    public MySqlDDLOperations(Connection conn) {
        super(conn);
    }

    @Override
    protected void appendPkSql(TableInfo tableInfo, StringBuilder sbCreate) {
        if (tableInfo.getPkColumns() != null && tableInfo.getPkColumns().size() > 0) {
            sbCreate.append(" primary key ");
            this.appendPkColumnSql(tableInfo, sbCreate);
        }
    }

    @Override
    public String makeModifyColumnSql(String tableCode, TableField oldColumn, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" MODIFY COLUMN  ").append(column.getColumnName()).append(" ");
        if (!StringUtils.equalsIgnoreCase((CharSequence)oldColumn.getColumnType(), (CharSequence)column.getColumnType()) || oldColumn.getMaxLength() != column.getMaxLength() || oldColumn.getPrecision() != column.getPrecision()) {
            this.appendColumnTypeSQL(column, sbsql);
        }
        if (oldColumn.isMandatory() != column.isMandatory()) {
            sbsql.append(column.isMandatory() ? " not null" : " null");
        }
        return sbsql.toString();
    }

    @Override
    public String makeRenameColumnSql(String tableCode, String columnCode, TableField column) {
        StringBuilder sbsql = new StringBuilder("alter table ");
        sbsql.append(tableCode);
        sbsql.append(" CHANGE ");
        sbsql.append(columnCode);
        sbsql.append(" ");
        sbsql.append(column.getColumnName());
        sbsql.append(" ");
        this.appendColumnTypeSQL(column, sbsql);
        return sbsql.toString();
    }
}

