/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSONArray;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DB2JsonObjectDao
extends GeneralJsonObjectDao {
    public DB2JsonObjectDao() {
    }

    public DB2JsonObjectDao(Connection conn) {
        super(conn);
    }

    public DB2JsonObjectDao(TableInfo tableInfo) {
        super(tableInfo);
    }

    public DB2JsonObjectDao(Connection conn, TableInfo tableInfo) {
        super(conn, tableInfo);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        TableInfo tableInfo = this.getTableInfo();
        Pair<String, String[]> q = DB2JsonObjectDao.buildFieldSqlWithFieldName(tableInfo, null);
        String filter = DB2JsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)tableInfo.getOrderBy())) {
            sql = sql + " order by " + tableInfo.getOrderBy();
        }
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.getConnect(), QueryUtils.buildDB2LimitQuerySQL(sql, startPos, maxSize), properties, (String[])q.getRight());
    }

    @Override
    public Long getSequenceNextValue(String sequenceName) throws SQLException, IOException {
        Object object = DatabaseAccess.getScalarObjectQuery(this.getConnect(), "SELECT nextval for " + sequenceName + " from sysibm.sysdummy1");
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsBySql(this.getConnect(), QueryUtils.buildDB2LimitQuerySQL(sSql, startPos, pageSize), values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsByNamedSql(this.getConnect(), QueryUtils.buildDB2LimitQuerySQL(sSql, startPos, pageSize), values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsAsJSON(this.getConnect(), QueryUtils.buildDB2LimitQuerySQL(sSql, startPos, pageSize), values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.getConnect(), QueryUtils.buildDB2LimitQuerySQL(sSql, startPos, pageSize), values, fieldnames);
    }
}

