/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.common.KeyValuePair;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class QueryUtils {
    public static final String SQL_PRETREAT_NO_PARAM = "NP";
    public static final String SQL_PRETREAT_LIKE = "LIKE";
    public static final String SQL_PRETREAT_STARTWITH = "STARTWITH";
    public static final String SQL_PRETREAT_ENDWITH = "ENDWITH";
    public static final String SQL_PRETREAT_DATE = "DATE";
    public static final String SQL_PRETREAT_NEXTDAY = "NEXTDAY";
    public static final String SQL_PRETREAT_DATETIME = "DATETIME";
    public static final String SQL_PRETREAT_DATESTR = "DATESTR";
    public static final String SQL_PRETREAT_DATETIMESTR = "DATETIMESTR";
    public static final String SQL_PRETREAT_DIGIT = "DIGIT";
    public static final String SQL_PRETREAT_UPPERCASE = "UPPERCASE";
    public static final String SQL_PRETREAT_LOWERCASE = "LOWERCASE";
    public static final String SQL_PRETREAT_NUMBER = "NUMBER";
    public static final String SQL_PRETREAT_QUOTASTR = "QUOTASTR";
    public static final String SQL_PRETREAT_INTEGER = "INTEGER";
    public static final String SQL_PRETREAT_LONG = "LONG";
    public static final String SQL_PRETREAT_FLOAT = "FLOAT";
    public static final String SQL_PRETREAT_STRING = "STRING";
    public static final String SQL_PRETREAT_SPLITFORIN = "SPLITFORIN";
    public static final String SQL_PRETREAT_CREEPFORIN = "CREEPFORIN";
    public static final String SQL_PRETREAT_INPLACE = "INPLACE";
    public static final String SQL_PRETREAT_ESCAPE_HTML = "ESCAPEHTML";

    private QueryUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static String buildStringForQuery(String value) {
        if (value == null || "".equals(value)) {
            return "''";
        }
        return "'" + StringUtils.replace((String)value.trim(), (String)"'", (String)"''") + "'";
    }

    public static String buildObjectsStringForQuery(Object[] objects) {
        if (objects == null || objects.length < 1) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        int dataCount = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (dataCount > 0) {
                sb.append(",");
            }
            sb.append(QueryUtils.buildStringForQuery(String.valueOf(obj)));
            ++dataCount;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String buildObjectsStringForQuery(Collection<?> objects) {
        if (objects == null || objects.size() < 1) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        int dataCount = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (dataCount > 0) {
                sb.append(",");
            }
            sb.append(QueryUtils.buildStringForQuery(String.valueOf(obj)));
            ++dataCount;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String buildObjectStringForQuery(Object fieldValue) {
        if (fieldValue instanceof java.util.Date) {
            return QueryUtils.buildDatetimeStringForQuery((java.util.Date)fieldValue);
        }
        if (fieldValue instanceof Date) {
            return QueryUtils.buildDatetimeStringForQuery((Date)fieldValue);
        }
        if (fieldValue.getClass().getSuperclass().equals(Number.class)) {
            return fieldValue.toString();
        }
        if (fieldValue instanceof Object[]) {
            return QueryUtils.buildObjectsStringForQuery((Object[])fieldValue);
        }
        if (fieldValue instanceof Collection) {
            return QueryUtils.buildObjectsStringForQuery((Collection)fieldValue);
        }
        return QueryUtils.buildStringForQuery(fieldValue.toString());
    }

    public static String buildDateStringForQuery(java.util.Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "'";
    }

    public static String buildDateStringForQuery(Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "'";
    }

    public static String buildDatetimeStringForQuery(java.util.Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "'";
    }

    public static String buildDatetimeStringForQuery(Date value) {
        return "'" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "'";
    }

    public static String buildDateStringForOracle(java.util.Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "','yyyy-MM-dd')";
    }

    public static String buildDateStringForOracle(Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd") + "','yyyy-MM-dd')";
    }

    public static String buildDateTimeStringForOracle(java.util.Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss')";
    }

    public static String buildDateTimeStringForOracle(Date value) {
        return "TO_DATE('" + DatetimeOpt.convertDateToString((java.util.Date)value, (String)"yyyy-MM-dd HH:mm:ss") + "','yyyy-MM-dd hh24:mi:ss')";
    }

    public static String getMatchString(String sMatch) {
        StringBuilder sRes = new StringBuilder("%");
        char preChar = '%';
        int sL = sMatch.length();
        for (int i = 0; i < sL; ++i) {
            char curChar = sMatch.charAt(i);
            if (curChar == ' ' || curChar == '\t' || curChar == '%' || curChar == '*') {
                curChar = '%';
                if (preChar == 37) continue;
                sRes.append(curChar);
                preChar = curChar;
                continue;
            }
            if (curChar == '?') {
                sRes.append("_");
                preChar = curChar;
                continue;
            }
            sRes.append(curChar);
            preChar = curChar;
        }
        if (preChar != '%') {
            sRes.append('%');
        }
        return sRes.toString();
    }

    public static int replaceMatchParams(Map<String, Object> queryParams, Collection<String> likeParams) {
        if (likeParams == null || likeParams.size() == 0 || queryParams == null) {
            return 0;
        }
        int n = 0;
        for (String f : likeParams) {
            Object value = queryParams.get(f);
            if (value == null) continue;
            queryParams.put(f, QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)value)));
            ++n;
        }
        return n;
    }

    public static int replaceMatchParams(Map<String, Object> queryParams, String ... likeParams) {
        if (likeParams == null || likeParams.length == 0 || queryParams == null) {
            return 0;
        }
        int n = 0;
        for (String f : likeParams) {
            Object value = queryParams.get(f);
            if (value == null) continue;
            queryParams.put(f, QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)value)));
            ++n;
        }
        return n;
    }

    public static boolean hasOrderBy(String sql) {
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            aWord = lex.getAWord();
        }
        return "order".equalsIgnoreCase(aWord);
    }

    public static String removeOrderBy(String sql) {
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        int nPos = lex.getCurrPos();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
            if (aWord != null && !"".equals(aWord)) continue;
            return sql;
        }
        return sql.substring(0, nPos);
    }

    public static String getGroupByField(String sql) {
        int nPos;
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"group".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
            return null;
        }
        if ("group".equalsIgnoreCase(aWord)) {
            while (aWord != null && !"".equals(aWord) && !"by".equalsIgnoreCase(aWord)) {
                aWord = lex.getAWord();
            }
        }
        if (!"by".equalsIgnoreCase(aWord)) {
            return null;
        }
        int nEnd = nPos = lex.getCurrPos();
        while (aWord != null && !"".equals(aWord) && !"order".equalsIgnoreCase(aWord)) {
            nEnd = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        if (nEnd > nPos) {
            return sql.substring(nPos, nEnd);
        }
        return null;
    }

    public static List<String> splitSqlByFields(String sql) {
        int nSelectPos;
        Lexer lex = new Lexer(sql, 2);
        ArrayList<String> sqlPiece = new ArrayList<String>(5);
        int sl = sql.length();
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"select".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
        }
        int nFieldBegin = nSelectPos = lex.getCurrPos();
        if (nSelectPos >= sl) {
            lex.setFormula(sql);
            nSelectPos = 0;
            nFieldBegin = 0;
            aWord = lex.getAWord();
        } else {
            aWord = lex.getAWord();
            if ("top".equalsIgnoreCase(aWord) && StringRegularOpt.isNumber((String)(aWord = lex.getAWord()))) {
                nFieldBegin = lex.getCurrPos();
            }
        }
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            }
            if ((aWord = lex.getAWord()) != null && !"".equals(aWord)) continue;
            return sqlPiece;
        }
        int nFieldEnd = lex.getCurrPos();
        sqlPiece.add(sql.substring(0, nSelectPos));
        sqlPiece.add(sql.substring(nFieldBegin, nFieldEnd));
        sqlPiece.add(sql.substring(nFieldEnd));
        if (nFieldBegin > nSelectPos) {
            sqlPiece.add(sql.substring(nSelectPos, nFieldBegin));
        }
        return sqlPiece;
    }

    public static String buildGetCountSQLByReplaceFields(String sql) {
        String groupByField;
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)sqlPieces.get(0))) {
            sqlPieces.set(0, "select");
        }
        if ((groupByField = QueryUtils.getGroupByField(sqlPieces.get(2))) == null) {
            return sqlPieces.get(0) + " count(*) as rowcount from " + QueryUtils.removeOrderBy(sqlPieces.get(2));
        }
        return sqlPieces.get(0) + " count(*) as rowcount from (select " + groupByField + " from " + QueryUtils.removeOrderBy(sqlPieces.get(2)) + ") a";
    }

    public static String buildGetCountSQLBySubSelect(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)sqlPieces.get(0))) {
            sqlPieces.set(0, "select");
        }
        if ("from".equalsIgnoreCase(sqlPieces.get(1).trim())) {
            sqlPieces.set(1, " * from");
        }
        return sqlPieces.get(0) + " count(*) as rowCount from (select " + sqlPieces.get(1) + sqlPieces.get(2) + ") a";
    }

    public static String buildGetCountSQL(String sql) {
        return QueryUtils.buildGetCountSQLBySubSelect(sql);
    }

    public static String buildGetCountHQL(String hql) {
        return QueryUtils.buildGetCountSQLByReplaceFields(hql);
    }

    public static String buildMySqlLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter) {
        if (asParameter) {
            return sql + (offset > 0 ? " limit ?, ?" : " limit ?");
        }
        return sql + (offset > 0 ? " limit " + String.valueOf(offset) + "," + String.valueOf(maxsize) : " limit " + String.valueOf(maxsize));
    }

    public static String buildOracleLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter) {
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (asParameter) {
            if (offset > 0) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (offset > 0) {
                pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(" ) where rownum <= ?");
            }
        } else {
            if (offset > 0) {
                pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
            } else {
                pagingSelect.append("select * from ( ");
            }
            pagingSelect.append(sql);
            if (offset > 0) {
                pagingSelect.append(" ) row_ ) where rownum_ <= ").append(offset + maxsize).append(" and rownum_ > ").append(offset);
            } else {
                pagingSelect.append(" ) where rownum <= ").append(maxsize);
            }
        }
        return pagingSelect.toString();
    }

    public static String buildDB2LimitQuerySQL(String sql, int offset, int maxsize) {
        if (offset == 0) {
            return maxsize > 1 ? sql + " fetch first " + maxsize + " rows only" : " fetch first 1 row only";
        }
        return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( " + sql + " fetch first " + String.valueOf(offset + maxsize) + " rows only ) as inner2_ ) as inner1_ where rownumber_ > " + offset + " order by rownumber_";
    }

    public static String buildSqlServerLimitQuerySQL(String sql, int offset, int maxsize) {
        int selectDistinctIndex;
        if (offset > 0) {
            String alias_list = StringBaseOpt.objectToString(QueryUtils.getSqlFiledNames(sql));
            return "WITH query AS (SELECT inner_query.* , ROW_NUMBER() OVER (ORDER BY CURRENT_TIMESTAMP) as __row_nr__  FROM ( " + sql + ") inner_query )  SELECT " + alias_list + " FROM query WHERE __row_nr__ >=" + String.valueOf(offset) + " AND __row_nr__ < " + String.valueOf(offset + maxsize);
        }
        int selectIndex = sql.toLowerCase(Locale.ROOT).indexOf("select");
        return new StringBuilder(sql.length() + 8).append(sql).insert(selectIndex += (selectDistinctIndex = sql.toLowerCase(Locale.ROOT).indexOf("select distinct")) == selectIndex ? 15 : 6, " top " + maxsize).toString();
    }

    public static String buildLimitQuerySQL(String sql, int offset, int maxsize, boolean asParameter, DBType dbType) {
        switch (dbType) {
            case Oracle: {
                return QueryUtils.buildOracleLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
            case DB2: {
                return QueryUtils.buildDB2LimitQuerySQL(sql, offset, maxsize);
            }
            case SqlServer: {
                return QueryUtils.buildSqlServerLimitQuerySQL(sql, offset, maxsize);
            }
            case MySql: {
                return QueryUtils.buildMySqlLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
            case H2: {
                return QueryUtils.buildMySqlLimitQuerySQL(sql, offset, maxsize, asParameter);
            }
        }
        throw new PersistenceException(14, "\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbType.toString());
    }

    public static KeyValuePair<String, List<String>> transNamedParamSqlToParamSql(String sql) {
        StringBuilder sqlb = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(sql, 2);
        int prePos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                int curPos = lex.getCurrPos();
                if (curPos - 1 > prePos) {
                    sqlb.append(sql.substring(prePos, curPos - 1));
                }
                if ((aWord = lex.getAWord()) == null || "".equals(aWord)) break;
                params.add(aWord);
                sqlb.append("?");
                prePos = lex.getCurrPos();
            }
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return new KeyValuePair((Object)sqlb.toString(), params);
    }

    public static List<String> getSqlNamedParameters(String sql) {
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                aWord = lex.getAWord();
                if (aWord == null || "".equals(aWord)) break;
                params.add(aWord);
            }
            aWord = lex.getAWord();
        }
        return params;
    }

    public static String fetchTemplateParamName(String pramePiece) {
        String paramName = null;
        int n = pramePiece.indexOf(58);
        if (n < 0) {
            return pramePiece.trim();
        }
        if (n > 1 && StringUtils.isNotBlank((CharSequence)(paramName = pramePiece.substring(0, n).trim()))) {
            return paramName;
        }
        String paramAlias = pramePiece.substring(n + 1).trim();
        if ((n = paramAlias.lastIndexOf(41)) < 0) {
            return paramAlias;
        }
        return paramAlias.substring(n + 1).trim();
    }

    public static Set<String> fetchTemplateParamNames(String paramString) {
        HashSet<String> params = new HashSet<String>();
        List pramePieces = Lexer.splitByWord((String)paramString, (String)",");
        for (String pramePiece : pramePieces) {
            params.add(QueryUtils.fetchTemplateParamName(pramePiece));
        }
        return params;
    }

    public static Set<String> fetchParamsFromTemplateConditions(String queryPiece) {
        Lexer varMorp = new Lexer(queryPiece, 2);
        String aWord = varMorp.getARawWord();
        if (aWord == null || aWord.length() == 0) {
            return null;
        }
        HashSet<String> paramList = new HashSet<String>();
        if ("(".equals(aWord)) {
            int curPos = varMorp.getCurrPos();
            if (!varMorp.seekToRightBracket()) {
                return null;
            }
            int prePos = varMorp.getCurrPos();
            String condition = queryPiece.substring(curPos, prePos - 1);
            Lexer labelSelected = new Lexer(condition, 2);
            aWord = labelSelected.getARawWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (aWord.equals("$")) {
                    aWord = labelSelected.getAWord();
                    if (aWord.equals("{")) {
                        aWord = labelSelected.getStringUntil("}");
                        paramList.add(aWord);
                    }
                } else if (Lexer.isLabel((String)aWord) && !VariableFormula.isKeyWord((String)aWord) && EmbedFunc.getFuncNo((String)aWord) == -1) {
                    paramList.add(aWord);
                }
                aWord = labelSelected.getARawWord();
            }
            aWord = varMorp.getARawWord();
            if ("(".equals(aWord)) {
                curPos = varMorp.getCurrPos();
                if (!varMorp.seekToRightBracket()) {
                    return null;
                }
                prePos = varMorp.getCurrPos();
                aWord = varMorp.getARawWord();
                String paramsString = null;
                if (prePos - 1 > curPos) {
                    paramsString = queryPiece.substring(curPos, prePos - 1);
                }
                if (paramsString != null) {
                    paramList.addAll(QueryUtils.fetchTemplateParamNames(paramsString));
                }
            }
        } else {
            if (!varMorp.seekTo("|", false)) {
                return null;
            }
            int curPos = varMorp.getCurrPos();
            String paramsString = queryPiece.substring(0, curPos - 1);
            if (StringUtils.isBlank((CharSequence)paramsString)) {
                return null;
            }
            paramList.addAll(QueryUtils.fetchTemplateParamNames(paramsString));
        }
        return paramList;
    }

    public static Set<String> getSqlTemplateParameters(String sql) {
        HashSet<String> params = new HashSet<String>();
        Lexer lex = new Lexer(sql, 2);
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (":".equals(aWord)) {
                aWord = lex.getAWord();
                if (aWord == null || "".equals(aWord)) {
                    return params;
                }
                params.add(aWord);
            } else if (aWord.equals("[")) {
                int beginPos = lex.getCurrPos();
                lex.seekToRightSquareBracket();
                int endPos = lex.getCurrPos();
                String queryPiece = sql.substring(beginPos, endPos - 1).trim();
                Set<String> subParams = QueryUtils.fetchParamsFromTemplateConditions(queryPiece);
                if (subParams != null && subParams.size() > 0) {
                    params.addAll(subParams);
                }
            }
            aWord = lex.getAWord();
        }
        return params;
    }

    public static List<Pair<String, String>> getSqlFieldNamePieceMap(String sql) {
        ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>(20);
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return fields;
        }
        String sFieldSql = sqlPieces.get(1);
        Lexer lex = new Lexer(sFieldSql, 2);
        int nFiledNo = 0;
        int nPos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            int nPos2 = lex.getCurrPos();
            int nPosEnd = -1;
            String filedName = null;
            boolean prewordIsOpt = false;
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                    prewordIsOpt = false;
                } else if ("as".equalsIgnoreCase(aWord)) {
                    nPosEnd = nPos2;
                    filedName = aWord = lex.getAWord();
                } else if (Lexer.isLabel((String)aWord)) {
                    if (!prewordIsOpt) {
                        nPosEnd = nPos2;
                        filedName = aWord;
                    }
                    prewordIsOpt = false;
                } else {
                    boolean bl = prewordIsOpt = VariableFormula.getOptID((String)aWord) > 0;
                    if (prewordIsOpt) {
                        filedName = null;
                    }
                }
                nPos2 = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            ++nFiledNo;
            if (filedName == null) {
                filedName = "column" + String.valueOf(nFiledNo);
                nPosEnd = -1;
            } else {
                int n = filedName.lastIndexOf(46);
                if (n > 0) {
                    filedName = filedName.substring(n + 1);
                }
            }
            fields.add((Pair<String, String>)new MutablePair((Object)filedName, (Object)sFieldSql.substring(nPos, nPosEnd > nPos ? nPosEnd : nPos2).trim()));
            nPos = nPos2;
            if (!",".equals(aWord)) continue;
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> getSqlFieldPieces(String sql) {
        ArrayList<String> fields = new ArrayList<String>(5);
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return fields;
        }
        String sFieldSql = sqlPieces.get(1);
        Lexer lex = new Lexer(sFieldSql, 2);
        int nPos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            int nPos2 = lex.getCurrPos();
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                nPos2 = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            fields.add(sFieldSql.substring(nPos, nPos2).trim());
            nPos = nPos2;
            if (!",".equals(aWord)) continue;
            nPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> splitSqlFieldNames(String sFieldSql) {
        String aWord;
        ArrayList<String> fields = new ArrayList<String>(20);
        Lexer lex = new Lexer(sFieldSql, 2);
        String filedName = aWord = lex.getAWord();
        int nFiledNo = 0;
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            boolean prewordIsOpt = false;
            while (!("".equals(aWord) || ",".equals(aWord) || "from".equalsIgnoreCase(aWord))) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                    prewordIsOpt = false;
                } else {
                    if ("*".equals(aWord)) {
                        return null;
                    }
                    if (Lexer.isLabel((String)aWord)) {
                        if (!prewordIsOpt) {
                            filedName = aWord;
                        }
                        prewordIsOpt = false;
                    } else {
                        boolean bl = prewordIsOpt = VariableFormula.getOptID((String)aWord) > 0;
                        if (prewordIsOpt) {
                            filedName = null;
                        }
                    }
                }
                aWord = lex.getAWord();
            }
            ++nFiledNo;
            if (filedName == null) {
                filedName = "";
            } else {
                int n = filedName.lastIndexOf(46);
                if (n > 0 && "*".equals(filedName = filedName.substring(n + 1))) {
                    return null;
                }
            }
            fields.add(filedName);
            if (!",".equals(aWord)) continue;
            filedName = aWord;
            aWord = lex.getAWord();
        }
        return fields;
    }

    public static List<String> getSqlFiledNames(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return null;
        }
        return QueryUtils.splitSqlFieldNames(sqlPieces.get(1));
    }

    public static List<String> getSqlTemplateFiledNames(String sql) {
        List<String> sqlPieces = QueryUtils.splitSqlByFields(sql);
        if (sqlPieces == null || sqlPieces.size() < 3) {
            return null;
        }
        String sFieldSql = sqlPieces.get(1);
        Lexer varMorp = new Lexer(sFieldSql, 2);
        StringBuilder sbSql = new StringBuilder();
        int prePos = 0;
        String aWord = varMorp.getAWord();
        while (aWord != null && !"".equals(aWord) && !"from".equalsIgnoreCase(aWord)) {
            if (aWord.equals("[")) {
                int curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    sbSql.append(sFieldSql.substring(prePos, curPos - 1));
                }
                aWord = varMorp.getAWord();
                while (aWord != null && !"|".equals(aWord)) {
                    if ("(".equals(aWord)) {
                        varMorp.seekToRightBracket();
                    }
                    aWord = varMorp.getAWord();
                }
                if ("|".equals(aWord)) {
                    curPos = varMorp.getCurrPos();
                    varMorp.seekToRightSquareBracket();
                    prePos = varMorp.getCurrPos();
                    sbSql.append(sFieldSql.substring(curPos, prePos - 1));
                }
                aWord = varMorp.getAWord();
            }
            aWord = varMorp.getAWord();
        }
        sbSql.append(sFieldSql.substring(prePos));
        return QueryUtils.splitSqlFieldNames(sbSql.toString());
    }

    public static String trimSqlOrderByField(String sqlOrderBy) {
        if (sqlOrderBy == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Lexer lex = new Lexer(sqlOrderBy, 2);
        boolean haveOrder = false;
        boolean bLastDouHao = false;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (Lexer.isLabel((String)aWord) || StringUtils.isNumeric((CharSequence)aWord)) {
                if (haveOrder) {
                    if (bLastDouHao) {
                        sb.append(",");
                    } else {
                        return null;
                    }
                }
                sb.append(aWord);
                haveOrder = true;
                bLastDouHao = false;
                aWord = lex.getAWord();
                if ("asc".equalsIgnoreCase(aWord) || "desc".equalsIgnoreCase(aWord)) {
                    sb.append(" ").append(aWord);
                    aWord = lex.getAWord();
                }
                if (!"nulls".equalsIgnoreCase(aWord)) continue;
                aWord = lex.getAWord();
                if ("first".equalsIgnoreCase(aWord) || "last".equalsIgnoreCase(aWord)) {
                    sb.append(" nulls ").append(aWord);
                    aWord = lex.getAWord();
                    continue;
                }
                return null;
            }
            if (",".equals(aWord)) {
                if (bLastDouHao) {
                    return null;
                }
                bLastDouHao = true;
                aWord = lex.getAWord();
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    public static Map<String, Object> createSqlParamsMap(Object ... objs) {
        if (objs == null || objs.length < 2) {
            return null;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (int i = 0; i < objs.length / 2; ++i) {
            paramsMap.put(String.valueOf(objs[i * 2]), objs[i * 2 + 1]);
        }
        return paramsMap;
    }

    public static Object scalarPretreatParameter(String pretreatment, Object paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (SQL_PRETREAT_LIKE.equalsIgnoreCase(pretreatment)) {
            return QueryUtils.getMatchString(StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_STARTWITH.equalsIgnoreCase(pretreatment)) {
            return StringBaseOpt.objectToString((Object)paramValue) + "%";
        }
        if (SQL_PRETREAT_ENDWITH.equalsIgnoreCase(pretreatment)) {
            return "%" + StringBaseOpt.objectToString((Object)paramValue);
        }
        if (SQL_PRETREAT_NEXTDAY.equalsIgnoreCase(pretreatment)) {
            return DatetimeOpt.addDays((java.util.Date)DatetimeOpt.truncateToDay((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue)), (int)1);
        }
        if (SQL_PRETREAT_DATE.equalsIgnoreCase(pretreatment)) {
            return DatetimeOpt.truncateToDay((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
        }
        if (SQL_PRETREAT_DATETIME.equalsIgnoreCase(pretreatment)) {
            return DatetimeOpt.castObjectToDate((Object)paramValue);
        }
        if (SQL_PRETREAT_DATESTR.equalsIgnoreCase(pretreatment)) {
            return DatetimeOpt.convertDateToString((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
        }
        if (SQL_PRETREAT_DATETIMESTR.equalsIgnoreCase(pretreatment)) {
            return DatetimeOpt.convertDatetimeToString((java.util.Date)DatetimeOpt.castObjectToDate((Object)paramValue));
        }
        if (SQL_PRETREAT_DIGIT.equalsIgnoreCase(pretreatment)) {
            return StringRegularOpt.trimDigits((String)StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_UPPERCASE.equalsIgnoreCase(pretreatment)) {
            return StringUtils.upperCase((String)StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_LOWERCASE.equalsIgnoreCase(pretreatment)) {
            return StringUtils.lowerCase((String)StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_NUMBER.equalsIgnoreCase(pretreatment)) {
            return StringRegularOpt.trimNumber((String)StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_INTEGER.equalsIgnoreCase(pretreatment) || SQL_PRETREAT_LONG.equalsIgnoreCase(pretreatment)) {
            return NumberBaseOpt.castObjectToLong((Object)paramValue);
        }
        if (SQL_PRETREAT_FLOAT.equalsIgnoreCase(pretreatment)) {
            return NumberBaseOpt.castObjectToDouble((Object)paramValue);
        }
        if (SQL_PRETREAT_ESCAPE_HTML.equalsIgnoreCase(pretreatment)) {
            return StringEscapeUtils.escapeHtml4((String)StringBaseOpt.objectToString((Object)paramValue));
        }
        if (SQL_PRETREAT_QUOTASTR.equalsIgnoreCase(pretreatment)) {
            return QueryUtils.buildStringForQuery(StringBaseOpt.objectToString((Object)paramValue));
        }
        return paramValue;
    }

    public static Object onePretreatParameter(String pretreatment, Object paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (SQL_PRETREAT_STRING.equalsIgnoreCase(pretreatment)) {
            return StringBaseOpt.objectToString((Object)paramValue);
        }
        if (SQL_PRETREAT_SPLITFORIN.equalsIgnoreCase(pretreatment)) {
            String sValue = StringBaseOpt.objectToString((Object)paramValue);
            if (sValue == null) {
                return null;
            }
            return sValue.split(",");
        }
        if (paramValue instanceof Collection) {
            Collection valueList = (Collection)paramValue;
            ArrayList<Object> retValue = new ArrayList<Object>();
            for (Object ov : valueList) {
                Object ro = QueryUtils.scalarPretreatParameter(pretreatment, ov);
                if (ro == null) continue;
                retValue.add(ro);
            }
            if (retValue.size() < 1) {
                return null;
            }
            return retValue;
        }
        if (paramValue instanceof Object[]) {
            Object[] objs = (Object[])paramValue;
            ArrayList<Object> retValue = new ArrayList<Object>();
            for (Object ov : objs) {
                Object ro = QueryUtils.scalarPretreatParameter(pretreatment, ov);
                if (ro == null) continue;
                retValue.add(ro);
            }
            if (retValue.size() < 1) {
                return null;
            }
            return retValue;
        }
        return QueryUtils.scalarPretreatParameter(pretreatment, paramValue);
    }

    public static Object pretreatParameter(String pretreatment, Object paramValue) {
        if (StringUtils.isBlank((CharSequence)pretreatment)) {
            return paramValue;
        }
        if (pretreatment.indexOf(44) < 0) {
            return QueryUtils.onePretreatParameter(pretreatment, paramValue);
        }
        String[] pretreats = pretreatment.split(",");
        Object paramObj = paramValue;
        for (String p : pretreats) {
            paramObj = QueryUtils.onePretreatParameter(p, paramObj);
        }
        return paramObj;
    }

    public static List<String> splitParamString(String paramString) {
        ArrayList<String> params = new ArrayList<String>();
        Lexer lex = new Lexer(paramString, 2);
        int prePos = 0;
        String aWord = lex.getAWord();
        while (aWord != null && !"".equals(aWord)) {
            if (aWord.equals("(")) {
                lex.seekToRightBracket();
            } else if (aWord.equals(",")) {
                int currPos = lex.getCurrPos();
                params.add(paramString.substring(prePos, currPos - 1));
                prePos = currPos;
            }
            aWord = lex.getAWord();
        }
        if (prePos < paramString.length()) {
            params.add(paramString.substring(prePos));
        }
        return params;
    }

    private static ImmutableTriple<String, String, String> parseParameter(String paramString) {
        String paramName;
        String paramPretreatment = null;
        String paramAlias = null;
        int n = paramString.indexOf(58);
        if (n >= 0) {
            String paramRight = paramString.substring(n + 1).trim();
            if (paramRight.charAt(0) == '(') {
                int e = paramRight.indexOf(41);
                if (e > 0) {
                    paramPretreatment = paramRight.substring(1, e).trim();
                    paramAlias = paramRight.substring(e + 1).trim();
                }
            } else {
                paramAlias = paramRight;
            }
            paramName = n > 1 ? paramString.substring(0, n).trim() : paramAlias;
        } else if (paramString.charAt(0) == '(') {
            int e = paramString.indexOf(41);
            if (e > 0) {
                paramPretreatment = paramString.substring(1, e).trim();
                paramAlias = paramString.substring(e + 1).trim();
            }
            paramName = paramAlias;
        } else {
            paramName = paramString;
        }
        return new ImmutableTriple((Object)paramName, paramAlias, paramPretreatment);
    }

    public static QueryAndNamedParams buildInStatement(String paramAlias, Object realParam) {
        StringBuilder hqlPiece = new StringBuilder();
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        if (realParam instanceof Collection) {
            int n = 0;
            for (Object obj : (Collection)realParam) {
                if (n > 0) {
                    hqlPiece.append(",");
                }
                hqlPiece.append(":").append(paramAlias).append('_').append(n);
                hqlAndParams.addParam(paramAlias + "_" + n, obj);
                ++n;
            }
        } else if (realParam instanceof Object[]) {
            int n = 0;
            for (Object obj : (Object[])realParam) {
                if (n > 0) {
                    hqlPiece.append(",");
                }
                hqlPiece.append(":").append(paramAlias).append('_').append(n);
                hqlAndParams.addParam(paramAlias + "_" + n, obj);
                ++n;
            }
        } else {
            hqlPiece.append(":").append(paramAlias);
            hqlAndParams.addParam(paramAlias, realParam);
        }
        hqlAndParams.setQuery(hqlPiece.toString());
        return hqlAndParams;
    }

    public static String cleanSqlStatement(String fieldsSql) {
        if (StringUtils.isBlank((CharSequence)fieldsSql)) {
            return fieldsSql;
        }
        Lexer lex = new Lexer(fieldsSql, 2);
        String aWord = lex.getARegularWord();
        int prePos = 0;
        while (aWord != null && !"".equals(aWord)) {
            int currPos;
            if (aWord.equals(";")) {
                currPos = lex.getCurrPos();
                return fieldsSql.substring(0, currPos - 1);
            }
            if (aWord.equals("--")) {
                currPos = lex.getCurrPos();
                return fieldsSql.substring(0, currPos - 2);
            }
            if (aWord.equals("/*")) {
                currPos = lex.getCurrPos();
                lex.seekToAnnotateEnd();
                int currPos2 = lex.getCurrPos();
                if (!"*/".equals(fieldsSql.substring(currPos2 - 2, currPos2))) {
                    return fieldsSql.substring(0, currPos - 2);
                }
            }
            prePos = lex.getCurrPos();
            aWord = lex.getARegularWord();
        }
        return fieldsSql.substring(0, prePos);
    }

    public static String replaceParamAsSqlString(String sql, String paramAlias, String paramSqlString) {
        Lexer varMorp = new Lexer(sql, 2);
        String sWord = varMorp.getAWord();
        while (sWord != null && !sWord.equals("")) {
            if (":".equals(sWord)) {
                int prePos = varMorp.getCurrPos();
                sWord = varMorp.getAWord();
                if (paramAlias.equals(sWord)) {
                    int curPos = varMorp.getCurrPos();
                    String resSql = "";
                    if (prePos > 1) {
                        resSql = sql.substring(0, prePos - 1);
                    }
                    resSql = resSql + paramSqlString;
                    if (curPos < sql.length()) {
                        resSql = resSql + sql.substring(curPos);
                    }
                    return resSql;
                }
            }
            sWord = varMorp.getAWord();
        }
        return sql;
    }

    public static boolean hasPretreatment(String pretreatStr, String onePretreat) {
        if (pretreatStr == null) {
            return false;
        }
        return pretreatStr.toUpperCase().indexOf(onePretreat) >= 0;
    }

    public static QueryAndNamedParams translateQueryFilter(String filter, IFilterTranslater translater) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        Lexer varMorp = new Lexer(filter, 2);
        StringBuilder hqlPiece = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        while (sWord != null && !sWord.equals("")) {
            int curPos;
            if (sWord.equals("[")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlPiece.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightSquareBracket();
                prePos = varMorp.getCurrPos();
                String columnDesc = filter.substring(curPos, prePos - 1).trim();
                String qp = translater.translateColumn(columnDesc);
                if (qp == null) {
                    return null;
                }
                hqlPiece.append(qp);
            } else if (sWord.equals("{")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlPiece.append(filter.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightBrace();
                prePos = varMorp.getCurrPos();
                String param = filter.substring(curPos, prePos - 1).trim();
                if (StringUtils.isNotBlank((CharSequence)param)) {
                    ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                    String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                    String paramAlias = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle)) ? (String)paramMeta.left : (String)paramMeta.middle;
                    KeyValuePair<String, Object> paramPair = translater.translateParam(paramName);
                    if (paramPair == null) {
                        return null;
                    }
                    if (paramPair.getValue() != null) {
                        Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getValue());
                        if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_CREEPFORIN)) {
                            QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
                            hqlPiece.append(inSt.getQuery());
                            hqlAndParams.addAllParams(inSt.getParams());
                        } else if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_INPLACE)) {
                            hqlPiece.append(QueryUtils.cleanSqlStatement(StringBaseOpt.objectToString((Object)realParam)));
                        } else {
                            hqlPiece.append(":").append(paramAlias);
                            hqlAndParams.addParam(paramAlias, realParam);
                        }
                    } else {
                        hqlPiece.append((String)paramPair.getKey());
                    }
                }
            }
            sWord = varMorp.getAWord();
        }
        hqlPiece.append(filter.substring(prePos));
        hqlAndParams.setQuery(hqlPiece.toString());
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQueryFilter(Collection<String> filters, IFilterTranslater translater, boolean isUnion) {
        if (filters == null || filters.size() < 1) {
            return null;
        }
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        StringBuilder hqlBuilder = new StringBuilder();
        boolean haveSql = false;
        for (String filter : filters) {
            QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter(filter, translater);
            if (hqlPiece == null) continue;
            if (!haveSql) {
                hqlBuilder.append("(");
            } else {
                hqlBuilder.append(isUnion ? " or " : " and ");
            }
            haveSql = true;
            hqlBuilder.append(hqlPiece.getQuery());
            hqlAndParams.addAllParams(hqlPiece.getParams());
        }
        if (haveSql) {
            hqlBuilder.append(" )");
        }
        hqlAndParams.setQuery(hqlBuilder.toString());
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQueryPiece(String queryPiece, IFilterTranslater translater) {
        Lexer varMorp = new Lexer(queryPiece, 2);
        String aWord = varMorp.getARawWord();
        if (aWord == null || aWord.length() == 0) {
            return null;
        }
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        if ("(".equals(aWord)) {
            String sql;
            int curPos = varMorp.getCurrPos();
            if (!varMorp.seekToRightBracket()) {
                return null;
            }
            int prePos = varMorp.getCurrPos();
            String condition = queryPiece.substring(curPos, prePos - 1);
            Object sret = VariableFormula.calculate((String)condition, (VariableTranslate)translater);
            if (!BooleanBaseOpt.castObjectToBoolean((Object)sret).booleanValue()) {
                return null;
            }
            String paramsString = null;
            aWord = varMorp.getARawWord();
            if ("(".equals(aWord)) {
                curPos = varMorp.getCurrPos();
                if (!varMorp.seekToRightBracket()) {
                    return null;
                }
                prePos = varMorp.getCurrPos();
                if (prePos - 1 > curPos) {
                    paramsString = queryPiece.substring(curPos, prePos - 1);
                }
                aWord = varMorp.getARawWord();
            }
            if ("|".equals(aWord)) {
                prePos = varMorp.getCurrPos();
            }
            if (StringUtils.isBlank((CharSequence)(sql = queryPiece.substring(prePos)))) {
                return null;
            }
            if (paramsString != null) {
                List<String> params = QueryUtils.splitParamString(paramsString);
                for (String param : params) {
                    String paramAlias;
                    if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                    ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                    String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                    String string = paramAlias = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle)) ? (String)paramMeta.left : (String)paramMeta.middle;
                    KeyValuePair<String, Object> paramPair = translater.translateParam(paramName);
                    if (paramPair == null || paramPair.getValue() == null) continue;
                    Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getValue());
                    if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_CREEPFORIN)) {
                        QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
                        hqlAndParams.addAllParams(inSt.getParams());
                        sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, inSt.getQuery());
                        continue;
                    }
                    if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_INPLACE)) {
                        sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, QueryUtils.cleanSqlStatement(StringBaseOpt.objectToString((Object)realParam)));
                        continue;
                    }
                    hqlAndParams.addParam(paramAlias, realParam);
                }
                hqlAndParams.setQuery(sql);
            } else {
                hqlAndParams.setQuery(sql);
            }
        } else {
            if (!varMorp.seekTo("|", false)) {
                return null;
            }
            int curPos = varMorp.getCurrPos();
            String sql = queryPiece.substring(curPos);
            if (StringUtils.isBlank((CharSequence)sql)) {
                return null;
            }
            String paramsString = queryPiece.substring(0, curPos - 1);
            if (StringUtils.isBlank((CharSequence)paramsString)) {
                return null;
            }
            List<String> params = QueryUtils.splitParamString(paramsString);
            for (String param : params) {
                if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                ImmutableTriple<String, String, String> paramMeta = QueryUtils.parseParameter(param);
                boolean addParams = !StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.middle));
                String paramName = StringUtils.isBlank((CharSequence)((CharSequence)paramMeta.left)) ? (String)paramMeta.middle : (String)paramMeta.left;
                String paramAlias = addParams ? (String)paramMeta.middle : (String)paramMeta.left;
                KeyValuePair<String, Object> paramPair = translater.translateParam(paramName);
                if (paramPair == null || paramPair.getValue() == null) {
                    return null;
                }
                if (!addParams) continue;
                Object realParam = QueryUtils.pretreatParameter((String)paramMeta.right, paramPair.getValue());
                if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_CREEPFORIN)) {
                    QueryAndNamedParams inSt = QueryUtils.buildInStatement(paramAlias, realParam);
                    hqlAndParams.addAllParams(inSt.getParams());
                    sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, inSt.getQuery());
                }
                if (QueryUtils.hasPretreatment((String)paramMeta.right, SQL_PRETREAT_INPLACE)) {
                    sql = QueryUtils.replaceParamAsSqlString(sql, paramAlias, QueryUtils.cleanSqlStatement(StringBaseOpt.objectToString((Object)realParam)));
                    continue;
                }
                hqlAndParams.addParam(paramAlias, realParam);
            }
            hqlAndParams.setQuery(sql);
        }
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, boolean isUnion, IFilterTranslater translater) {
        QueryAndNamedParams hqlAndParams = new QueryAndNamedParams();
        Lexer varMorp = new Lexer(queryStatement, 2);
        StringBuilder hqlBuilder = new StringBuilder();
        String sWord = varMorp.getAWord();
        int prePos = 0;
        while (sWord != null && !sWord.equals("")) {
            int curPos;
            if (sWord.equals("{")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlBuilder.append(queryStatement.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightBrace();
                prePos = varMorp.getCurrPos();
                String tablesDesc = queryStatement.substring(curPos, prePos - 1).trim();
                String[] tables = tablesDesc.split(",");
                HashMap<String, String> tableMap = new HashMap<String, String>();
                for (String tableDesc : tables) {
                    Lexer tableLexer = new Lexer(tableDesc);
                    String tableName = tableLexer.getAWord();
                    String aliasName = tableLexer.getAWord();
                    if (":".equals(aliasName)) {
                        aliasName = tableLexer.getAWord();
                    }
                    tableMap.put(tableName, aliasName);
                }
                translater.setTableAlias(tableMap);
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryFilter(filters, translater, isUnion);
                if (hqlPiece != null && !StringBaseOpt.isNvl((String)hqlPiece.getQuery())) {
                    hqlBuilder.append(" and ").append(hqlPiece.getQuery());
                    hqlAndParams.addAllParams(hqlPiece.getParams());
                }
            } else if (sWord.equals("[")) {
                curPos = varMorp.getCurrPos();
                if (curPos - 1 > prePos) {
                    hqlBuilder.append(queryStatement.substring(prePos, curPos - 1));
                }
                varMorp.seekToRightSquareBracket();
                prePos = varMorp.getCurrPos();
                String queryPiece = queryStatement.substring(curPos, prePos - 1).trim();
                QueryAndNamedParams hqlPiece = QueryUtils.translateQueryPiece(queryPiece, translater);
                if (hqlPiece != null && !StringBaseOpt.isNvl((String)hqlPiece.getQuery())) {
                    hqlBuilder.append(hqlPiece.getQuery());
                    hqlAndParams.addAllParams(hqlPiece.getParams());
                }
            }
            sWord = varMorp.getAWord();
        }
        hqlBuilder.append(queryStatement.substring(prePos));
        hqlAndParams.setQuery(hqlBuilder.toString());
        return hqlAndParams;
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Collection<String> filters, Map<String, Object> paramsMap, boolean isUnion) {
        return QueryUtils.translateQuery(queryStatement, filters, isUnion, new SimpleFilterTranslater(paramsMap));
    }

    public static QueryAndNamedParams translateQuery(String queryStatement, Map<String, Object> paramsMap) {
        return QueryUtils.translateQuery(queryStatement, null, false, new SimpleFilterTranslater(paramsMap));
    }

    public static QueryAndNamedParams translateQuery(Map<String, String> tableMap, Collection<String> filters, Map<String, Object> paramsMap, boolean isUnion) {
        SimpleFilterTranslater translater = new SimpleFilterTranslater(paramsMap);
        translater.setTableAlias(tableMap);
        return QueryUtils.translateQueryFilter(filters, translater, isUnion);
    }

    public static class SimpleFilterTranslater
    implements IFilterTranslater {
        private Map<String, Object> paramsMap;
        private Map<String, String> tableAlias = null;
        private ObjectTranslate mapTranslate;

        public SimpleFilterTranslater(Map<String, Object> paramsMap) {
            this.paramsMap = paramsMap;
            this.mapTranslate = new ObjectTranslate(paramsMap);
        }

        @Override
        public void setTableAlias(Map<String, String> tableAlias) {
            this.tableAlias = tableAlias;
        }

        @Override
        public String translateColumn(String columnDesc) {
            if (this.tableAlias == null || columnDesc == null || this.tableAlias.size() == 0) {
                return null;
            }
            int n = columnDesc.indexOf(46);
            if (n < 0) {
                return this.tableAlias.get(columnDesc);
            }
            String poClassName = columnDesc.substring(0, n);
            String alias = this.tableAlias.get(poClassName);
            if (alias == null) {
                return null;
            }
            return StringUtils.isBlank((CharSequence)alias) ? columnDesc.substring(n + 1) : alias + '.' + columnDesc.substring(n + 1);
        }

        @Override
        public KeyValuePair<String, Object> translateParam(String paramName) {
            if (this.paramsMap == null) {
                return null;
            }
            Object obj = this.paramsMap.get(paramName);
            if (obj == null) {
                return null;
            }
            if (obj instanceof String && StringUtils.isBlank((CharSequence)((String)obj))) {
                return null;
            }
            return new KeyValuePair((Object)paramName, obj);
        }

        public Object getVarValue(String varName) {
            return this.mapTranslate.getVarValue(varName);
        }

        public Object getLabelValue(String labelName) {
            return this.mapTranslate.getLabelValue(labelName);
        }
    }

    public static interface IFilterTranslater
    extends VariableTranslate {
        public void setTableAlias(Map<String, String> var1);

        public String translateColumn(String var1);

        public KeyValuePair<String, Object> translateParam(String var1);
    }
}

