/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.H2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GeneralJsonObjectDao
implements JsonObjectDao {
    private Connection conn;
    private TableInfo tableInfo;

    public GeneralJsonObjectDao() {
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn, TableInfo tableInfo) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        switch (dbtype) {
            case Oracle: {
                return new OracleJsonObjectDao(conn, tableInfo);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn, tableInfo);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn, tableInfo);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn, tableInfo);
            }
            case H2: {
                return new H2JsonObjectDao(conn, tableInfo);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        switch (dbtype) {
            case Oracle: {
                return new OracleJsonObjectDao(conn);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn);
            }
            case H2: {
                return new H2JsonObjectDao(conn);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public GeneralJsonObjectDao(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public GeneralJsonObjectDao(Connection conn) {
        this.conn = conn;
    }

    public GeneralJsonObjectDao(Connection conn, TableInfo tableInfo) {
        this.conn = conn;
        this.tableInfo = tableInfo;
    }

    public void setConnect(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnect() {
        return this.conn;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public static String buildFieldSql(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, String[]> buildFieldSqlWithFieldName(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        String[] fieldNames = new String[columns.size()];
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            fieldNames[i] = tableField.getPropertyName();
            ++i;
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)fieldNames);
    }

    public static boolean isPkColumn(TableInfo ti, String propertyName) {
        TableField field = ti.findFieldByName(propertyName);
        return ti.getPkColumns().contains(field.getColumnName());
    }

    public static boolean checkHasAllPkColumns(TableInfo tableInfo, Map<String, Object> properties) {
        for (String pkc : tableInfo.getPkColumns()) {
            TableField field = tableInfo.findFieldByColumn(pkc);
            if (field == null || properties.get(field.getPropertyName()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean checkHasAllPkColumns(Map<String, Object> properties) {
        return GeneralJsonObjectDao.checkHasAllPkColumns(this.tableInfo, properties);
    }

    public static String buildFilterSqlByPk(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String plCol : ti.getPkColumns()) {
            if (i > 0) {
                sBuilder.append(" and ");
            }
            TableField col = ti.findFieldByColumn(plCol);
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName()).append(" = :").append(col.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildFilterSql(TableInfo ti, String alias, Collection<String> properties) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String plCol : properties) {
            TableField col = ti.findFieldByName(plCol);
            if (col == null) continue;
            if (i > 0) {
                sBuilder.append(" and ");
            }
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName()).append(" = :").append(col.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, String[]> buildGetObjectSqlByPk(TableInfo ti) {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(ti, null);
        String filter = GeneralJsonObjectDao.buildFilterSqlByPk(ti, null);
        return new ImmutablePair((Object)("select " + (String)q.getLeft() + " from " + ti.getTableName() + " where " + filter), q.getRight());
    }

    @Override
    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        if (this.tableInfo.getPkColumns() == null || this.tableInfo.getPkColumns().size() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(this.tableInfo);
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), CollectionsOpt.createHashMap((Object[])new Object[]{this.tableInfo.getPkColumns().get(0), keyValue}), (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONObject getObjectById(Map<String, Object> keyValues) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(keyValues)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(this.tableInfo);
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), keyValues, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(this.tableInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, "select " + (String)q.getLeft() + " from " + this.tableInfo.getTableName() + " where " + filter, properties, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(this.tableInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)this.tableInfo.getOrderBy())) {
            sql = sql + " order by " + this.tableInfo.getOrderBy();
        }
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sql, properties, (String[])q.getRight());
    }

    @Override
    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select count(*) as rs from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, sql, properties);
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    public static String buildInsertSql(TableInfo ti, Collection<String> fields) {
        StringBuilder sbInsert = new StringBuilder("insert into ");
        sbInsert.append(ti.getTableName()).append(" ( ");
        StringBuilder sbValues = new StringBuilder(" ) values ( ");
        int i = 0;
        for (String f : fields) {
            if (i > 0) {
                sbInsert.append(", ");
                sbValues.append(", ");
            }
            TableField col = ti.findFieldByName(f);
            sbInsert.append(col.getColumnName());
            sbValues.append(":").append(f);
            ++i;
        }
        return sbInsert.append((CharSequence)sbValues).append(")").toString();
    }

    @Override
    public int saveNewObject(Map<String, Object> object) throws SQLException {
        String sql = GeneralJsonObjectDao.buildInsertSql(this.tableInfo, object.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    public static String buildUpdateSql(TableInfo ti, Collection<String> fields, boolean exceptPk) {
        StringBuilder sbUpdate = new StringBuilder("update ");
        sbUpdate.append(ti.getTableName()).append(" set ");
        int i = 0;
        for (String f : fields) {
            if (exceptPk && GeneralJsonObjectDao.isPkColumn(ti, f)) continue;
            if (i > 0) {
                sbUpdate.append(", ");
            }
            TableField col = ti.findFieldByName(f);
            sbUpdate.append(col.getColumnName());
            sbUpdate.append(" = :").append(f);
            ++i;
        }
        return sbUpdate.toString();
    }

    @Override
    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields, true) + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    @Override
    public int updateObject(Map<String, Object> object) throws SQLException {
        return this.updateObject(object.keySet(), object);
    }

    @Override
    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select count(*) as checkExists from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        Long checkExists = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery(this.conn, sql, object));
        if (checkExists == null || checkExists.intValue() == 0) {
            return this.saveNewObject(object);
        }
        if (checkExists.intValue() == 1) {
            return this.updateObject(fields, object);
        }
        throw new SQLException("\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    @Override
    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.mergeObject(object.keySet(), object);
    }

    @Override
    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields, true) + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(fieldValues);
        paramMap.putAll(properties);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, paramMap);
    }

    @Override
    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.updateObjectsByProperties(fieldValues.keySet(), fieldValues, properties);
    }

    @Override
    public int deleteObjectById(Object keyValue) throws SQLException {
        if (this.tableInfo.getPkColumns() == null || this.tableInfo.getPkColumns().size() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, CollectionsOpt.createHashMap((Object[])new Object[]{this.tableInfo.getPkColumns().get(0), keyValue}));
    }

    @Override
    public int deleteObjectById(Map<String, Object> keyValues) throws SQLException {
        if (!this.checkHasAllPkColumns(keyValues)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, keyValues);
    }

    @Override
    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, properties);
    }

    @Override
    public int insertObjectsAsTabulation(JSONArray objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.saveNewObject((Map<String, Object>)((JSONObject)object));
        }
        return resN;
    }

    @Override
    public int deleteObjects(JSONArray objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.deleteObjectById((Map<String, Object>)((JSONObject)object));
        }
        return resN;
    }

    @Override
    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Override
    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return this.deleteObjectsByProperties(properties);
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, JSONArray dbObjects) throws SQLException {
        Triple comRes = CollectionsOpt.compareTwoList((List)dbObjects, (List)newObjects, (Comparator)new JSONObjectComparator(this.tableInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Object obj : (List)comRes.getLeft()) {
                resN += this.saveNewObject((Map<String, Object>)((JSONObject)obj));
            }
        }
        if (comRes.getRight() != null) {
            for (Object obj : (List)comRes.getRight()) {
                resN += this.deleteObjectById((Map<String, Object>)((JSONObject)obj));
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                resN += this.updateObject((Map<String, Object>)((JSONObject)pobj.getRight()));
            }
        }
        return resN;
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
        return this.replaceObjectsAsTabulation(newObjects, dbObjects);
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, Map<String, Object> properties) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(properties);
        return this.replaceObjectsAsTabulation(newObjects, dbObjects);
    }

    public Long getSimulateSequenceNextValue(String sequenceName) throws SQLException, IOException {
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT count(*) hasValue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        Long l = NumberBaseOpt.castObjectToLong((Object)object);
        if (l == 0L) {
            DatabaseAccess.doExecuteSql(this.conn, "insert into simulate_sequence(seqname,currvalue,increment) values(?,?,1)", new Object[]{sequenceName, 1});
            return 1L;
        }
        DatabaseAccess.doExecuteSql(this.conn, "update simulate_sequence currvalue = currvalue + increment where seqname= ?", new Object[]{sequenceName});
        object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT currvalue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsBySql(this.conn, sSql, values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSql(this.conn, sSql, values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public boolean doExecuteSql(String sSql) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql);
    }

    @Override
    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql, values);
    }

    @Override
    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return DatabaseAccess.doExecuteNamedSql(this.conn, sSql, values);
    }

    public class JSONObjectComparator
    implements Comparator<Object> {
        private TableInfo tableInfo;

        public JSONObjectComparator(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public int compare(Object o1, Object o2) {
            for (String pkc : this.tableInfo.getPkColumns()) {
                String s2;
                TableField field = this.tableInfo.findFieldByColumn(pkc);
                Object f1 = ((JSONObject)o1).get((Object)field.getPropertyName());
                Object f2 = ((JSONObject)o2).get((Object)field.getPropertyName());
                if (f1 == null) {
                    if (f2 == null) continue;
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                if (ReflectionOpt.isNumberType(f1.getClass()) && ReflectionOpt.isNumberType(f2.getClass())) {
                    double db2;
                    double db1 = ((Number)f1).doubleValue();
                    if (db1 > (db2 = ((Number)f2).doubleValue())) {
                        return 1;
                    }
                    if (!(db1 < db2)) continue;
                    return -1;
                }
                String s1 = StringBaseOpt.objectToString((Object)f1);
                int nc = s1.compareTo(s2 = StringBaseOpt.objectToString((Object)f2));
                if (nc == 0) continue;
                return nc;
            }
            return 0;
        }
    }
}

