/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.orm.JpaMetadata;
import com.centit.support.database.orm.OrmUtils;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrmDaoUtils {
    private static final Logger logger = LoggerFactory.getLogger(OrmDaoUtils.class);

    private OrmDaoUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Long getSequenceNextValue(Connection connection, String sequenceName) {
        try {
            return GeneralJsonObjectDao.createJsonObjectDao(connection).getSequenceNextValue(sequenceName);
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static JsonObjectDao getJsonObjectDao(Connection connection, TableMapInfo mapInfo) {
        try {
            return GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int saveNewObject(Connection connection, T object) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            object = OrmUtils.prepareObjectForInsert(object, mapInfo, sqlDialect);
            return sqlDialect.saveNewObject(OrmUtils.fetchObjectDatabaseField(object, mapInfo));
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int updateObject(Connection connection, T object) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            object = OrmUtils.prepareObjectForUpdate(object, mapInfo, sqlDialect);
            return sqlDialect.updateObject(OrmUtils.fetchObjectDatabaseField(object, mapInfo));
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int updateObject(Connection connection, Collection<String> fields, T object) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            object = OrmUtils.prepareObjectForUpdate(object, mapInfo, sqlDialect);
            return sqlDialect.updateObject(fields, OrmUtils.fetchObjectDatabaseField(object, mapInfo));
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int batchUpdateObject(Connection connection, Collection<String> fields, T object, Map<String, Object> propertiesFilter) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            object = OrmUtils.prepareObjectForUpdate(object, mapInfo, sqlDialect);
            return sqlDialect.updateObjectsByProperties(fields, OrmUtils.fetchObjectDatabaseField(object, mapInfo), propertiesFilter);
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static int batchUpdateObject(Connection connection, Class<?> type, Map<String, Object> propertiesValue, Map<String, Object> propertiesFilter) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            return sqlDialect.updateObjectsByProperties(propertiesValue.keySet(), propertiesValue, propertiesFilter);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int mergeObject(Connection connection, T object) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            object = OrmUtils.prepareObjectForMerge(object, mapInfo, sqlDialect);
            return sqlDialect.mergeObject(OrmUtils.fetchObjectDatabaseField(object, mapInfo));
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private static final <T> T queryParamsSql(Connection conn, QueryAndParams sqlAndParams, FetchDataWork<T> fetchDataWork) throws PersistenceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final <T> T queryParamsSql(Connection conn, QueryAndParams sqlAndParams, int startPos, int maxSize, FetchDataWork<T> fetchDataWork) throws PersistenceException {
        sqlAndParams.setQuery(QueryUtils.buildLimitQuerySQL(sqlAndParams.getQuery(), startPos, maxSize, false, DBType.mapDBType(conn)));
        return OrmDaoUtils.queryParamsSql(conn, sqlAndParams, fetchDataWork);
    }

    private static <T> T queryNamedParamsSql(Connection conn, QueryAndNamedParams sqlAndParams, FetchDataWork<T> fetchDataWork) throws PersistenceException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(sqlAndParams);
        return OrmDaoUtils.queryParamsSql(conn, qap, fetchDataWork);
    }

    private static <T> T queryNamedParamsSql(Connection conn, QueryAndNamedParams sqlAndParams, int startPos, int maxSize, FetchDataWork<T> fetchDataWork) throws PersistenceException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(sqlAndParams);
        return OrmDaoUtils.queryParamsSql(conn, qap, startPos, maxSize, fetchDataWork);
    }

    public static <T> T getObjectBySql(Connection connection, String sql, Map<String, Object> properties, Class<T> type) throws PersistenceException {
        return (T)OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, properties), rs -> OrmUtils.fetchObjectFormResultSet(rs, type));
    }

    public static <T> T getObjectById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(mapInfo);
        if (ReflectionOpt.isScalarType(id.getClass())) {
            if (mapInfo.getPkColumns() == null || mapInfo.getPkColumns().size() != 1) {
                throw new PersistenceException(14, "\u8868" + mapInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
            }
            return OrmDaoUtils.getObjectBySql(connection, (String)q.getKey(), CollectionsOpt.createHashMap((Object[])new Object[]{mapInfo.getPkColumns().get(0), id}), type);
        }
        Map<String, Object> idObj = OrmUtils.fetchObjectField(id);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, idObj)) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        return OrmDaoUtils.getObjectBySql(connection, (String)q.getKey(), idObj, type);
    }

    public static <T> T getObjectIncludeLazyById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        String sql = "select " + mapInfo.buildFieldIncludeLazySql("") + " from " + mapInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(mapInfo, null);
        if (ReflectionOpt.isScalarType(id.getClass())) {
            if (mapInfo.getPkColumns() == null || mapInfo.getPkColumns().size() != 1) {
                throw new PersistenceException(14, "\u8868" + mapInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
            }
            return OrmDaoUtils.getObjectBySql(connection, sql, CollectionsOpt.createHashMap((Object[])new Object[]{mapInfo.getPkColumns().get(0), id}), type);
        }
        Map<String, Object> idObj = OrmUtils.fetchObjectField(id);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, idObj)) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        return OrmDaoUtils.getObjectBySql(connection, sql, idObj, type);
    }

    public static <T> T getObjectCascadeShallowById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        T object = OrmDaoUtils.getObjectById(connection, id, type);
        OrmDaoUtils.fetchObjectReferences(connection, object);
        return object;
    }

    public static <T> T getObjectCascadeById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        T object = OrmDaoUtils.getObjectById(connection, id, type);
        OrmDaoUtils.fetchObjectReferencesCascade(connection, object, type);
        return object;
    }

    private static int deleteObjectById(Connection connection, Map<String, Object> id, TableMapInfo mapInfo) throws PersistenceException {
        try {
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            return sqlDialect.deleteObjectById(id);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int deleteObjectById(Connection connection, Map<String, Object> id, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        return OrmDaoUtils.deleteObjectById(connection, id, mapInfo);
    }

    public static <T> int deleteObject(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        Map<String, Object> idMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        return OrmDaoUtils.deleteObjectById(connection, idMap, mapInfo);
    }

    public static <T> int deleteObjectById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        if (ReflectionOpt.isScalarType(id.getClass())) {
            if (mapInfo.getPkColumns() == null || mapInfo.getPkColumns().size() != 1) {
                throw new PersistenceException(14, "\u8868" + mapInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
            }
            return OrmDaoUtils.deleteObjectById(connection, (Map<String, Object>)CollectionsOpt.createHashMap((Object[])new Object[]{mapInfo.getPkColumns().get(0), id}), mapInfo);
        }
        Map<String, Object> idObj = OrmUtils.fetchObjectField(id);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, idObj)) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        return OrmDaoUtils.deleteObjectById(connection, idObj, mapInfo);
    }

    public static <T> T getObjectByProperties(Connection connection, Map<String, Object> properties, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(mapInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(mapInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + mapInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        return (T)OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, properties), rs -> OrmUtils.fetchObjectFormResultSet(rs, type));
    }

    public static <T> List<T> listAllObjects(Connection connection, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(mapInfo, null);
        String sql = "select " + (String)q.getLeft() + " from " + mapInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)mapInfo.getOrderBy())) {
            sql = sql + " order by " + mapInfo.getOrderBy();
        }
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, new HashMap<String, Object>(1)), rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> listObjectsByProperties(Connection connection, Map<String, Object> properties, Class<T> type) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(mapInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(mapInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + mapInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)mapInfo.getOrderBy())) {
            sql = sql + " order by " + mapInfo.getOrderBy();
        }
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, properties), rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> listObjectsByProperties(Connection connection, Map<String, Object> properties, Class<T> type, int startPos, int maxSize) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(mapInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(mapInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + mapInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)mapInfo.getOrderBy())) {
            sql = sql + " order by " + mapInfo.getOrderBy();
        }
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, properties), startPos, maxSize, rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsBySql(Connection connection, String sql, Class<T> type) throws PersistenceException {
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, new HashMap<String, Object>()), rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsByParamsSql(Connection connection, String sql, Object[] params, Class<T> type) throws PersistenceException {
        return OrmDaoUtils.queryParamsSql(connection, new QueryAndParams(sql, params), rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsByNamedParamsSql(Connection connection, String sql, Map<String, Object> params, Class<T> type) throws PersistenceException {
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, params), rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsBySql(Connection connection, String sql, Class<T> type, int startPos, int maxSize) throws PersistenceException {
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, new HashMap<String, Object>()), startPos, maxSize, rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsByParamsSql(Connection connection, String sql, Object[] params, Class<T> type, int startPos, int maxSize) throws PersistenceException {
        return OrmDaoUtils.queryParamsSql(connection, new QueryAndParams(sql, params), startPos, maxSize, rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> List<T> queryObjectsByNamedParamsSql(Connection connection, String sql, Map<String, Object> params, Class<T> type, int startPos, int maxSize) throws PersistenceException {
        return OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, params), startPos, maxSize, rs -> OrmUtils.fetchObjectListFormResultSet(rs, type));
    }

    public static <T> T fetchObjectLazyColumn(Connection connection, T object, String columnName) throws PersistenceException {
        Map<String, Object> idMap;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, idMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo))) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select " + mapInfo.findFieldByName(columnName).getColumnName() + " from " + mapInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(mapInfo, null);
        return (T)OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, idMap), rs -> OrmUtils.fetchFieldsFormResultSet(rs, object, mapInfo));
    }

    public static <T> T fetchObjectLazyColumns(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        String fieldSql = mapInfo.buildLazyFieldSql(null);
        if (fieldSql == null) {
            return object;
        }
        Map<String, Object> idMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, idMap)) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select " + fieldSql + " from " + mapInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(mapInfo, null);
        return (T)OrmDaoUtils.queryNamedParamsSql(connection, new QueryAndNamedParams(sql, idMap), rs -> OrmUtils.fetchFieldsFormResultSet(rs, object, mapInfo));
    }

    private static <T> T fetchObjectReference(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo, boolean casecade) throws PersistenceException {
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return object;
        }
        Class<?> refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo(refType);
        if (refMapInfo == null) {
            return object;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
            properties.put(ent.getValue(), ReflectionOpt.getFieldValue(object, (String)ent.getKey()));
        }
        List<?> refs = OrmDaoUtils.listObjectsByProperties(connection, properties, refType);
        if (refs != null && refs.size() > 0) {
            if (casecade) {
                for (Object refObject : refs) {
                    OrmDaoUtils.fetchObjectReferencesCascade(connection, refObject, refType);
                }
            }
            if (ref.getReferenceType().isAssignableFrom(refType)) {
                ref.setObjectFieldValue(object, refs.get(0));
            } else if (Set.class.isAssignableFrom(ref.getReferenceType())) {
                ref.setObjectFieldValue(object, new HashSet(refs));
            } else if (List.class.isAssignableFrom(ref.getReferenceType())) {
                ref.setObjectFieldValue(object, refs);
            }
        }
        return object;
    }

    private static <T> T fetchObjectReference(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo) throws PersistenceException {
        return OrmDaoUtils.fetchObjectReference(connection, object, ref, mapInfo, false);
    }

    private static <T> T fetchObjectReferenceCascade(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo) throws PersistenceException {
        return OrmDaoUtils.fetchObjectReference(connection, object, ref, mapInfo, true);
    }

    private static <T> T fetchObjectReferencesCascade(Connection connection, T object, Class<?> objType) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                OrmDaoUtils.fetchObjectReferenceCascade(connection, object, ref, mapInfo);
            }
        }
        return object;
    }

    public static <T> T fetchObjectReference(Connection connection, T object, String reference) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        SimpleTableReference ref = mapInfo.findReference(reference);
        return OrmDaoUtils.fetchObjectReference(connection, object, ref, mapInfo);
    }

    public static <T> T fetchObjectReferences(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                OrmDaoUtils.fetchObjectReference(connection, object, ref, mapInfo);
            }
        }
        return object;
    }

    public static <T> int deleteObjectByProperties(Connection connection, Map<String, Object> properties, Class<T> type) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            return sqlDialect.deleteObjectsByProperties(properties);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int deleteObjectReference(Connection connection, T object, SimpleTableReference ref) throws PersistenceException {
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Class<?> refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo(refType);
        if (refMapInfo == null) {
            return 0;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
            properties.put(ent.getValue(), ReflectionOpt.getFieldValue(object, (String)ent.getKey()));
        }
        return OrmDaoUtils.deleteObjectByProperties(connection, properties, refType);
    }

    public static <T> int deleteObjectReference(Connection connection, T object, String reference) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        SimpleTableReference ref = mapInfo.findReference(reference);
        return OrmDaoUtils.deleteObjectReference(connection, object, ref);
    }

    public static <T> int deleteObjectReferences(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        int n = 0;
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                n += OrmDaoUtils.deleteObjectReference(connection, object, ref);
            }
        }
        return n;
    }

    public static <T> int deleteObjectCascadeShallow(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        Map<String, Object> idMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                OrmDaoUtils.deleteObjectReference(connection, object, ref);
            }
        }
        return OrmDaoUtils.deleteObjectById(connection, idMap, mapInfo);
    }

    public static <T> int deleteObjectCascade(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        Map<String, Object> idMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo);
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                HashMap<String, Object> properties = new HashMap<String, Object>(6);
                Class<?> refType = ref.getTargetEntityType();
                for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
                    properties.put(ent.getValue(), ReflectionOpt.getFieldValue(object, (String)ent.getKey()));
                }
                List<?> refs = OrmDaoUtils.listObjectsByProperties(connection, properties, refType);
                for (Object refObject : refs) {
                    OrmDaoUtils.deleteObjectCascade(connection, refObject);
                }
            }
        }
        return OrmDaoUtils.deleteObject(connection, object);
    }

    public static <T> int deleteObjectCascadeShallowById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        return OrmDaoUtils.deleteObjectCascadeShallow(connection, OrmDaoUtils.getObjectById(connection, id, type));
    }

    public static <T> int deleteObjectCascadeById(Connection connection, Object id, Class<T> type) throws PersistenceException {
        return OrmDaoUtils.deleteObjectCascade(connection, OrmDaoUtils.getObjectById(connection, id, type));
    }

    public static <T> int replaceObjectsAsTabulation(Connection connection, List<T> dbObjects, List<T> newObjects) throws PersistenceException {
        if (newObjects == null || newObjects.size() == 0) {
            if (dbObjects == null || dbObjects.size() == 0) {
                return 0;
            }
            for (T obj : dbObjects) {
                OrmDaoUtils.deleteObject(connection, obj);
            }
            return dbObjects.size();
        }
        Class<?> objType = newObjects.get(0).getClass();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(objType);
        Triple comRes = CollectionsOpt.compareTwoList(dbObjects, newObjects, new OrmObjectComparator(mapInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Object obj : (List)comRes.getLeft()) {
                resN += OrmDaoUtils.saveNewObject(connection, obj);
            }
        }
        if (comRes.getRight() != null) {
            for (Object obj : (List)comRes.getRight()) {
                resN += OrmDaoUtils.deleteObject(connection, obj);
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                resN += OrmDaoUtils.updateObject(connection, pobj.getRight());
            }
        }
        return resN;
    }

    public static <T> int replaceObjectsAsTabulation(Connection connection, List<T> newObjects, String propertyName, Object propertyValue) throws PersistenceException {
        return OrmDaoUtils.replaceObjectsAsTabulation(connection, newObjects, CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    public static <T> int replaceObjectsAsTabulation(Connection connection, List<T> newObjects, Map<String, Object> properties) throws PersistenceException {
        if (newObjects == null || newObjects.size() < 1) {
            return 0;
        }
        Class<?> objType = newObjects.iterator().next().getClass();
        List<?> dbObjects = OrmDaoUtils.listObjectsByProperties(connection, properties, objType);
        return OrmDaoUtils.replaceObjectsAsTabulation(connection, dbObjects, newObjects);
    }

    private static <T> int saveNewObjectReferenceCascade(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo) throws PersistenceException {
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Object newObj = ref.getObjectFieldValue(object);
        if (newObj == null) {
            return 0;
        }
        Class<?> refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo(refType);
        if (refMapInfo == null) {
            return 0;
        }
        if (ref.getReferenceType().isAssignableFrom(refType)) {
            for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.findFieldByName(ent.getKey()).getObjectFieldValue(object);
                refMapInfo.findFieldByName(ent.getValue()).setObjectFieldValue(newObj, obj);
            }
            OrmDaoUtils.saveNewObjectCascade(connection, newObj);
        } else if (newObj instanceof Collection) {
            for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.findFieldByName(ent.getKey()).getObjectFieldValue(object);
                for (Object subObj : (Collection)newObj) {
                    refMapInfo.findFieldByName(ent.getValue()).setObjectFieldValue(subObj, obj);
                }
            }
            for (Map.Entry<String, String> subObj : (Collection)newObj) {
                OrmDaoUtils.saveNewObjectCascade(connection, subObj);
            }
        }
        return 1;
    }

    private static <T> int saveObjectReference(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo) throws PersistenceException {
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Object newObj = ref.getObjectFieldValue(object);
        if (newObj == null) {
            return OrmDaoUtils.deleteObjectReference(connection, object, ref);
        }
        Class<?> refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo(refType);
        if (refMapInfo == null) {
            return 0;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, String> entry : ref.getReferenceColumns().entrySet()) {
            properties.put(entry.getValue(), ReflectionOpt.getFieldValue(object, (String)entry.getKey()));
        }
        List<?> refs = OrmDaoUtils.listObjectsByProperties(connection, properties, refType);
        if (ref.getReferenceType().isAssignableFrom(refType)) {
            for (Map.Entry<String, String> entry : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.findFieldByName(entry.getKey()).getObjectFieldValue(object);
                refMapInfo.findFieldByName(entry.getValue()).setObjectFieldValue(newObj, obj);
            }
            if (refs != null && refs.size() > 0) {
                OrmDaoUtils.updateObject(connection, newObj);
            } else {
                OrmDaoUtils.saveNewObject(connection, newObj);
            }
        } else {
            List list = Set.class.isAssignableFrom(ref.getReferenceType()) ? new ArrayList((Set)newObj) : (List)newObj;
            for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
                Object obj = mapInfo.findFieldByName(ent.getKey()).getObjectFieldValue(object);
                for (Object subObj : list) {
                    refMapInfo.findFieldByName(ent.getValue()).setObjectFieldValue(subObj, obj);
                }
            }
            OrmDaoUtils.replaceObjectsAsTabulation(connection, refs, list);
        }
        return 1;
    }

    public static <T> int saveObjectReference(Connection connection, T object, String reference) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        SimpleTableReference ref = mapInfo.findReference(reference);
        return OrmDaoUtils.saveObjectReference(connection, object, ref, mapInfo);
    }

    public static <T> int saveObjectReferences(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        int n = 0;
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                n += OrmDaoUtils.saveObjectReference(connection, object, ref, mapInfo);
            }
        }
        return n;
    }

    public static <T> int saveNewObjectCascadeShallow(Connection connection, T object) throws PersistenceException {
        return OrmDaoUtils.saveNewObject(connection, object) + OrmDaoUtils.saveObjectReferences(connection, object);
    }

    public static <T> int saveNewObjectCascade(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        int n = OrmDaoUtils.saveNewObject(connection, object);
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                n += OrmDaoUtils.saveNewObjectReferenceCascade(connection, object, ref, mapInfo);
            }
        }
        return n;
    }

    public static <T> int updateObjectCascadeShallow(Connection connection, T object) throws PersistenceException {
        return OrmDaoUtils.updateObject(connection, object) + OrmDaoUtils.saveObjectReferences(connection, object);
    }

    private static <T> int replaceObjectsAsTabulationCascade(Connection connection, List<T> dbObjects, List<T> newObjects) throws PersistenceException {
        if (newObjects == null || newObjects.size() == 0) {
            if (dbObjects == null || dbObjects.size() == 0) {
                return 0;
            }
            for (T obj : dbObjects) {
                OrmDaoUtils.deleteObjectCascade(connection, obj);
            }
            return dbObjects.size();
        }
        Class<?> objType = newObjects.get(0).getClass();
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(objType);
        Triple comRes = CollectionsOpt.compareTwoList(dbObjects, newObjects, new OrmObjectComparator(mapInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Object obj : (List)comRes.getLeft()) {
                resN += OrmDaoUtils.saveNewObjectCascade(connection, obj);
            }
        }
        if (comRes.getRight() != null) {
            for (Object obj : (List)comRes.getRight()) {
                resN += OrmDaoUtils.deleteObjectCascade(connection, obj);
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                resN += OrmDaoUtils.updateObjectCascade(connection, pobj.getRight());
            }
        }
        return resN;
    }

    private static <T> int updateObjectReferenceCascade(Connection connection, T object, SimpleTableReference ref, TableMapInfo mapInfo) throws PersistenceException {
        if (ref == null || ref.getReferenceColumns().size() < 1) {
            return 0;
        }
        Object newObj = ref.getObjectFieldValue(object);
        Class<?> refType = ref.getTargetEntityType();
        TableMapInfo refMapInfo = JpaMetadata.fetchTableMapInfo(refType);
        if (refMapInfo == null) {
            return 0;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(6);
        for (Map.Entry<String, String> ent : ref.getReferenceColumns().entrySet()) {
            properties.put(ent.getValue(), ReflectionOpt.getFieldValue(object, (String)ent.getKey()));
        }
        int n = 0;
        List<?> refs = OrmDaoUtils.listObjectsByProperties(connection, properties, refType);
        if (newObj == null) {
            if (refs != null && refs.size() > 0) {
                if (ref.getReferenceType().isAssignableFrom(refType)) {
                    n += OrmDaoUtils.deleteObjectCascade(connection, refs.get(0));
                } else {
                    for (Object subObj : refs) {
                        n += OrmDaoUtils.deleteObjectCascade(connection, subObj);
                    }
                }
            }
            return n;
        }
        if (ref.getReferenceType().isAssignableFrom(refType)) {
            if (refs != null && refs.size() > 0) {
                OrmDaoUtils.updateObjectCascade(connection, newObj);
            } else {
                OrmDaoUtils.saveNewObjectCascade(connection, newObj);
            }
        } else if (Set.class.isAssignableFrom(ref.getReferenceType())) {
            OrmDaoUtils.replaceObjectsAsTabulationCascade(connection, refs, new ArrayList((Set)newObj));
        } else if (List.class.isAssignableFrom(ref.getReferenceType())) {
            OrmDaoUtils.replaceObjectsAsTabulationCascade(connection, refs, (List)newObj);
        }
        return 1;
    }

    public static <T> int updateObjectCascade(Connection connection, T object) throws PersistenceException {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        int n = OrmDaoUtils.updateObject(connection, object);
        if (mapInfo.hasReferences()) {
            for (SimpleTableReference ref : mapInfo.getReferences()) {
                n += OrmDaoUtils.updateObjectReferenceCascade(connection, object, ref, mapInfo);
            }
        }
        return n;
    }

    public static <T> int checkObjectExists(Connection connection, T object) throws PersistenceException {
        Map<String, Object> objectMap;
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
        if (!GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, objectMap = OrmUtils.fetchObjectDatabaseField(object, mapInfo))) {
            throw new PersistenceException(14, "\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select count(*) as checkExists from " + mapInfo.getTableName() + " where " + GeneralJsonObjectDao.checkHasAllPkColumns(mapInfo, null);
        try {
            Long checkExists = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery(connection, sql, objectMap));
            return checkExists == null ? 0 : checkExists.intValue();
        }
        catch (SQLException e) {
            throw new PersistenceException(sql, e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int fetchObjectsCount(Connection connection, Map<String, Object> properties, Class<T> type) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            return sqlDialect.fetchObjectsCount(properties).intValue();
        }
        catch (IOException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int fetchObjectsCount(Connection connection, String sql, Map<String, Object> properties) throws PersistenceException {
        try {
            return NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.getScalarObjectQuery(connection, sql, properties));
        }
        catch (SQLException e) {
            throw new PersistenceException(sql, e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private static <T> T prepareObjectForMerge(Connection connection, T object) throws PersistenceException {
        try {
            TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(object.getClass());
            GeneralJsonObjectDao sqlDialect = GeneralJsonObjectDao.createJsonObjectDao(connection, mapInfo);
            return OrmUtils.prepareObjectForMerge(object, mapInfo, sqlDialect);
        }
        catch (IOException | NoSuchFieldException | SQLException e) {
            throw new PersistenceException(e);
        }
    }

    public static <T> int mergeObjectCascadeShallow(Connection connection, T object) throws PersistenceException {
        int checkExists = OrmDaoUtils.checkObjectExists(connection, object = OrmDaoUtils.prepareObjectForMerge(connection, object));
        if (checkExists == 0) {
            return OrmDaoUtils.saveNewObjectCascadeShallow(connection, object);
        }
        if (checkExists == 1) {
            return OrmDaoUtils.updateObjectCascadeShallow(connection, object);
        }
        throw new PersistenceException(14, "\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    public static <T> int mergeObjectCascade(Connection connection, T object) throws PersistenceException {
        int checkExists = OrmDaoUtils.checkObjectExists(connection, object = OrmDaoUtils.prepareObjectForMerge(connection, object));
        if (checkExists == 0) {
            return OrmDaoUtils.saveNewObjectCascade(connection, object);
        }
        if (checkExists == 1) {
            return OrmDaoUtils.updateObjectCascade(connection, object);
        }
        throw new PersistenceException(14, "\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    public static class OrmObjectComparator<T>
    implements Comparator<T> {
        private TableInfo tableInfo;

        public OrmObjectComparator(TableMapInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public int compare(T o1, T o2) {
            for (String pkc : this.tableInfo.getPkColumns()) {
                String s2;
                Object f1 = ReflectionOpt.getFieldValue(o1, (String)pkc);
                Object f2 = ReflectionOpt.getFieldValue(o2, (String)pkc);
                if (f1 == null) {
                    if (f2 == null) continue;
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                if (ReflectionOpt.isNumberType(f1.getClass())) {
                    double db2;
                    double db1 = ((Number)f1).doubleValue();
                    if (db1 > (db2 = ((Number)f2).doubleValue())) {
                        return 1;
                    }
                    if (!(db1 < db2)) continue;
                    return -1;
                }
                String s1 = StringBaseOpt.objectToString((Object)f1);
                int nc = s1.compareTo(s2 = StringBaseOpt.objectToString((Object)f2));
                if (nc == 0) continue;
                return nc;
            }
            return 0;
        }
    }

    public static interface FetchDataWork<T> {
        public T execute(ResultSet var1) throws SQLException, IOException, NoSuchFieldException, InstantiationException, IllegalAccessException;
    }
}

