/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database;

import com.centit.support.database.DataSourceDescription;
import com.centit.support.database.DbcpConnect;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpConnectPools {
    protected static final Logger logger = LoggerFactory.getLogger(DbcpConnectPools.class);
    private static final Map<DataSourceDescription, BasicDataSource> dbcpDataSourcePools = new HashMap<DataSourceDescription, BasicDataSource>();

    private static synchronized BasicDataSource addDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setUrl(dsDesc.getConnUrl());
        ds.setInitialSize(dsDesc.getInitialSize());
        ds.setMaxTotal(dsDesc.getMaxTotal());
        ds.setMaxIdle(dsDesc.getMaxIdle());
        ds.setMaxWaitMillis((long)dsDesc.getMaxWaitMillis());
        ds.setMinIdle(dsDesc.getMinIdle());
        dbcpDataSourcePools.put(dsDesc, ds);
        return ds;
    }

    public static synchronized BasicDataSource getDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.addDataSource(dsDesc);
        }
        return ds;
    }

    public static synchronized DbcpConnect getDbcpConnect(DataSourceDescription dsDesc) throws SQLException {
        BasicDataSource ds = dbcpDataSourcePools.get(dsDesc);
        if (ds == null) {
            ds = DbcpConnectPools.addDataSource(dsDesc);
        }
        Connection conn = null;
        conn = ds.getConnection();
        conn.setAutoCommit(false);
        return new DbcpConnect(dsDesc.getDatabaseCode(), conn);
    }

    public static Map<String, Integer> getDataSourceStats(DataSourceDescription dsDesc) {
        BasicDataSource bds = dbcpDataSourcePools.get(dsDesc);
        if (bds == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("active_number", bds.getNumActive());
        map.put("idle_number", bds.getNumIdle());
        return map;
    }

    public static synchronized void shutdownDataSource() {
        for (Map.Entry<DataSourceDescription, BasicDataSource> dbs : dbcpDataSourcePools.entrySet()) {
            try {
                dbs.getValue().close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static synchronized boolean testDataSource(DataSourceDescription dsDesc) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(dsDesc.getDriver());
        ds.setUsername(dsDesc.getUsername());
        ds.setPassword(dsDesc.getPassword());
        ds.setUrl(dsDesc.getConnUrl());
        ds.setInitialSize(dsDesc.getInitialSize());
        ds.setMaxTotal(dsDesc.getMaxTotal());
        ds.setMaxIdle(dsDesc.getMaxIdle());
        ds.setMaxWaitMillis((long)dsDesc.getMaxWaitMillis());
        ds.setMinIdle(dsDesc.getMinIdle());
        boolean connOk = false;
        try {
            Connection conn = ds.getConnection();
            if (conn != null) {
                connOk = true;
                conn.close();
            }
            ds.close();
        }
        catch (SQLException e) {
            try {
                ds.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            logger.error(e.getMessage(), (Throwable)e);
        }
        return connOk;
    }

    public static void closeConnect(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

