/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.DBConnect;
import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.HibernateMapInfo;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class PdmReader
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(PdmReader.class);
    private Document doc = null;
    private String sDBSchema = null;
    private List<String> pkColumnIDs;

    public boolean loadPdmFile(String sPath) {
        boolean b = false;
        try (FileInputStream is = new FileInputStream(new File(sPath));){
            SAXReader builder = new SAXReader(false);
            builder.setValidation(false);
            builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            this.doc = builder.read((InputStream)is);
            b = true;
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return b;
    }

    private QName getPdmQName(String sPreFix, String sName) {
        String uri = "attribute";
        if (sPreFix.equals("c")) {
            uri = "collection";
        } else if (sPreFix.equals("o")) {
            uri = "object";
        }
        return new QName(sName, Namespace.get((String)sPreFix, (String)uri), sPreFix + ':' + sName);
    }

    private String getElementText(Element e, String sPreFix, String sName) {
        if (e == null) {
            return null;
        }
        Element f = e.element(this.getPdmQName(sPreFix, sName));
        if (f == null) {
            return null;
        }
        return f.getText();
    }

    private String getAttributeValue(Element e, String xPath) {
        if (e == null) {
            return null;
        }
        Attribute at = (Attribute)e.selectSingleNode(xPath);
        if (at == null) {
            return null;
        }
        return at.getValue();
    }

    public List<Pair<String, String>> getAllTableCode() {
        ArrayList<Pair<String, String>> tabNames = new ArrayList<Pair<String, String>>();
        List tabNodes = this.doc.selectNodes("//c:Tables/o:Table");
        for (Node tNode : tabNodes) {
            tabNames.add((Pair<String, String>)new ImmutablePair((Object)this.getElementText((Element)tNode, "a", "Code"), (Object)this.getElementText((Element)tNode, "a", "Name")));
        }
        return tabNames;
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        Node nTab;
        this.pkColumnIDs = new ArrayList<String>();
        if (this.doc == null) {
            return null;
        }
        SimpleTableInfo tab = new SimpleTableInfo(tabName.toUpperCase());
        if (this.sDBSchema != null) {
            tab.setSchema(this.sDBSchema);
        }
        if ((nTab = this.doc.selectSingleNode("//c:Tables/o:Table[a:Code='" + tabName + "']")) == null) {
            return null;
        }
        Element eTab = (Element)nTab;
        tab.setTableLabelName(this.getElementText(eTab, "a", "Name"));
        tab.setTableComment(this.getElementText(eTab, "a", "Comment"));
        Element elColumns = eTab.element(this.getPdmQName("c", "Columns"));
        if (elColumns == null) {
            return tab;
        }
        List columns = elColumns.elements(this.getPdmQName("o", "Column"));
        for (Element col : columns) {
            SimpleTableField field = new SimpleTableField();
            field.setColumnName(this.getElementText(col, "a", "Code"));
            field.setColumnType(this.getElementText(col, "a", "DataType"));
            String stemp = this.getElementText(col, "a", "Length");
            if (stemp != null) {
                field.setMaxLength(Integer.valueOf(stemp));
                field.setPrecision(Integer.valueOf(stemp));
            }
            if ((stemp = this.getElementText(col, "a", "Precision")) != null) {
                field.setScale(Integer.valueOf(stemp));
            }
            if ((stemp = this.getElementText(col, "a", "Mandatory")) != null) {
                field.setMandatory(stemp);
            }
            field.setFieldLabelName(this.getElementText(col, "a", "Name"));
            field.setColumnComment(this.getElementText(col, "a", "Comment"));
            field.mapToMetadata();
            tab.getColumns().add(field);
        }
        Attribute pkID = (Attribute)eTab.selectSingleNode("c:PrimaryKey/o:Key/@Ref");
        if (pkID == null) {
            return tab;
        }
        String sPkID = pkID.getValue();
        Element elPK = (Element)eTab.selectSingleNode("c:Keys/o:Key[@Id='" + sPkID + "']");
        if (elPK == null) {
            return tab;
        }
        tab.setPkName(this.getElementText(elPK, "a", "Code"));
        List pkColAttr = elPK.selectNodes("c:Key.Columns/o:Column/@Ref");
        for (Node pkCA : pkColAttr) {
            this.pkColumnIDs.add(((Attribute)pkCA).getValue());
            Element elPKCol = (Element)eTab.selectSingleNode("c:Columns/o:Column[@Id='" + ((Attribute)pkCA).getValue() + "']/a:Code");
            if (elPKCol == null) continue;
            tab.getPkColumns().add(elPKCol.getText());
        }
        List elReferences = this.doc.selectNodes("//c:References/o:Reference[c:ParentKey/o:Key/@Ref='" + sPkID + "']");
        for (Node elRef : elReferences) {
            SimpleTableReference ref = new SimpleTableReference();
            ref.setParentTableName(tabName);
            ref.setReferenceCode(((Element)elRef).attributeValue("Id"));
            ref.setReferenceName(this.getElementText((Element)elRef, "a", "Name"));
            String sChildTabID = this.getAttributeValue((Element)elRef, "c:ChildTable/o:Table/@Ref");
            if (sChildTabID == null) {
                sChildTabID = this.getAttributeValue((Element)elRef, "c:Object2/o:Table/@Ref");
            }
            Element eChildTab = null;
            if (sChildTabID != null) {
                eChildTab = (Element)this.doc.selectSingleNode("//c:Tables/o:Table[@Id='" + sChildTabID + "']");
            } else {
                String fpk = this.pkColumnIDs.get(0);
                String ffk = this.getAttributeValue((Element)elRef, "c:Joins/o:ReferenceJoin[c:Object1/o:Column/@Ref='" + fpk + "']/c:Object2/o:Column/@Ref");
                if (ffk != null) {
                    eChildTab = (Element)this.doc.selectSingleNode("//c:Tables/o:Table[c:Columns/o:Column/@Id='" + ffk + "']");
                }
            }
            if (eChildTab == null) continue;
            ref.setTableName(this.getElementText(eChildTab, "a", "Code"));
            for (String pkColID : this.pkColumnIDs) {
                SimpleTableField field = new SimpleTableField();
                String sChildColId = this.getAttributeValue((Element)elRef, "c:Joins/o:ReferenceJoin[c:Object1/o:Column/@Ref='" + pkColID + "']/c:Object2/o:Column/@Ref");
                Element col = (Element)eChildTab.selectSingleNode("c:Columns/o:Column[@Id='" + sChildColId + "']");
                if (col == null) continue;
                field.setColumnName(this.getElementText(col, "a", "Code"));
                field.setColumnType(this.getElementText(col, "a", "DataType"));
                String stemp = this.getElementText(col, "a", "Length");
                if (stemp != null) {
                    field.setMaxLength(Integer.valueOf(stemp));
                    field.setPrecision(Integer.valueOf(stemp));
                }
                if ((stemp = this.getElementText(col, "a", "Precision")) != null) {
                    field.setScale(Integer.valueOf(stemp));
                }
                if ((stemp = this.getElementText(col, "a", "Mandatory")) != null) {
                    field.setMandatory(stemp);
                }
                field.setFieldLabelName(this.getElementText(col, "a", "Name"));
                field.setColumnComment(this.getElementText(col, "a", "Comment"));
                field.mapToMetadata();
                ref.getFkColumns().add(field);
                ref.getReferenceColumns().put(pkColID, field.getColumnName());
            }
            tab.getReferences().add(ref);
        }
        return tab;
    }

    public HibernateMapInfo toHibernateMetadata(SimpleTableInfo tableMeta) {
        HibernateMapInfo hibernateMeta = new HibernateMapInfo();
        hibernateMeta.setClassName(tableMeta.getPackageName() + '.' + tableMeta.getClassName());
        hibernateMeta.setTableName(tableMeta.getTableName().toUpperCase());
        hibernateMeta.setTableLabelName(tableMeta.getTableLabelName());
        hibernateMeta.setTableComment(tableMeta.getTableComment());
        hibernateMeta.setMainTable(true);
        hibernateMeta.setHasID(tableMeta.getPkColumns().size() > 1);
        if (hibernateMeta.isHasID()) {
            hibernateMeta.setIdType(tableMeta.getPackageName() + '.' + tableMeta.getClassName() + "Id");
            hibernateMeta.setIdName("cid");
        } else if (tableMeta.getPkColumns().size() == 1) {
            SimpleTableField field = tableMeta.findField(tableMeta.getPkColumns().get(0));
            hibernateMeta.setIdType(field.getHibernateType());
            hibernateMeta.setIdName(field.getPropertyName());
        }
        for (SimpleTableField col : tableMeta.getColumns()) {
            if (tableMeta.isParmaryKey(col.getColumnName())) {
                hibernateMeta.getKeyProperties().add(col);
                continue;
            }
            hibernateMeta.getProperties().add(col);
        }
        hibernateMeta.setReferences(tableMeta.getReferences());
        return hibernateMeta;
    }

    public HibernateMapInfo getHibernateMetadata(String tabName, String sPackageName) {
        SimpleTableInfo tabMeta = this.getTableMetadata(tabName);
        if (tabMeta == null) {
            return null;
        }
        tabMeta.setPackageName(sPackageName);
        HibernateMapInfo tab = this.toHibernateMetadata(tabMeta);
        for (SimpleTableReference ref : tab.getReferences()) {
            SimpleTableInfo subTabMeta = this.getTableMetadata(ref.getTableName());
            subTabMeta.setPackageName(sPackageName);
            HibernateMapInfo subTab = this.toHibernateMetadata(subTabMeta);
            subTab.setMainTable(false);
            tab.getOne2manys().add(subTab);
        }
        return tab;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        if (schema != null) {
            this.sDBSchema = schema.toUpperCase();
        }
    }

    @Override
    public void setDBConfig(DBConnect dbc) {
    }
}

