/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database;

import com.centit.support.database.DBType;
import com.centit.support.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public final class DataSourceDescription
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(DataSourceDescription.class);
    private static final long serialVersionUID = 1L;
    private String connUrl;
    private String username;
    private String driver;
    private String password;
    private DBType dbType;
    private int maxTotal = 10;
    private int maxIdle = 5;
    private int minIdle;
    private int maxWaitMillis;
    private int initialSize;
    private String databaseCode;

    public String getDatabaseCode() {
        return this.databaseCode;
    }

    public void setDatabaseCode(String databaseCode) {
        this.databaseCode = databaseCode;
    }

    public DataSourceDescription() {
        this.setMinIdle(1);
        this.initialSize = 3;
        this.maxWaitMillis = 10000;
    }

    public DataSourceDescription(String connectURI, String username) {
        this();
        this.setConnUrl(connectURI);
        this.username = username;
    }

    public DataSourceDescription(String connectURI, String username, String pswd) {
        this();
        this.setConnUrl(connectURI);
        this.username = username;
        this.password = pswd;
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
        this.dbType = DBType.mapDBType(connUrl);
        this.driver = DBType.getDbDriver(this.dbType);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(int maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public String getDriver() {
        return this.driver;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public boolean equals(Object dbco) {
        if (this == dbco) {
            return true;
        }
        if (dbco instanceof DataSourceDescription) {
            DataSourceDescription dbc = (DataSourceDescription)dbco;
            return this.connUrl != null && this.connUrl.equals(dbc.getConnUrl()) && this.username != null && this.username.equals(dbc.getUsername());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.connUrl == null ? 0 : this.connUrl.hashCode());
        result = 37 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public void loadHibernateConfig(String sConfFile, String sDbBeanName) {
        SAXReader builder = new SAXReader(false);
        builder.setValidation(false);
        builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document doc = null;
        Element bean = null;
        try {
            doc = sConfFile.indexOf(58) >= 0 ? (sConfFile.startsWith("classpath:") ? builder.read(this.getClass().getResourceAsStream(sConfFile.substring(10))) : builder.read(new File(sConfFile))) : builder.read(this.getClass().getResourceAsStream(sConfFile));
            Element root = doc.getRootElement();
            bean = (Element)root.selectSingleNode("bean[@id=\"" + sDbBeanName + "\"]");
            if (bean != null) {
                Element property = (Element)bean.selectSingleNode("property[@name=\"url\"]");
                if (property != null) {
                    this.connUrl = property.attributeValue("value");
                }
                if ((property = (Element)bean.selectSingleNode("property[@name=\"driverClassName\"]")) != null) {
                    this.driver = property.attributeValue("value");
                }
                if ((property = (Element)bean.selectSingleNode("property[@name=\"username\"]")) != null) {
                    this.username = property.attributeValue("value");
                }
                if ((property = (Element)bean.selectSingleNode("property[@name=\"password\"]")) != null) {
                    this.password = property.attributeValue("value");
                }
            }
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.dbType = DBType.mapDBType(this.connUrl);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public static boolean testConntect(DataSourceDescription dsDesc) {
        boolean connOk = false;
        try {
            Class.forName(dsDesc.getDriver());
            Connection conn = DriverManager.getConnection(dsDesc.getConnUrl(), dsDesc.getUsername(), dsDesc.getPassword());
            connOk = true;
            conn.close();
        }
        catch (ReflectiveOperationException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return connOk;
    }

    public boolean testConntect() {
        return DataSourceDescription.testConntect(this);
    }
}

