/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.DBConnect;
import com.centit.support.database.DatabaseAccessException;
import com.centit.support.database.QueryAndNamedParams;
import com.centit.support.database.QueryAndParams;
import com.centit.support.database.QueryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAccess {
    protected static final Logger logger = LoggerFactory.getLogger(DatabaseAccess.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object callFunction(Connection conn, String procName, int sqlType, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{?=call ");
        procDesc.append(procName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        try (CallableStatement stmt = conn.prepareCall(procDesc.toString());){
            Object rObj;
            stmt.registerOutParameter(1, sqlType);
            for (int i = 0; i < n; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 2, 0);
                    continue;
                }
                if (paramObjs[i] instanceof Date) {
                    stmt.setObject(i + 2, (Object)DatetimeOpt.convertSqlDate((Date)((Date)paramObjs[i])));
                    continue;
                }
                stmt.setObject(i + 2, paramObjs[i]);
            }
            stmt.execute();
            Object object = rObj = stmt.getObject(1);
            return object;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(procDesc.toString(), e);
        }
    }

    public static final boolean callProcedure(Connection conn, String procName, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{call ");
        procDesc.append(procName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        try (CallableStatement stmt = conn.prepareCall(procDesc.toString());){
            for (int i = 0; i < n; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                if (paramObjs[i] instanceof Date) {
                    stmt.setObject(i + 1, (Object)DatetimeOpt.convertSqlDate((Date)((Date)paramObjs[i])));
                    continue;
                }
                stmt.setObject(i + 1, paramObjs[i]);
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(procDesc.toString(), e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean doExecuteSql(Connection conn, String sSql) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final void setQueryStmtParameters(PreparedStatement stmt, Object[] paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.length; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                if (paramObjs[i] instanceof Date) {
                    stmt.setObject(i + 1, DatetimeOpt.convertSqlDate((Date)((Date)paramObjs[i])));
                    continue;
                }
                stmt.setObject(i + 1, paramObjs[i]);
            }
        }
    }

    public static final void setQueryStmtParameters(PreparedStatement stmt, List<Object> paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.size(); ++i) {
                if (paramObjs.get(i) == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                if (paramObjs.get(i) instanceof Date) {
                    stmt.setObject(i + 1, DatetimeOpt.convertSqlDate((Date)((Date)paramObjs.get(i))));
                    continue;
                }
                stmt.setObject(i + 1, paramObjs.get(i));
            }
        }
    }

    public static final int doExecuteSql(Connection conn, String sSql, Object[] values) throws SQLException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            return stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final int doExecuteNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.doExecuteSql(conn, qap.getSql(), qap.getParams());
    }

    public static final JSONObject fetchResultSetRowToJSONObject(ResultSet rs, String[] fieldnames) throws SQLException, IOException {
        if (rs.next()) {
            int cc = rs.getMetaData().getColumnCount();
            int asFn = 0;
            if (fieldnames != null) {
                asFn = fieldnames.length;
            }
            String[] fieldNames = new String[cc];
            for (int i = 0; i < cc; ++i) {
                fieldNames[i] = i < asFn ? fieldnames[i] : DatabaseAccess.mapColumnNameToField(rs.getMetaData().getColumnLabel(i + 1));
            }
            JSONObject jo = new JSONObject();
            for (int i = 0; i < cc; ++i) {
                Object obj = rs.getObject(i + 1);
                if (obj == null) continue;
                if (obj instanceof Clob) {
                    jo.put(fieldNames[i], (Object)DatabaseAccess.fetchClobString((Clob)obj));
                }
                if (obj instanceof Blob) {
                    jo.put(fieldNames[i], (Object)DatabaseAccess.fetchBlobAsBase64((Blob)obj));
                    continue;
                }
                jo.put(fieldNames[i], obj);
            }
            return jo;
        }
        return null;
    }

    public static final JSONArray fetchResultSetToJSONArray(ResultSet rs, String[] fieldnames) throws SQLException, IOException {
        JSONArray ja = new JSONArray();
        int cc = rs.getMetaData().getColumnCount();
        int asFn = 0;
        if (fieldnames != null) {
            asFn = fieldnames.length;
        }
        String[] fieldNames = new String[cc];
        for (int i = 0; i < cc; ++i) {
            fieldNames[i] = i < asFn ? fieldnames[i] : DatabaseAccess.mapColumnNameToField(rs.getMetaData().getColumnLabel(i + 1));
        }
        while (rs.next()) {
            JSONObject jo = new JSONObject();
            for (int i = 0; i < cc; ++i) {
                Object obj = rs.getObject(i + 1);
                if (obj == null) continue;
                if (obj instanceof Clob) {
                    jo.put(fieldNames[i], (Object)DatabaseAccess.fetchClobString((Clob)obj));
                }
                if (obj instanceof Blob) {
                    jo.put(fieldNames[i], (Object)DatabaseAccess.fetchBlobAsBase64((Blob)obj));
                    continue;
                }
                jo.put(fieldNames[i], obj);
            }
            ja.add((Object)jo);
        }
        return ja;
    }

    public static String mapColumnNameToField(String colName) {
        if (colName.indexOf(95) >= 0) {
            int nl = colName.length();
            char[] ch = colName.toCharArray();
            int i = 0;
            int j = 0;
            while (i < nl) {
                if (ch[i] == '_') {
                    ++i;
                    while (i < nl && ch[i] == '_') {
                        ch[j] = 95;
                        ++i;
                        ++j;
                    }
                    if (i >= nl) continue;
                    ch[j] = Character.toUpperCase(ch[i]);
                    ++i;
                    ++j;
                    continue;
                }
                ch[j] = Character.toLowerCase(ch[i]);
                ++i;
                ++j;
            }
            return String.valueOf(ch, 0, j);
        }
        if (colName.charAt(0) >= 'A' && colName.charAt(0) <= 'Z') {
            return colName.toLowerCase();
        }
        return colName;
    }

    public static String[] mapColumnsNameToFields(List<String> colNames) {
        if (colNames == null || colNames.size() == 0) {
            return null;
        }
        String[] fns = new String[colNames.size()];
        for (int i = 0; i < colNames.size(); ++i) {
            fns[i] = DatabaseAccess.mapColumnNameToField(colNames.get(i));
        }
        return fns;
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            ResultSet rs = stmt.executeQuery();
            if (rs == null) {
                return new JSONArray();
            }
            Object[] fns = fieldnames;
            if (ArrayUtils.isEmpty((Object[])fns)) {
                List<String> fields = QueryUtils.getSqlFiledNames(sSql);
                fns = DatabaseAccess.mapColumnsNameToFields(fields);
            }
            JSONArray ja = DatabaseAccess.fetchResultSetToJSONArray(rs, (String[])fns);
            rs.close();
            stmt.close();
            return ja;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, values, null);
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, null, null);
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, null);
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, fieldnames);
    }

    public static final JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames);
    }

    public static final JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), null);
    }

    public static final String fetchClobString(Clob clob) throws IOException {
        try {
            Reader reader = clob.getCharacterStream();
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            int len = 0;
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            reader.close();
            return writer.toString();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] fetchBlobBytes(Blob blob) throws IOException {
        try (InputStream is = blob.getBinaryStream();){
            byte[] readBytes = new byte[is.available()];
            int nl = is.read(readBytes);
            if (nl > 0) {
                byte[] byArray = readBytes;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String fetchBlobAsBase64(Blob blob) throws IOException {
        try (InputStream is = blob.getBinaryStream();){
            byte[] readBytes = new byte[is.available()];
            int nl = is.read(readBytes);
            if (nl > 0) {
                String string = new String(Base64.encodeBase64((byte[])readBytes));
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    public static Object fetchLobField(Object fieldData, boolean blobAsBase64String) {
        if (fieldData == null) {
            return null;
        }
        try {
            if (fieldData instanceof Clob) {
                return DatabaseAccess.fetchClobString((Clob)fieldData);
            }
            if (fieldData instanceof Blob) {
                if (blobAsBase64String) {
                    return DatabaseAccess.fetchBlobAsBase64((Blob)fieldData);
                }
                return DatabaseAccess.fetchBlobBytes((Blob)fieldData);
            }
            return fieldData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final List<Object[]> fetchResultSetToObjectsList(ResultSet rs) throws SQLException, IOException {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        int col = 0;
        Object[] objs = null;
        while (rs.next()) {
            col = rs.getMetaData().getColumnCount();
            objs = new Object[col];
            for (int i = 1; i <= col; ++i) {
                Object obj = rs.getObject(i);
                if (obj instanceof Clob) {
                    objs[i - 1] = DatabaseAccess.fetchClobString((Clob)obj);
                }
                objs[i - 1] = obj instanceof Blob ? DatabaseAccess.fetchBlobAsBase64((Blob)obj) : obj;
            }
            datas.add(objs);
        }
        return datas;
    }

    public static final Object[] fetchResultSetRowToObjects(ResultSet rs) throws SQLException, IOException {
        if (rs.next()) {
            int col = rs.getMetaData().getColumnCount();
            Object[] objs = new Object[col];
            for (int i = 1; i <= col; ++i) {
                Object obj = rs.getObject(i);
                if (obj instanceof Clob) {
                    objs[i - 1] = DatabaseAccess.fetchClobString((Clob)obj);
                }
                objs[i - 1] = obj instanceof Blob ? DatabaseAccess.fetchBlobAsBase64((Blob)obj) : obj;
            }
            return objs;
        }
        return null;
    }

    public static final List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            ResultSet rs = stmt.executeQuery();
            List<Object[]> datas = DatabaseAccess.fetchResultSetToObjectsList(rs);
            rs.close();
            stmt.close();
            return datas;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final List<Object[]> findObjectsBySql(Connection conn, String sSql, List<Object> values) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            ResultSet rs = stmt.executeQuery();
            List<Object[]> datas = DatabaseAccess.fetchResultSetToObjectsList(rs);
            rs.close();
            stmt.close();
            return datas;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final List<Object[]> findObjectsBySql(Connection conn, String sSql, Object value) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, new Object[]{value});
            ResultSet rs = stmt.executeQuery();
            List<Object[]> datas = DatabaseAccess.fetchResultSetToObjectsList(rs);
            rs.close();
            stmt.close();
            return datas;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final List<Object[]> findObjectsBySql(Connection conn, String sSql) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            ResultSet rs = stmt.executeQuery();
            List<Object[]> datas = DatabaseAccess.fetchResultSetToObjectsList(rs);
            rs.close();
            stmt.close();
            return datas;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams());
    }

    public static final Object[] getSingleRow(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static final Object[] getSingleRow(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static final Object[] getSingleRow(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static final Object[] getSingleRow(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static final Object fetchScalarObject(List<Object[]> rsDatas) throws IOException {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        Object[] firstRow = rsDatas.get(0);
        if (firstRow == null || firstRow.length == 0) {
            return null;
        }
        return firstRow[0];
    }

    public static final Object getScalarObjectQuery(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static final Object getScalarObjectQuery(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static final Object getScalarObjectQuery(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static final Object getScalarObjectQuery(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static final Long queryTotalRows(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    public static final Long queryTotalRows(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    public static final List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        try {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            if (pageNo > 0 && pageSize > 0) {
                stmt.setMaxRows(pageNo * pageSize);
            }
            ResultSet rs = stmt.executeQuery();
            if (pageNo > 1 && pageSize > 0) {
                rs.absolute((pageNo - 1) * pageSize);
            }
            List<Object[]> datas = DatabaseAccess.fetchResultSetToObjectsList(rs);
            rs.close();
            stmt.close();
            return datas;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        try {
            Object[] fns;
            ResultSet rs;
            PreparedStatement stmt = conn.prepareStatement(sSql);
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            if (pageNo > 0 && pageSize > 0) {
                stmt.setMaxRows(pageNo * pageSize);
            }
            if ((rs = stmt.executeQuery()) == null) {
                return new JSONArray();
            }
            if (pageNo > 1 && pageSize > 0) {
                rs.absolute((pageNo - 1) * pageSize);
            }
            if (ArrayUtils.isEmpty((Object[])(fns = fieldnames))) {
                List<String> fields = QueryUtils.getSqlFiledNames(sSql);
                fns = DatabaseAccess.mapColumnsNameToFields(fields);
            }
            JSONArray ja = DatabaseAccess.fetchResultSetToJSONArray(rs, (String[])fns);
            rs.close();
            stmt.close();
            return ja;
        }
        catch (SQLException e) {
            throw new DatabaseAccessException(sSql, e);
        }
    }

    public static final List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams(), pageNo, pageSize);
    }

    public static final JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames, pageNo, pageSize);
    }

    public static final List<Object[]> findObjectsBySql(DBConnect conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        String query;
        int offset = pageNo > 1 && pageSize > 0 ? (pageNo - 1) * pageSize : 0;
        switch (conn.getDatabaseType()) {
            case Oracle: {
                query = QueryUtils.buildOracleLimitQuerySQL(sSql, offset, pageSize, false);
                break;
            }
            case DB2: {
                query = QueryUtils.buildDB2LimitQuerySQL(sSql, offset, pageSize);
                break;
            }
            case SqlServer: {
                query = QueryUtils.buildSqlServerLimitQuerySQL(sSql, offset, pageSize);
                break;
            }
            case MySql: {
                query = QueryUtils.buildMySqlLimitQuerySQL(sSql, offset, pageSize, false);
                break;
            }
            default: {
                query = sSql;
            }
        }
        return DatabaseAccess.findObjectsBySql((Connection)conn, query, values);
    }

    public static final JSONArray findObjectsAsJSON(DBConnect conn, String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        String query;
        int offset = pageNo > 1 && pageSize > 0 ? (pageNo - 1) * pageSize : 0;
        switch (conn.getDatabaseType()) {
            case Oracle: {
                query = QueryUtils.buildOracleLimitQuerySQL(sSql, offset, pageSize, false);
                break;
            }
            case DB2: {
                query = QueryUtils.buildDB2LimitQuerySQL(sSql, offset, pageSize);
                break;
            }
            case SqlServer: {
                query = QueryUtils.buildSqlServerLimitQuerySQL(sSql, offset, pageSize);
                break;
            }
            case MySql: {
                query = QueryUtils.buildMySqlLimitQuerySQL(sSql, offset, pageSize, false);
                break;
            }
            default: {
                query = sSql;
            }
        }
        return DatabaseAccess.findObjectsAsJSON((Connection)conn, query, values, fieldnames);
    }

    public static final JSONArray findObjectsAsJSON(DBConnect conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON((Connection)conn, sSql, values, null, pageNo, pageSize);
    }

    public static final List<Object[]> findObjectsByNamedSql(DBConnect conn, String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams(), pageNo, pageSize);
    }

    public static final JSONArray findObjectsByNamedSqlAsJSON(DBConnect conn, String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames, pageNo, pageSize);
    }
}

