/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.ListOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.DBConnect;
import com.centit.support.database.DatabaseAccess;
import com.centit.support.database.QueryUtils;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GeneralJsonObjectDao
implements JsonObjectDao {
    private Connection conn;
    private TableInfo tableInfo;

    public GeneralJsonObjectDao() {
    }

    public GeneralJsonObjectDao(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public GeneralJsonObjectDao(Connection conn) {
        this.conn = conn;
    }

    public GeneralJsonObjectDao(Connection conn, TableInfo tableInfo) {
        this.conn = conn;
        this.tableInfo = tableInfo;
    }

    public void setConnect(DBConnect conn) {
        this.conn = conn;
    }

    public Connection getConnect() {
        return this.conn;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public static Pair<String, String[]> buildFieldSql(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        String[] fieldNames = new String[columns.size()];
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            fieldNames[i] = tableField.getPropertyName();
            ++i;
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)fieldNames);
    }

    public boolean isPkColumn(String propertyName) {
        TableField field = this.tableInfo.findFieldByName(propertyName);
        return this.tableInfo.getPkColumns().contains(field.getColumnName());
    }

    public boolean checkHasAllPkColumns(Map<String, Object> properties) {
        for (String pkc : this.tableInfo.getPkColumns()) {
            TableField field = this.tableInfo.findFieldByColumn(pkc);
            if (field == null || properties.get(field.getPropertyName()) != null) continue;
            return false;
        }
        return true;
    }

    public static String buildFilterSqlByPk(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String plCol : ti.getPkColumns()) {
            if (i > 0) {
                sBuilder.append(" and ");
            }
            TableField col = ti.findFieldByColumn(plCol);
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName()).append(" = :").append(col.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildFilterSql(TableInfo ti, String alias, Collection<String> properties) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String plCol : properties) {
            if (i > 0) {
                sBuilder.append(" and ");
            }
            TableField col = ti.findFieldByName(plCol);
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName()).append(" = :").append(col.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, String[]> buildGetObjectSqlByPk(TableInfo ti) {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSql(ti, null);
        String filter = GeneralJsonObjectDao.buildFilterSqlByPk(ti, null);
        return new ImmutablePair((Object)("select " + (String)q.getLeft() + " from " + ti.getTableName() + " where " + filter), q.getRight());
    }

    @Override
    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        if (this.tableInfo.getPkColumns() == null || this.tableInfo.getPkColumns().size() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(this.tableInfo);
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), QueryUtils.createSqlParamsMap(this.tableInfo.getPkColumns().get(0), keyValue), (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONObject getObjectById(Map<String, Object> keyValues) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(keyValues)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(this.tableInfo);
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), keyValues, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSql(this.tableInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, "select " + (String)q.getLeft() + " from " + this.tableInfo.getTableName() + " where " + filter, properties, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSql(this.tableInfo, null);
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sql, properties, (String[])q.getRight());
    }

    @Override
    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select count(1) as rs from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, sql, properties);
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    private String buildInsertSql(Collection<String> fields) {
        StringBuilder sbInsert = new StringBuilder("insert into ");
        sbInsert.append(this.tableInfo.getTableName()).append(" ( ");
        StringBuilder sbValues = new StringBuilder(" ) values ( ");
        int i = 0;
        for (String f : fields) {
            if (i > 0) {
                sbInsert.append(", ");
                sbValues.append(", ");
            }
            TableField col = this.tableInfo.findFieldByName(f);
            sbInsert.append(col.getColumnName());
            sbValues.append(":").append(f);
            ++i;
        }
        return sbInsert.append((CharSequence)sbValues).append(")").toString();
    }

    @Override
    public int saveNewObject(Map<String, Object> object) throws SQLException {
        String sql = this.buildInsertSql(object.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    private String buildUpdateSql(Collection<String> fields, boolean exceptPk) {
        StringBuilder sbUpdate = new StringBuilder("update ");
        sbUpdate.append(this.tableInfo.getTableName()).append(" set ");
        int i = 0;
        for (String f : fields) {
            if (exceptPk && this.isPkColumn(f)) continue;
            if (i > 0) {
                sbUpdate.append(", ");
            }
            TableField col = this.tableInfo.findFieldByName(f);
            sbUpdate.append(col.getColumnName());
            sbUpdate.append(" = :").append(f);
            ++i;
        }
        return sbUpdate.toString();
    }

    @Override
    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = this.buildUpdateSql(fields, true) + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    @Override
    public int updateObject(Map<String, Object> object) throws SQLException {
        return this.updateObject(object.keySet(), object);
    }

    @Override
    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select count(1) as checkExists from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        Long checkExists = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery(this.conn, sql, object));
        if (checkExists == null || checkExists.intValue() == 0) {
            return this.saveNewObject(object);
        }
        if (checkExists.intValue() == 1) {
            return this.updateObject(fields, object);
        }
        throw new SQLException("\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    @Override
    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.mergeObject(object.keySet(), object);
    }

    @Override
    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        String sql = this.buildUpdateSql(fields, true) + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(fieldValues);
        paramMap.putAll(properties);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, paramMap);
    }

    @Override
    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.updateObjectsByProperties(fieldValues.keySet(), fieldValues, properties);
    }

    @Override
    public int deleteObjectById(Object keyValue) throws SQLException {
        if (this.tableInfo.getPkColumns() == null || this.tableInfo.getPkColumns().size() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, QueryUtils.createSqlParamsMap(this.tableInfo.getPkColumns().get(0), keyValue));
    }

    @Override
    public int deleteObjectById(Map<String, Object> keyValues) throws SQLException {
        if (!this.checkHasAllPkColumns(keyValues)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, keyValues);
    }

    @Override
    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, properties);
    }

    @Override
    public int insertObjectsAsTabulation(JSONArray objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.saveNewObject((Map<String, Object>)((JSONObject)object));
        }
        return resN;
    }

    @Override
    public int deleteObjects(JSONArray objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.deleteObjectById((Map<String, Object>)((JSONObject)object));
        }
        return resN;
    }

    @Override
    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return this.deleteObjectsByProperties(QueryUtils.createSqlParamsMap(propertyName, propertyValue));
    }

    @Override
    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return this.deleteObjectsByProperties(properties);
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, JSONArray dbObjects) throws SQLException {
        Triple comRes = ListOpt.compareTwoList((List)dbObjects, (List)newObjects, (Comparator)new JSONObjectComparator(this.tableInfo));
        int resN = 0;
        for (Object obj : (List)comRes.getLeft()) {
            resN += this.saveNewObject((Map<String, Object>)((JSONObject)obj));
        }
        for (Object obj : (List)comRes.getRight()) {
            resN += this.deleteObjectById((Map<String, Object>)((JSONObject)obj));
        }
        for (Pair pobj : (List)comRes.getMiddle()) {
            resN += this.updateObject((Map<String, Object>)((JSONObject)pobj.getRight()));
        }
        return resN;
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(QueryUtils.createSqlParamsMap(propertyName, propertyValue));
        return this.replaceObjectsAsTabulation(newObjects, dbObjects);
    }

    @Override
    public int replaceObjectsAsTabulation(JSONArray newObjects, Map<String, Object> properties) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(properties);
        return this.replaceObjectsAsTabulation(newObjects, dbObjects);
    }

    public Long getSimulateSequenceNextValue(String sequenceName) throws SQLException, IOException {
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT count(1) hasValue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        Long l = NumberBaseOpt.castObjectToLong((Object)object);
        if (l == 0L) {
            DatabaseAccess.doExecuteSql(this.conn, "insert into simulate_sequence(seqname,currvalue,increment) values(?,?,1)", new Object[]{sequenceName, 1});
            return 1L;
        }
        DatabaseAccess.doExecuteSql(this.conn, "update simulate_sequence currvalue = currvalue + increment where seqname= ?", new Object[]{sequenceName});
        object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT currvalue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsBySql(this.conn, sSql, values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSql(this.conn, sSql, values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public boolean doExecuteSql(String sSql) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql);
    }

    @Override
    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql, values);
    }

    @Override
    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return DatabaseAccess.doExecuteNamedSql(this.conn, sSql, values);
    }

    public class JSONObjectComparator
    implements Comparator<Object> {
        private TableInfo tableInfo;

        public JSONObjectComparator(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public int compare(Object o1, Object o2) {
            for (String pkc : this.tableInfo.getPkColumns()) {
                String s2;
                TableField field = this.tableInfo.findFieldByColumn(pkc);
                Object f1 = ((JSONObject)o1).get((Object)field.getPropertyName());
                Object f2 = ((JSONObject)o2).get((Object)field.getPropertyName());
                if (f1 == null) {
                    if (f2 == null) continue;
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                if (ReflectionOpt.isNumberType(f1.getClass()) && ReflectionOpt.isNumberType(f2.getClass())) {
                    double db2;
                    double db1 = ((Number)f1).doubleValue();
                    if (db1 > (db2 = ((Number)f2).doubleValue())) {
                        return 1;
                    }
                    if (!(db1 < db2)) continue;
                    return -1;
                }
                String s1 = StringBaseOpt.objectToString((Object)f1);
                int nc = s1.compareTo(s2 = StringBaseOpt.objectToString((Object)f2));
                if (nc == 0) continue;
                return nc;
            }
            return 0;
        }
    }
}

