/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSONArray;
import com.centit.support.database.DatabaseAccess;
import com.centit.support.database.QueryUtils;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MySqlJsonObjectDao
extends GeneralJsonObjectDao {
    public MySqlJsonObjectDao() {
    }

    public MySqlJsonObjectDao(Connection conn) {
        super(conn);
    }

    public MySqlJsonObjectDao(TableInfo tableInfo) {
        super(tableInfo);
    }

    public MySqlJsonObjectDao(Connection conn, TableInfo tableInfo) {
        super(conn, tableInfo);
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties, int startPos, int maxSize) throws SQLException, IOException {
        TableInfo tableInfo = this.getTableInfo();
        Pair<String, String[]> q = MySqlJsonObjectDao.buildFieldSql(tableInfo, null);
        String filter = MySqlJsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.getConnect(), QueryUtils.buildMySqlLimitQuerySQL(sql, startPos, maxSize, false), properties, (String[])q.getRight());
    }

    @Override
    public Long getSequenceNextValue(String sequenceName) throws SQLException, IOException {
        return this.getSimulateSequenceNextValue(sequenceName);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsBySql(this.getConnect(), QueryUtils.buildMySqlLimitQuerySQL(sSql, startPos, pageSize, false), values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsByNamedSql(this.getConnect(), QueryUtils.buildMySqlLimitQuerySQL(sSql, startPos, pageSize, false), values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsAsJSON(this.getConnect(), QueryUtils.buildMySqlLimitQuerySQL(sSql, startPos, pageSize, false), values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        int startPos = pageNo > 1 ? (pageNo - 1) * pageSize : 0;
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.getConnect(), QueryUtils.buildMySqlLimitQuerySQL(sSql, startPos, pageSize, false), values, fieldnames);
    }
}

