/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.DBType;
import com.centit.support.database.metadata.TableField;

public class SimpleTableField
implements TableField {
    private String propertyName;
    private String fieldLabelName;
    private String javaType;
    private String columnType;
    private String columnName;
    private String columnComment;
    private String defaultValue;
    private boolean mandatory = false;
    private int maxLength = 0;
    private int precision = 0;
    private int scale = 0;

    public static String mapPropName(String dbObjectName) {
        String sTempName = dbObjectName.toLowerCase();
        String sTemp2Name = dbObjectName.toUpperCase();
        int nl = dbObjectName.length();
        if (nl < 3) {
            return sTempName;
        }
        int i = 0;
        String sPropName = "";
        while (i < nl) {
            if (sTempName.charAt(i) != '_') {
                sPropName = sPropName + sTempName.charAt(i);
                ++i;
                continue;
            }
            if (++i == 2) {
                sPropName = "";
                continue;
            }
            if (i >= nl) continue;
            sPropName = sPropName + sTemp2Name.charAt(i);
            ++i;
        }
        return sPropName;
    }

    public void mapToMetadata() {
        this.propertyName = SimpleTableField.mapPropName(this.columnName);
        this.javaType = SimpleTableField.mapToJavaType(this.columnType, this.scale);
        if (("Long".equals(this.javaType) || "Double".equals(this.javaType)) && this.maxLength <= 0) {
            this.maxLength = 8;
        }
        if (("Date".equals(this.javaType) || "Timestamp".equals(this.javaType)) && this.maxLength <= 0) {
            this.maxLength = 7;
        }
    }

    public static String mapToJavaType(String columnType, int scale) {
        if ("NUMBER".equalsIgnoreCase(columnType) || "INTEGER".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (scale > 0) {
                return "Double";
            }
            return "Long";
        }
        if ("FLOAT".equalsIgnoreCase(columnType)) {
            return "Double";
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType) || "STRING".equalsIgnoreCase(columnType)) {
            return "String";
        }
        if ("DATE".equalsIgnoreCase(columnType) || "TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType)) {
            return "Date";
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType)) {
            return "Timestamp";
        }
        if ("CLOB".equalsIgnoreCase(columnType)) {
            return "String";
        }
        return columnType;
    }

    public static String mapToDatabaseType(String javaType, DBType dbt) {
        switch (javaType) {
            case "Double": 
            case "Float": 
            case "Long": {
                if (dbt == DBType.Oracle) {
                    return "NUMBER";
                }
                return "DECIMAL";
            }
            case "String": {
                if (dbt == DBType.Oracle) {
                    return "VARCHAR2";
                }
                return "VARCHAR";
            }
            case "Date": {
                return "DATE";
            }
            case "Timestamp": {
                return "TIMESTAMP";
            }
        }
        return javaType;
    }

    public String getHibernateType() {
        if (this.javaType != null && (this.javaType.equals("Date") || this.javaType.equals("Timestamp"))) {
            return "java.util." + this.javaType;
        }
        return "java.lang." + this.javaType;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    @Override
    public String getJavaType() {
        return this.javaType;
    }

    public static String trimType(String st) {
        int p = st.lastIndexOf(46);
        if (p > 0) {
            return st.substring(p + 1);
        }
        return st;
    }

    public void setJavaType(String st) {
        this.javaType = SimpleTableField.trimType(st);
    }

    @Override
    public String getFieldLabelName() {
        return this.fieldLabelName;
    }

    public void setFieldLabelName(String desc) {
        this.fieldLabelName = desc;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String column) {
        this.columnName = column;
    }

    @Override
    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String comment) {
        this.columnComment = comment;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean notnull) {
        this.mandatory = notnull;
    }

    public void setMandatory(String notnull) {
        this.mandatory = "true".equalsIgnoreCase(notnull) || "T".equalsIgnoreCase(notnull) || "Y".equalsIgnoreCase(notnull) || "1".equalsIgnoreCase(notnull);
    }

    public void setNullEnable(String nullEnable) {
        this.mandatory = "false".equalsIgnoreCase(nullEnable) || "F".equalsIgnoreCase(nullEnable) || "N".equalsIgnoreCase(nullEnable) || "0".equalsIgnoreCase(nullEnable);
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getColumnType() {
        return this.columnType;
    }

    public void setColumnType(String type) {
        if (type != null) {
            this.columnType = type.trim();
            int nPos = this.columnType.indexOf(40);
            if (nPos > 0) {
                this.columnType = this.columnType.substring(0, nPos);
            }
        }
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

