/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.EnumBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.FieldType;
import com.centit.support.database.utils.PersistenceException;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryLogUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseAccess {
    protected static final Logger logger = LoggerFactory.getLogger(DatabaseAccess.class);

    private DatabaseAccess() {
        throw new IllegalAccessError("Utility class");
    }

    public static SQLException createAccessException(String sql, SQLException e) {
        SQLException exception = new SQLException(sql + " raise " + e.getMessage(), e.getSQLState(), e.getErrorCode(), e.getCause());
        exception.setNextException(e.getNextException());
        exception.setStackTrace(e.getStackTrace());
        return exception;
    }

    private static Object transObjectForSqlParam(Object param) {
        if (param instanceof Date) {
            return param;
        }
        if (param instanceof java.util.Date) {
            return DatetimeOpt.convertToSqlTimestamp((java.util.Date)((java.util.Date)param));
        }
        Class<?> paramClass = param.getClass();
        if (Boolean.class.isAssignableFrom(paramClass)) {
            return BooleanBaseOpt.castObjectToBoolean((Object)param, (Boolean)false) != false ? "T" : "F";
        }
        if (paramClass.isEnum()) {
            return EnumBaseOpt.enumToOrdinal((Object)param);
        }
        if (ReflectionOpt.isScalarType(paramClass) || param instanceof byte[]) {
            return param;
        }
        return JSON.toJSONString((Object)param);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object callFunction(Connection conn, String procName, int sqlType, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{?=call ");
        procDesc.append(procName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        String sqlCen = procDesc.toString();
        QueryLogUtils.printSql(logger, sqlCen);
        try (CallableStatement stmt = conn.prepareCall(sqlCen);){
            stmt.registerOutParameter(1, sqlType);
            for (int i = 0; i < n; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 2, 0);
                    continue;
                }
                stmt.setObject(i + 2, DatabaseAccess.transObjectForSqlParam(paramObjs[i]));
            }
            stmt.execute();
            Object object = stmt.getObject(1);
            return object;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessException(sqlCen, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean callProcedure(Connection conn, String procName, Object ... paramObjs) throws SQLException {
        int n = paramObjs.length;
        StringBuilder procDesc = new StringBuilder("{call ");
        procDesc.append(procName).append("(");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                procDesc.append(",");
            }
            procDesc.append("?");
        }
        procDesc.append(")}");
        String sqlCen = procDesc.toString();
        QueryLogUtils.printSql(logger, sqlCen);
        try (CallableStatement stmt = conn.prepareCall(sqlCen);){
            DatabaseAccess.setQueryStmtParameters((PreparedStatement)stmt, paramObjs);
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessException(sqlCen, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doExecuteSql(Connection conn, String sSql) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            QueryLogUtils.printSql(logger, sSql);
            boolean bl = stmt.execute();
            return bl;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessException(sSql, e);
        }
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, Object[] paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.length; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(paramObjs[i]));
            }
        }
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, List<Object> paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.size(); ++i) {
                if (paramObjs.get(i) == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(paramObjs.get(i)));
            }
        }
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, List<String> paramsName, Map<String, Object> paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramsName.size(); ++i) {
                Object pobj = paramObjs.get(paramsName.get(i));
                if (pobj == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(pobj));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int doExecuteSql(Connection conn, String sSql, Object[] values) throws SQLException {
        QueryLogUtils.printSql(logger, sSql, values);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            DatabaseAccess.setQueryStmtParameters(stmt, values);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessException(sSql, e);
        }
    }

    public static int doExecuteNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.doExecuteSql(conn, qap.getQuery(), qap.getParams());
    }

    private static JSONObject innerFetchResultSetRowToJSONObject(ResultSet rs, int cc, String[] fieldNames) throws SQLException, IOException {
        JSONObject jo = new JSONObject();
        for (int i = 0; i < cc; ++i) {
            Object obj = rs.getObject(i + 1);
            if (obj == null) continue;
            if (obj instanceof Clob) {
                jo.put(fieldNames[i], (Object)DatabaseAccess.fetchClobString((Clob)obj));
                continue;
            }
            if (obj instanceof Blob) {
                jo.put(fieldNames[i], (Object)DatabaseAccess.fetchBlobAsBase64((Blob)obj));
                continue;
            }
            jo.put(fieldNames[i], obj);
        }
        return jo;
    }

    public static JSONObject fetchResultSetRowToJSONObject(ResultSet rs, String[] fieldnames) throws SQLException, IOException {
        if (rs.next()) {
            int cc = rs.getMetaData().getColumnCount();
            String[] fieldNames = new String[cc];
            int asFn = 0;
            if (fieldnames != null) {
                asFn = fieldnames.length;
                System.arraycopy(fieldnames, 0, fieldNames, 0, asFn);
            }
            for (int i = asFn; i < cc; ++i) {
                fieldNames[i] = DatabaseAccess.mapColumnNameToField(rs.getMetaData().getColumnLabel(i + 1));
            }
            return DatabaseAccess.innerFetchResultSetRowToJSONObject(rs, cc, fieldNames);
        }
        return null;
    }

    public static JSONArray fetchResultSetToJSONArray(ResultSet rs, String[] fieldnames) throws SQLException, IOException {
        int i;
        JSONArray ja = new JSONArray();
        int cc = rs.getMetaData().getColumnCount();
        String[] fieldNames = new String[cc];
        int asFn = 0;
        if (fieldnames != null) {
            asFn = fieldnames.length;
            for (i = 0; i < asFn; ++i) {
                fieldNames[i] = StringUtils.isBlank((CharSequence)fieldnames[i]) ? DatabaseAccess.mapColumnNameToField(rs.getMetaData().getColumnLabel(i + 1)) : fieldnames[i];
            }
        }
        for (i = asFn; i < cc; ++i) {
            fieldNames[i] = DatabaseAccess.mapColumnNameToField(rs.getMetaData().getColumnLabel(i + 1));
        }
        while (rs.next()) {
            ja.add((Object)DatabaseAccess.innerFetchResultSetRowToJSONObject(rs, cc, fieldNames));
        }
        return ja;
    }

    @Deprecated
    public static String mapColumnNameToField(String colName) {
        return FieldType.mapToHumpName(colName, false);
    }

    public static String[] mapColumnsNameToFields(List<String> colNames) {
        if (colNames == null || colNames.size() == 0) {
            return null;
        }
        String[] fns = new String[colNames.size()];
        for (int i = 0; i < colNames.size(); ++i) {
            fns[i] = FieldType.mapToHumpName(colNames.get(i), false);
        }
        return fns;
    }

    /*
     * Exception decompiling
     */
    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.getObjectAsJSON(conn, sSql, values, null);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql) throws SQLException, IOException {
        return DatabaseAccess.getObjectAsJSON(conn, sSql, (Object[])null, null);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.getObjectAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.getObjectAsJSON(conn, qap.getQuery(), qap.getParams(), null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, values, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, null, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, fieldnames);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fetchClobString(Clob clob) throws IOException {
        try (Reader reader = clob.getCharacterStream();){
            int len;
            StringWriter writer = new StringWriter();
            char[] buf = new char[4096];
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            String string = writer.toString();
            return string;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] fetchBlobBytes(Blob blob) throws IOException {
        try (InputStream is = blob.getBinaryStream();){
            int len;
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    public static String fetchBlobAsBase64(Blob blob) throws IOException {
        byte[] readBytes = DatabaseAccess.fetchBlobBytes(blob);
        if (readBytes == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])readBytes));
    }

    public static Object fetchLobField(Object fieldData, boolean blobAsBase64String) {
        if (fieldData == null) {
            return null;
        }
        try {
            if (fieldData instanceof Clob) {
                return DatabaseAccess.fetchClobString((Clob)fieldData);
            }
            if (fieldData instanceof Blob) {
                if (blobAsBase64String) {
                    return DatabaseAccess.fetchBlobAsBase64((Blob)fieldData);
                }
                return DatabaseAccess.fetchBlobBytes((Blob)fieldData);
            }
            return fieldData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Object[]> fetchResultSetToObjectsList(ResultSet rs) throws SQLException, IOException {
        ArrayList<Object[]> datas;
        int col = rs.getMetaData().getColumnCount();
        if (rs.next()) {
            datas = new ArrayList<Object[]>();
            datas.add(DatabaseAccess.innerFetchResultSetRowToObjects(rs, col));
        } else {
            return null;
        }
        while (rs.next()) {
            datas.add(DatabaseAccess.innerFetchResultSetRowToObjects(rs, col));
        }
        return datas;
    }

    private static Object[] innerFetchResultSetRowToObjects(ResultSet rs, int col) throws SQLException, IOException {
        Object[] objs = new Object[col];
        for (int i = 1; i <= col; ++i) {
            Object obj = rs.getObject(i);
            objs[i - 1] = obj instanceof Clob ? DatabaseAccess.fetchClobString((Clob)obj) : (obj instanceof Blob ? DatabaseAccess.fetchBlobAsBase64((Blob)obj) : obj);
        }
        return objs;
    }

    public static Object[] fetchResultSetRowToObjects(ResultSet rs) throws SQLException, IOException {
        if (rs.next()) {
            int col = rs.getMetaData().getColumnCount();
            return DatabaseAccess.innerFetchResultSetRowToObjects(rs, col);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, List<Object> values) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object value) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams());
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object fetchScalarObject(List<Object[]> rsDatas) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        Object[] firstRow = rsDatas.get(0);
        if (firstRow == null || firstRow.length == 0) {
            return null;
        }
        return firstRow[0];
    }

    public static List<Object> fetchSingleColumn(List<Object[]> rsDatas, int columnIndex) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        ArrayList<Object> columnData = new ArrayList<Object>(rsDatas.size());
        for (Object[] row : rsDatas) {
            columnData.add(row[columnIndex]);
        }
        return columnData;
    }

    public static List<Object> fetchSingleColumn(List<Object[]> rsDatas) {
        return DatabaseAccess.fetchSingleColumn(rsDatas, 0);
    }

    public static List<String> fetchSingleColumnAsString(List<Object[]> rsDatas, int columnIndex) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        ArrayList<String> columnData = new ArrayList<String>(rsDatas.size());
        for (Object[] row : rsDatas) {
            columnData.add(StringBaseOpt.castObjectToString((Object)row[columnIndex]));
        }
        return columnData;
    }

    public static List<String> fetchSingleColumnAsString(List<Object[]> rsDatas) {
        return DatabaseAccess.fetchSingleColumnAsString(rsDatas, 0);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Long queryTotalRows(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    public static Long queryTotalRows(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    private static String makePageQuerySql(Connection conn, String sSql, int pageNo, int pageSize) throws PersistenceException {
        int offset = pageNo > 1 && pageSize > 0 ? (pageNo - 1) * pageSize : 0;
        return QueryUtils.buildLimitQuerySQL(sSql, offset, pageSize, false, DBType.mapDBType(conn));
    }

    /*
     * Exception decompiling
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, values, null, pageNo, pageSize);
    }

    public static List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams(), pageNo, pageSize);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldnames, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldnames, pageNo, pageSize);
    }
}

