/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.FieldType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTableInfo
implements TableInfo {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleTableInfo.class);
    private List<SimpleTableField> columns = null;
    private String schema;
    private String tableName;
    private String tableType = "T";
    private String tableLabelName;
    private String tableComment;
    private String pkName;
    private String packageName;
    private String orderBy;
    private List<SimpleTableReference> references = null;

    public SimpleTableInfo() {
    }

    public SimpleTableInfo(String tabname) {
        this.setTableName(tabname);
    }

    protected static void writerXMLFile(Document doc, String xmlFile) {
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(xmlFile)));
            output.write(doc);
            output.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tabName) {
        this.tableName = tabName;
    }

    @Override
    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String tabDesc) {
        this.tableLabelName = tabDesc;
    }

    @Override
    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tabComment) {
        this.tableComment = tabComment;
    }

    @Override
    public String getPkName() {
        if (StringUtils.isBlank((CharSequence)this.pkName)) {
            return "PK_" + this.tableName;
        }
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public SimpleTableField findFieldByName(String name) {
        for (SimpleTableField col : this.columns) {
            if (!col.getPropertyName().equals(name)) continue;
            return col;
        }
        for (SimpleTableField col : this.columns) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    @Override
    public SimpleTableField findFieldByColumn(String name) {
        if (this.columns == null) {
            return null;
        }
        for (SimpleTableField col : this.columns) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        for (SimpleTableField col : this.columns) {
            if (!StringUtils.equals((CharSequence)col.getPropertyName(), (CharSequence)name)) continue;
            return col;
        }
        return null;
    }

    public List<SimpleTableField> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SimpleTableField>(20);
        }
        return this.columns;
    }

    public void setColumns(List<SimpleTableField> columns) {
        this.columns = columns;
    }

    public void addColumn(SimpleTableField column) {
        if (this.columns == null) {
            this.columns = new ArrayList<SimpleTableField>(20);
        }
        this.columns.add(column);
    }

    public String getClassName() {
        String sClassName = FieldType.mapPropName(this.tableName);
        return sClassName.substring(0, 1).toUpperCase() + sClassName.substring(1);
    }

    public List<SimpleTableReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<SimpleTableReference>(4);
        }
        return this.references;
    }

    public void setReferences(List<SimpleTableReference> references) {
        this.references = references;
    }

    public boolean hasReferences() {
        return this.references != null && this.references.size() > 0;
    }

    public void addReference(SimpleTableReference reference) {
        if (this.references == null) {
            this.references = new ArrayList<SimpleTableReference>(4);
        }
        this.references.add(reference);
    }

    public SimpleTableReference findReference(String reference) {
        if (this.references == null) {
            return null;
        }
        for (SimpleTableReference ref : this.references) {
            if (!ref.getReferenceName().equals(reference)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setColumnAsPrimaryKey(String colname) {
        SimpleTableField field = this.findFieldByName(colname);
        if (field != null) {
            field.setPrimaryKey(true);
        }
    }
}

