/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.office.commons.SignatureInfo;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;

public abstract class PdfSignatureUtil {
    public static SignatureInfo createSingInfo() {
        return new SignatureInfo();
    }

    public static void sign(InputStream srcStream, OutputStream targetStream, SignatureInfo signatureInfo) {
        try {
            ByteArrayOutputStream tempArrayOutputStream = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(srcStream);
            PdfStamper stamper = PdfStamper.createSignature((PdfReader)reader, (OutputStream)tempArrayOutputStream, (char)'\u0000', null, (boolean)true);
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setReason(signatureInfo.getReasonDesc());
            appearance.setLocation(signatureInfo.getLocationDesc());
            appearance.setVisibleSignature(signatureInfo.getSignRect(), signatureInfo.getSignPage(), signatureInfo.getFieldName());
            appearance.setSignatureGraphic(signatureInfo.getSignImage());
            appearance.setCertificationLevel(signatureInfo.getCertificationLevel());
            appearance.setRenderingMode(signatureInfo.getRenderingMode());
            BouncyCastleDigest digest = new BouncyCastleDigest();
            PrivateKeySignature signature = new PrivateKeySignature(signatureInfo.getPk(), signatureInfo.getDigestAlgorithm(), null);
            MakeSignature.signDetached((PdfSignatureAppearance)appearance, (ExternalDigest)digest, (ExternalSignature)signature, (Certificate[])signatureInfo.getChain(), null, null, null, (int)0, (MakeSignature.CryptoStandard)MakeSignature.CryptoStandard.CADES);
            targetStream.write(tempArrayOutputStream.toByteArray());
            targetStream.flush();
        }
        catch (DocumentException | IOException | GeneralSecurityException e) {
            e.printStackTrace();
        }
    }

    public static void sign(String src, String target, SignatureInfo signatureInfo) {
        try (FileInputStream srcStream = new FileInputStream(new File(src));
             FileOutputStream targetStream = new FileOutputStream(new File(target));){
            PdfSignatureUtil.sign(srcStream, targetStream, signatureInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

