/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office.commons;

import com.centit.support.office.commons.PDFPageEvent;
import com.itextpdf.text.Anchor;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FontUnderline;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2PdfUtils {
    public static int getRGB(org.apache.poi.ss.usermodel.Color color) {
        XSSFColor xssfColor;
        Object[] rgb;
        int result = 0xFFFFFF;
        int red = 0;
        int green = 0;
        int blue = 0;
        if (color instanceof HSSFColor) {
            HSSFColor hssfColor = (HSSFColor)color;
            rgb = hssfColor.getTriplet();
            red = rgb[0];
            green = rgb[1];
            blue = rgb[2];
        }
        if (color instanceof XSSFColor && (rgb = (Object[])(xssfColor = (XSSFColor)color).getRGB()) != null) {
            red = rgb[0] < 0 ? rgb[0] + 256 : rgb[0];
            green = rgb[1] < 0 ? rgb[1] + 256 : rgb[1];
            int n = blue = rgb[2] < 0 ? rgb[2] + 256 : rgb[2];
        }
        if (red != 0 || green != 0 || blue != 0) {
            result = new Color(red, green, blue).getRGB();
        }
        return result;
    }

    public static int getBorderRBG(Workbook wb, short index) {
        HSSFWorkbook hwb;
        HSSFColor color;
        int result = 0;
        if (wb instanceof HSSFWorkbook && (color = (hwb = (HSSFWorkbook)wb).getCustomPalette().getColor(index)) != null) {
            result = Excel2PdfUtils.getRGB((org.apache.poi.ss.usermodel.Color)color);
        }
        if (wb instanceof XSSFWorkbook) {
            XSSFColor color2 = new XSSFColor();
            color2.setIndexed((int)index);
            result = Excel2PdfUtils.getRGB((org.apache.poi.ss.usermodel.Color)color2);
        }
        return result;
    }

    public static CellRangeAddress getColspanRowspanByExcel(Sheet sheet, int rowIndex, int colIndex) {
        CellRangeAddress result = null;
        int num = sheet.getNumMergedRegions();
        for (int i = 0; i < num; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (range.getFirstColumn() != colIndex || range.getFirstRow() != rowIndex) continue;
            result = range;
        }
        return result;
    }

    public static int getPOIColumnWidth(Sheet sheet, Cell cell) {
        int poiCWidth;
        int colWidthpoi = poiCWidth = sheet.getColumnWidth(cell.getColumnIndex());
        int widthPixel = 0;
        widthPixel = colWidthpoi >= 416 ? (int)(((double)colWidthpoi - 416.0) / 256.0 * 8.0 + 13.0 + 0.5) : (int)((double)colWidthpoi / 416.0 * 13.0 + 0.5);
        return widthPixel;
    }

    public static Phrase getPhrase(Workbook wb, Cell cell, boolean hasAnchor, int sheetIndex) {
        if (hasAnchor) {
            return new Phrase(cell.toString(), Excel2PdfUtils.getFontByExcel(wb, cell.getCellStyle()));
        }
        Anchor anchor = new Anchor(cell.toString(), Excel2PdfUtils.getFontByExcel(wb, cell.getCellStyle()));
        anchor.setName("excel_sheet_" + sheetIndex);
        return anchor;
    }

    public static PdfPTable toParseContent(Workbook wb, Sheet sheet, int sheetIndex) throws BadElementException, IOException {
        int rows = sheet.getPhysicalNumberOfRows();
        ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>();
        ArrayList<Integer> colRanges = new ArrayList<Integer>(100);
        float[] widths = new float[]{30.0f, 400.0f};
        float mw = 0.0f;
        boolean hasAnchor = false;
        for (int i = 0; i <= rows; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int columns = row.getLastCellNum();
            if (columns <= 0) {
                for (int k = 0; k < colRanges.size(); ++k) {
                    PdfPCell pdfpCell = new PdfPCell();
                    pdfpCell.setBorder(0);
                    pdfpCell.setFixedHeight(20.0f);
                    cells.add(pdfpCell);
                }
                continue;
            }
            for (int j = colRanges.size(); j < columns; ++j) {
                colRanges.add(i);
            }
            float[] cws = new float[columns];
            for (int j = 0; j < columns; ++j) {
                float cw;
                int lastRow = (Integer)colRanges.get(j);
                if (i < lastRow) continue;
                Cell cell = row.getCell(j);
                if (cell == null) {
                    PdfPCell pdfpCell = new PdfPCell();
                    cells.add(pdfpCell);
                    continue;
                }
                cws[cell.getColumnIndex()] = cw = (float)Excel2PdfUtils.getPOIColumnWidth(sheet, cell);
                CellRangeAddress range = Excel2PdfUtils.getColspanRowspanByExcel(sheet, row.getRowNum(), cell.getColumnIndex());
                int rowspan = 1;
                int colspan = 1;
                if (range != null) {
                    rowspan = range.getLastRow() - range.getFirstRow() + 1;
                    colspan = range.getLastColumn() - range.getFirstColumn() + 1;
                    if (rowspan > 1) {
                        for (int k = 0; k < colspan; ++k) {
                            colRanges.set(j + k, i + rowspan);
                        }
                    }
                    if (colspan > 1) {
                        j += colspan - 1;
                    }
                }
                PdfPCell pdfpCell = new PdfPCell();
                pdfpCell.setBackgroundColor(new BaseColor(Excel2PdfUtils.getRGB(cell.getCellStyle().getFillForegroundColorColor())));
                pdfpCell.setColspan(colspan);
                pdfpCell.setRowspan(rowspan);
                pdfpCell.setVerticalAlignment(Excel2PdfUtils.getVAlignByExcel(cell.getCellStyle().getVerticalAlignment()));
                pdfpCell.setHorizontalAlignment(Excel2PdfUtils.getHAlignByExcel(cell.getCellStyle().getAlignment()));
                pdfpCell.setPhrase(Excel2PdfUtils.getPhrase(wb, cell, hasAnchor, sheetIndex));
                hasAnchor = true;
                if (sheet.getDefaultRowHeightInPoints() != row.getHeightInPoints()) {
                    pdfpCell.setFixedHeight(Excel2PdfUtils.getPixelHeight(row.getHeightInPoints()));
                }
                Excel2PdfUtils.addBorderByExcel(wb, pdfpCell, cell.getCellStyle());
                Excel2PdfUtils.addImageByPOICell(sheet, pdfpCell, cell);
                cells.add(pdfpCell);
            }
            float rw = 0.0f;
            for (int j = 0; j < cws.length; ++j) {
                rw += cws[j];
            }
            if (!(rw > mw) && mw != 0.0f) continue;
            widths = cws;
            mw = rw;
        }
        PdfPTable table = new PdfPTable(widths);
        table.setWidthPercentage(100.0f);
        for (PdfPCell pdfpCell : cells) {
            table.addCell(pdfpCell);
        }
        return table;
    }

    public static void toCreateContentIndexes(Document document, int sheetSize) throws DocumentException {
        PdfPTable table = new PdfPTable(1);
        table.setKeepTogether(true);
        table.getDefaultCell().setBorder(0);
        Font font = new Font(PDFPageEvent.BASE_FONT_CHINESE, 12.0f, 0);
        font.setColor(new BaseColor(0, 0, 255));
        for (int i = 0; i < sheetSize; ++i) {
            Anchor anchor = new Anchor("excel_sheet_" + i, font);
            anchor.setReference("#excel_sheet_" + i);
            PdfPCell cell = new PdfPCell((Phrase)anchor);
            cell.setBorder(0);
            table.addCell(cell);
        }
        document.add((Element)table);
    }

    public static float getPixelHeight(float poiHeight) {
        float pixel = poiHeight / 28.6f * 26.0f;
        return pixel;
    }

    public static void addImageByPOICell(Sheet sheet, PdfPCell pdfpCell, Cell cell) throws BadElementException, IOException {
        HSSFSheet hssfSheet;
        if (sheet instanceof HSSFSheet && (hssfSheet = (HSSFSheet)sheet).getDrawingPatriarch() != null) {
            List shapes = hssfSheet.getDrawingPatriarch().getChildren();
            for (HSSFShape shape : shapes) {
                byte[] bytes;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                HSSFPictureData data = pic.getPictureData();
                int row1 = anchor.getRow1();
                short col1 = anchor.getCol1();
                if (row1 != cell.getRowIndex() || col1 != cell.getColumnIndex() || (bytes = data.getData()) == null) continue;
                pdfpCell.setVerticalAlignment(5);
                pdfpCell.setHorizontalAlignment(1);
                Image image = Image.getInstance((byte[])bytes);
                pdfpCell.setImage(image);
            }
        }
    }

    public static int getVAlignByExcel(VerticalAlignment align) {
        int result = 0;
        if (align == VerticalAlignment.BOTTOM) {
            result = 6;
        }
        if (align == VerticalAlignment.CENTER) {
            result = 5;
        }
        if (align == VerticalAlignment.JUSTIFY) {
            result = 3;
        }
        if (align == VerticalAlignment.TOP) {
            result = 4;
        }
        return result;
    }

    public static int getHAlignByExcel(HorizontalAlignment align) {
        int result = 0;
        if (align == HorizontalAlignment.LEFT) {
            result = 0;
        }
        if (align == HorizontalAlignment.RIGHT) {
            result = 2;
        }
        if (align == HorizontalAlignment.JUSTIFY) {
            result = 3;
        }
        if (align == HorizontalAlignment.CENTER) {
            result = 1;
        }
        return result;
    }

    public static Font getFontByExcel(Workbook wb, CellStyle style) {
        FontUnderline underline;
        HSSFColor color;
        Font result = new Font(PDFPageEvent.BASE_FONT_CHINESE, 8.0f, 0);
        int index = style.getFontIndex();
        org.apache.poi.ss.usermodel.Font font = wb.getFontAt(index);
        if (font.getBold()) {
            result.setStyle(1);
        }
        if ((color = (HSSFColor)HSSFColor.getIndexHash().get(font.getColor())) != null) {
            int rbg = Excel2PdfUtils.getRGB((org.apache.poi.ss.usermodel.Color)color);
            result.setColor(new BaseColor(rbg));
        }
        if ((underline = FontUnderline.valueOf((byte)font.getUnderline())) == FontUnderline.SINGLE) {
            String ulString = Font.FontStyle.UNDERLINE.getValue();
            result.setStyle(ulString);
        }
        return result;
    }

    public static void addBorderByExcel(Workbook wb, PdfPCell cell, CellStyle style) {
        cell.setBorderColorLeft(new BaseColor(Excel2PdfUtils.getBorderRBG(wb, style.getLeftBorderColor())));
        cell.setBorderColorRight(new BaseColor(Excel2PdfUtils.getBorderRBG(wb, style.getRightBorderColor())));
        cell.setBorderColorTop(new BaseColor(Excel2PdfUtils.getBorderRBG(wb, style.getTopBorderColor())));
        cell.setBorderColorBottom(new BaseColor(Excel2PdfUtils.getBorderRBG(wb, style.getBottomBorderColor())));
    }
}

