/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.file.FileSystemOpt;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OfficeToPdf {
    private static Log logger = LogFactory.getLog(OfficeToPdf.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean excel2Pdf(String inExcelFile, String outPdfFile) {
        String inputFile = inExcelFile.replace('/', '\\');
        String pdfFile = outPdfFile.replace('/', '\\');
        ComThread.InitSTA();
        boolean successed = true;
        ActiveXComponent actcom = new ActiveXComponent("Excel.Application");
        int count = 0;
        String outFile = pdfFile.substring(0, pdfFile.lastIndexOf("."));
        try {
            actcom.setProperty("Visible", new Variant(false));
            Dispatch workbooks = actcom.getProperty("Workbooks").toDispatch();
            Dispatch excel = Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{inputFile, new Variant(false), new Variant(false)}, (int[])new int[9]).toDispatch();
            Dispatch sheets = Dispatch.get((Dispatch)excel, (String)"Sheets").toDispatch();
            count = Dispatch.get((Dispatch)sheets, (String)"Count").getInt();
            for (int i = 1; i <= count; ++i) {
                try {
                    Dispatch sheet = Dispatch.invoke((Dispatch)sheets, (String)"Item", (int)2, (Object[])new Object[]{i}, (int[])new int[1]).toDispatch();
                    Dispatch page = Dispatch.call((Dispatch)sheet, (String)"PageSetup").toDispatch();
                    Dispatch.put((Dispatch)page, (String)"PrintArea", (Object)false);
                    Dispatch.put((Dispatch)page, (String)"Orientation", (Object)2);
                    Dispatch.put((Dispatch)page, (String)"Zoom", (Object)false);
                    Dispatch.put((Dispatch)page, (String)"FitToPagesTall", (Object)1);
                    Dispatch.put((Dispatch)page, (String)"FitToPagesWide", (Object)1);
                    Dispatch.call((Dispatch)sheet, (String)"Activate");
                    Dispatch.call((Dispatch)sheet, (String)"Select");
                    Dispatch.invoke((Dispatch)excel, (String)"SaveAs", (int)1, (Object[])new Object[]{outFile + "-" + i + ".pdf", new Variant(57), new Variant(false), new Variant(57), new Variant(57), new Variant(false), new Variant(true), new Variant(57), new Variant(false), new Variant(true), new Variant(false)}, (int[])new int[1]);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("\u53ef\u80fd\u662f\u56e0\u4e3a\u9875\u9762 " + i + " \u6ca1\u6709\u4efb\u4f55\u5143\u7d20\u5bfc\u81f4\u6253\u5370\u5931\u8d25\uff01 " + e.getMessage()));
                }
            }
            Dispatch.call((Dispatch)excel, (String)"Close", (Object[])new Object[]{new Variant(false)});
            if (actcom != null) {
                actcom.invoke("Quit", new Variant[0]);
            }
        }
        catch (Exception es) {
            successed = false;
            es.printStackTrace();
        }
        finally {
            ComThread.Release();
        }
        if (count > 0) {
            try {
                File finalPdf = new File(pdfFile);
                if (finalPdf.exists()) {
                    finalPdf.delete();
                }
                Document document = new Document();
                FileOutputStream out = new FileOutputStream(finalPdf);
                PdfCopy copy = new PdfCopy(document, (OutputStream)out);
                document.open();
                for (int i = 1; i <= count; ++i) {
                    File pdfPieceFile = new File(outFile + "-" + i + ".pdf");
                    if (pdfPieceFile.exists()) {
                        PdfReader reader = new PdfReader(outFile + "-" + i + ".pdf");
                        int n = reader.getNumberOfPages();
                        for (int j = 1; j <= n; ++j) {
                            document.newPage();
                            PdfImportedPage page = copy.getImportedPage(reader, j);
                            copy.addPage(page);
                        }
                        reader.close();
                    }
                    pdfPieceFile.delete();
                }
                copy.close();
                document.close();
                out.flush();
                out.close();
            }
            catch (Exception e) {
                successed = false;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return successed;
    }

    public static boolean excelExportToPdf(String inExcelFile, String outPdfFile) {
        String inFilePath = inExcelFile.replace('/', '\\');
        String outFilePath = outPdfFile.replace('/', '\\');
        ComThread.InitSTA();
        ActiveXComponent ax = new ActiveXComponent("Excel.Application");
        try {
            ax.setProperty("Visible", new Variant(false));
            ax.setProperty("AutomationSecurity", new Variant(3));
            Dispatch excels = ax.getProperty("Workbooks").toDispatch();
            Dispatch excel = Dispatch.invoke((Dispatch)excels, (String)"Open", (int)1, (Object[])new Object[]{inFilePath, new Variant(false), new Variant(false)}, (int[])new int[9]).toDispatch();
            Dispatch.call((Dispatch)excel, (String)"ExportAsFixedFormat", (Object[])new Object[]{new Variant(0), outFilePath});
            Dispatch.call((Dispatch)excel, (String)"Close", (Object[])new Object[]{new Variant(false)});
            if (ax != null) {
                ax.invoke("Quit", new Variant[0]);
                ax = null;
            }
            ComThread.Release();
            return true;
        }
        catch (Exception es) {
            logger.error((Object)es.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ppt2Pdf(String inPptFile, String outPdfFile) {
        String inputFile = inPptFile.replace('/', '\\');
        String pdfFile = outPdfFile.replace('/', '\\');
        ComThread.InitSTA();
        try {
            ActiveXComponent app = new ActiveXComponent("PowerPoint.Application");
            Dispatch ppts = app.getProperty("Presentations").toDispatch();
            Dispatch ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object[])new Object[]{inputFile, true, true, false}).toDispatch();
            File f = new File(pdfFile);
            if (f.exists()) {
                f.delete();
            }
            Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object[])new Object[]{pdfFile, 32});
            Dispatch.call((Dispatch)ppt, (String)"Close");
            app.invoke("Quit");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ComThread.Release();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean word2Pdf(String inWordFile, String outPdfFile) {
        inputFile = inWordFile.replace('/', '\\');
        pdfFile = outPdfFile.replace('/', '\\');
        app = null;
        doc = null;
        ComThread.InitSTA();
        try {
            app = new ActiveXComponent("Word.Application");
            app.setProperty("Visible", new Variant(false));
            docs = app.getProperty("Documents").toDispatch();
            doc = Dispatch.invoke((Dispatch)docs, (String)"Open", (int)1, (Object[])new Object[]{inputFile, new Variant(false), new Variant(true)}, (int[])new int[1]).toDispatch();
            tofile = new File(pdfFile);
            if (tofile.exists()) {
                tofile.delete();
            }
            Dispatch.invoke((Dispatch)doc, (String)"SaveAs", (int)1, (Object[])new Object[]{pdfFile, new Variant(17)}, (int[])new int[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            OfficeToPdf.logger.error((Object)e.getMessage(), (Throwable)e);
            Dispatch.call(doc, (String)"Close", (Object[])new Object[]{false});
            if (app != null) {
                app.invoke("Quit", new Variant[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            {
                catch (Throwable var8_10) {
                    Dispatch.call(doc, (String)"Close", (Object[])new Object[]{false});
                    if (app != null) {
                        app.invoke("Quit", new Variant[0]);
                    }
                    throw var8_10;
                }
            }
            Dispatch.call(doc, (String)"Close", (Object[])new Object[]{false});
            if (app != null) {
                app.invoke("Quit", new Variant[0]);
            } else {
                ** GOTO lbl49
            }
        }
        Dispatch.call((Dispatch)doc, (String)"Close", (Object[])new Object[]{false});
        if (app != null) {
            app.invoke("Quit", new Variant[0]);
        }
        ComThread.Release();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wps2Pdf(String inWpsFile, String outPdfFile) {
        File sFile = new File(inWpsFile.replace('/', '\\'));
        File tFile = new File(outPdfFile.replace('/', '\\'));
        boolean successed = true;
        ActiveXComponent wps = null;
        try {
            ComThread.InitSTA();
            wps = new ActiveXComponent("wps.application");
            ActiveXComponent doc = wps.invokeGetComponent("Documents").invokeGetComponent("Open", new Variant[]{new Variant((Object)sFile.getAbsolutePath())});
            doc.invoke("ExportPdf", new Variant[]{new Variant((Object)tFile.getAbsolutePath())});
            doc.invoke("Close");
            doc.safeRelease();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            successed = false;
        }
        finally {
            if (wps != null) {
                wps.invoke("Terminate");
                wps.safeRelease();
            }
            ComThread.Release();
        }
        return successed;
    }

    public static boolean office2Pdf(String inputFile, String pdfFile) {
        String suffix = inputFile.substring(inputFile.lastIndexOf(".") + 1).toLowerCase();
        File file = new File(inputFile);
        if (!file.exists()) {
            return false;
        }
        if (suffix.equalsIgnoreCase("pdf")) {
            try {
                FileSystemOpt.fileCopy((String)inputFile, (String)pdfFile);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (suffix.equalsIgnoreCase("doc") || suffix.equalsIgnoreCase("docx")) {
            return OfficeToPdf.word2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("pptx")) {
            return OfficeToPdf.ppt2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx") || suffix.equalsIgnoreCase("xlsm")) {
            return OfficeToPdf.excel2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("wps")) {
            return OfficeToPdf.wps2Pdf(inputFile, pdfFile);
        }
        return false;
    }

    public static boolean office2Pdf(String suffix, String inputFile, String pdfFile) {
        File file = new File(inputFile);
        if (!file.exists()) {
            return false;
        }
        if (suffix.equalsIgnoreCase("pdf")) {
            try {
                FileSystemOpt.fileCopy((String)inputFile, (String)pdfFile);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (suffix.equalsIgnoreCase("doc") || suffix.equalsIgnoreCase("docx")) {
            return OfficeToPdf.word2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("pptx")) {
            return OfficeToPdf.ppt2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx") || suffix.equalsIgnoreCase("xlsm")) {
            return OfficeToPdf.excel2Pdf(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("wps")) {
            return OfficeToPdf.wps2Pdf(inputFile, pdfFile);
        }
        return false;
    }
}

