/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.file.FileSystemOpt;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jp.ne.so_net.ga2.no_ji.jcom.IDispatch;
import jp.ne.so_net.ga2.no_ji.jcom.ReleaseManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OfficeToPdf {
    private static Log logger = LogFactory.getLog(OfficeToPdf.class);

    public static boolean excel2PDF(String inputFile, String pdfFile) {
        ComThread.InitSTA();
        ActiveXComponent actcom = new ActiveXComponent("Excel.Application");
        try {
            int i;
            actcom.setProperty("Visible", new Variant(false));
            Dispatch workbooks = actcom.getProperty("Workbooks").toDispatch();
            Dispatch excel = Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{inputFile, new Variant(false), new Variant(false)}, (int[])new int[9]).toDispatch();
            Dispatch sheets = Dispatch.get((Dispatch)excel, (String)"Sheets").toDispatch();
            int count = Dispatch.get((Dispatch)sheets, (String)"Count").getInt();
            String outFile = pdfFile.substring(0, pdfFile.lastIndexOf("."));
            for (i = 1; i <= count; ++i) {
                Dispatch sheet = Dispatch.invoke((Dispatch)sheets, (String)"Item", (int)2, (Object[])new Object[]{i}, (int[])new int[1]).toDispatch();
                Dispatch page = Dispatch.call((Dispatch)sheet, (String)"PageSetup").toDispatch();
                Dispatch.put((Dispatch)page, (String)"PrintArea", (Object)false);
                Dispatch.put((Dispatch)page, (String)"Orientation", (Object)2);
                Dispatch.put((Dispatch)page, (String)"Zoom", (Object)false);
                Dispatch.put((Dispatch)page, (String)"FitToPagesTall", (Object)1);
                Dispatch.put((Dispatch)page, (String)"FitToPagesWide", (Object)1);
                Dispatch.call((Dispatch)sheet, (String)"Activate");
                Dispatch.call((Dispatch)sheet, (String)"Select");
                Dispatch.invoke((Dispatch)excel, (String)"SaveAs", (int)1, (Object[])new Object[]{outFile + "-" + i + ".pdf", new Variant(57), new Variant(false), new Variant(57), new Variant(57), new Variant(false), new Variant(true), new Variant(57), new Variant(false), new Variant(true), new Variant(false)}, (int[])new int[1]);
            }
            if (count > 0) {
                try {
                    File finalPdf = new File(pdfFile);
                    if (finalPdf.exists()) {
                        finalPdf.delete();
                    }
                    Document document = new Document();
                    FileOutputStream out = new FileOutputStream(finalPdf);
                    PdfCopy copy = new PdfCopy(document, (OutputStream)out);
                    document.open();
                    for (int i2 = 1; i2 <= count; ++i2) {
                        PdfReader reader = new PdfReader(outFile + "-" + i2 + ".pdf");
                        int n = reader.getNumberOfPages();
                        for (int j = 1; j <= n; ++j) {
                            document.newPage();
                            PdfImportedPage page = copy.getImportedPage(reader, j);
                            copy.addPage(page);
                        }
                        reader.close();
                    }
                    copy.close();
                    document.close();
                    out.close();
                    out.flush();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            Dispatch.call((Dispatch)excel, (String)"Close", (Object)new Variant(false));
            if (actcom != null) {
                actcom.invoke("Quit", new Variant[0]);
                actcom = null;
            }
            ComThread.Release();
            for (i = 1; i <= count; ++i) {
                boolean isDel;
                File sheetPdf = new File(outFile + "-" + i + ".pdf");
                if (!sheetPdf.exists() || (isDel = sheetPdf.delete())) continue;
                System.gc();
                isDel = sheetPdf.delete();
            }
            return true;
        }
        catch (Exception es) {
            es.printStackTrace();
            return false;
        }
    }

    public static boolean ppt2PDF(String inputFile, String pdfFile) {
        try {
            ActiveXComponent app = new ActiveXComponent("PowerPoint.Application");
            Dispatch ppts = app.getProperty("Presentations").toDispatch();
            Dispatch ppt = Dispatch.call((Dispatch)ppts, (String)"Open", (Object)inputFile, (Object)true, (Object)true, (Object)false).toDispatch();
            File f = new File(pdfFile);
            if (f.exists()) {
                f.delete();
            }
            Dispatch.call((Dispatch)ppt, (String)"SaveAs", (Object)pdfFile, (Object)32);
            Dispatch.call((Dispatch)ppt, (String)"Close");
            app.invoke("Quit");
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean word2PDF(String inputFile, String pdfFile) {
        ReleaseManager rm = null;
        IDispatch app = null;
        try {
            rm = new ReleaseManager();
            app = new IDispatch(rm, "Word.Application");
            app.put("Visible", (Object)false);
            IDispatch docs = (IDispatch)app.get("Documents");
            IDispatch doc = (IDispatch)docs.method("Open", new Object[]{inputFile, false, true});
            File f = new File(pdfFile);
            if (f.exists()) {
                f.delete();
            }
            doc.method("SaveAs", new Object[]{pdfFile, 17});
            doc.method("Close", new Object[]{false});
            app.method("Quit", null);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                app = null;
                if (rm != null) {
                    rm.release();
                    rm = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean office2Pdf(String inputFile, String pdfFile) {
        String suffix = inputFile.substring(inputFile.lastIndexOf(".") + 1).toLowerCase();
        File file = new File(inputFile);
        if (!file.exists()) {
            return false;
        }
        if (suffix.equalsIgnoreCase("pdf")) {
            try {
                FileSystemOpt.fileCopy((String)inputFile, (String)pdfFile);
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (suffix.equalsIgnoreCase("doc") || suffix.equalsIgnoreCase("docx")) {
            return OfficeToPdf.word2PDF(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("pptx")) {
            return OfficeToPdf.ppt2PDF(inputFile, pdfFile);
        }
        if (suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx")) {
            return OfficeToPdf.excel2PDF(inputFile, pdfFile);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excelToPdf(String excelFileName, String pdfFileName, int Orientation) {
        ComThread.InitSTA();
        ActiveXComponent app = new ActiveXComponent("Excel.Application");
        try {
            app.setProperty("Visible", new Variant(false));
            Dispatch workbooks = app.getProperty("Workbooks").toDispatch();
            Dispatch workbook = Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{excelFileName, new Variant(false), new Variant(false)}, (int[])new int[3]).toDispatch();
            Dispatch currentSheet = Dispatch.get((Dispatch)workbook, (String)"ActiveSheet").toDispatch();
            Dispatch page = Dispatch.get((Dispatch)currentSheet, (String)"PageSetup").toDispatch();
            Dispatch.put((Dispatch)page, (String)"PrintArea", (Object)false);
            Dispatch.put((Dispatch)page, (String)"Orientation", (Object)Orientation);
            Dispatch.put((Dispatch)page, (String)"PaperSize", (Object)9);
            Dispatch.put((Dispatch)page, (String)"Zoom", (Object)false);
            Dispatch.put((Dispatch)page, (String)"FitToPagesTall", (Object)false);
            Dispatch.put((Dispatch)page, (String)"FitToPagesWide", (Object)1);
            Variant f = new Variant(false);
            String tempFile = "E://ZJN//ZJN_FILES//";
            File tempDir = new File(tempFile);
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            tempFile = tempFile + "temp.pdf";
            Dispatch.invoke((Dispatch)workbook, (String)"SaveAs", (int)1, (Object[])new Object[]{tempFile, new Variant(57), new Variant(false), new Variant(57), new Variant(57), new Variant(false), new Variant(true), new Variant(57), new Variant(true), new Variant(true), new Variant(true)}, (int[])new int[1]);
            File file = new File(tempFile);
            file.renameTo(new File(pdfFileName));
            file.delete();
            Dispatch.call((Dispatch)workbook, (String)"Close", (Object)f);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (app != null) {
                app.invoke("Quit", new Variant[0]);
            }
            ComThread.Release();
            System.gc();
            System.runFinalization();
        }
    }
}

