/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.office.OfficeToPdf;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Watermark4Pdf {
    public static boolean runFlag = false;
    private static Log logger = LogFactory.getLog(Watermark4Pdf.class);

    public static boolean addWatermark(String inputFile, String waterMarkStr) {
        String tmpPdfFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + DatetimeOpt.convertDateToString((Date)DatetimeOpt.currentUtilDate(), (String)"yyyyMMddHHmmssSSS") + ".pdf";
        String wartermarkFile = inputFile.substring(0, inputFile.lastIndexOf(".")) + ".pdf";
        if (!OfficeToPdf.office2Pdf(inputFile, tmpPdfFile)) {
            return false;
        }
        return Watermark4Pdf.addWatermark4Pdf(tmpPdfFile, wartermarkFile, waterMarkStr, 0.4f, 45.0f, 60.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addWatermark4Pdf(String inputFile, String outputFile, String waterMarkStr, float opacity, float rotation, float fontSize) {
        PdfContentByte content = null;
        BaseFont base = null;
        Rectangle pageRect = null;
        PdfGState gs = new PdfGState();
        PdfReader pdfReader = null;
        PdfStamper pdfStamper = null;
        try {
            pdfReader = new PdfReader(inputFile);
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)new FileOutputStream(outputFile));
            base = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            if (base == null || pdfStamper == null) {
                boolean bl = false;
                return bl;
            }
            gs.setFillOpacity(opacity);
            gs.setStrokeOpacity(opacity);
            int toPage = pdfStamper.getReader().getNumberOfPages();
            for (int i = 1; i <= toPage; ++i) {
                pageRect = pdfStamper.getReader().getPageSizeWithRotation(i);
                float x = pageRect.getWidth() / 2.0f;
                float y = pageRect.getHeight() / 2.0f;
                content = pdfStamper.getOverContent(i);
                content.saveState();
                content.setGState(gs);
                content.beginText();
                content.setColorFill(BaseColor.GRAY);
                content.setFontAndSize(base, fontSize);
                content.showTextAligned(1, waterMarkStr, x, y, rotation);
                content.endText();
            }
        }
        catch (DocumentException | IOException e1) {
            e1.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            content = null;
            base = null;
            pageRect = null;
            try {
                if (pdfReader != null) {
                    pdfReader.close();
                }
                if (pdfStamper != null) {
                    pdfStamper.close();
                }
            }
            catch (DocumentException | IOException e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        return true;
    }
}

